/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.ide.plugin.utils.psi;

import com.alibaba.bizworks.ads.common.context.RuntimeContext;
import com.alibaba.bizworks.ide.common.utils.CollectionExtKt;
import com.alibaba.bizworks.ide.common.utils.StringExtKt;
import com.alibaba.bizworks.ide.plugin.utils.plugin.ContextExtKt;
import com.alibaba.bizworks.ide.plugin.utils.psi.JvmClassUtils;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fj\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011`\u0012H\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u0004J$\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00100\u000fj\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0010`\u0012H\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004J\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0011J)\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00102\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006\"\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u001eJ'\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00112\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006\"\u00020\u0004\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010 \u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0011J\u000e\u0010!\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0004J\u0010\u0010\"\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001a\u001a\u00020\u0011J\u0010\u0010#\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001c\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R'\u0010\b\u001a\u001b\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\n\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/alibaba/bizworks/ide/plugin/utils/psi/JvmClassUtils;", "", "()V", "CLASS_CACHE_KEY", "", "JAVA_BASIC_METHODS", "", "[Ljava/lang/String;", "PRIMITIVE_TYPES", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/psi/PsiPrimitiveType;", "kotlin.jvm.PlatformType", "TYPE_CACHE_KEY", "getClassCacheInContext", "Ljava/util/LinkedHashMap;", "Lcom/intellij/psi/PsiClass;", "Lcom/intellij/psi/PsiType;", "Lkotlin/collections/LinkedHashMap;", "getPrimitiveType", "typeName", "getTypeCacheInContext", "isBasicMethod", "", "methodName", "isEnum", "psiType", "isInheritor", "psiClass", "baseClass", "(Lcom/intellij/psi/PsiClass;[Ljava/lang/String;)Z", "(Lcom/intellij/psi/PsiType;[Ljava/lang/String;)Z", "isInterface", "isPrimitive", "resolvePsiClass", "resolvePsiType", "plugin-common"})
public final class JvmClassUtils {
    @NotNull
    public static final JvmClassUtils INSTANCE = new JvmClassUtils();
    @NotNull
    private static final String CLASS_CACHE_KEY = "__JVM_CLASS_CACHE_KEY";
    @NotNull
    private static final String TYPE_CACHE_KEY = "__JVM_TYPE_CACHE_KEY";
    @NotNull
    private static final String[] JAVA_BASIC_METHODS;
    @NotNull
    private static final Map<String, PsiPrimitiveType> PRIMITIVE_TYPES;

    private JvmClassUtils() {
    }

    private final LinkedHashMap<PsiClass, PsiType> getClassCacheInContext() {
        return (LinkedHashMap)RuntimeContext.Companion.computeIfAbsent(CLASS_CACHE_KEY, (Function1)getClassCacheInContext.1.INSTANCE);
    }

    private final LinkedHashMap<PsiType, PsiClass> getTypeCacheInContext() {
        return (LinkedHashMap)RuntimeContext.Companion.computeIfAbsent(TYPE_CACHE_KEY, (Function1)getTypeCacheInContext.1.INSTANCE);
    }

    @Nullable
    public final PsiType resolvePsiType(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        return (PsiType)CollectionExtKt.computeSafeIfAbsent((Map)this.getClassCacheInContext(), (Object)psiClass, (Function1)((Function1)new Function1<PsiClass, PsiType>(psiClass){
            final /* synthetic */ PsiClass $psiClass;
            {
                this.$psiClass = $psiClass;
                super(1);
            }

            @Nullable
            public final PsiType invoke(@NotNull PsiClass it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (PsiType)PsiTypesUtil.getClassType((PsiClass)this.$psiClass);
            }
        }));
    }

    @Nullable
    public final PsiClass resolvePsiClass(@NotNull PsiType psiType) {
        Intrinsics.checkNotNullParameter((Object)psiType, (String)"psiType");
        if (psiType instanceof PsiArrayType) {
            return null;
        }
        return (PsiClass)CollectionExtKt.computeSafeIfAbsent((Map)this.getTypeCacheInContext(), (Object)psiType, (Function1)((Function1)new Function1<PsiType, PsiClass>(psiType){
            final /* synthetic */ PsiType $psiType;
            {
                this.$psiType = $psiType;
                super(1);
            }

            @Nullable
            public final PsiClass invoke(@NotNull PsiType it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return PsiUtil.resolveClassInType((PsiType)this.$psiType);
            }
        }));
    }

    @Nullable
    public final PsiType getPrimitiveType(@NotNull String typeName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        return (PsiType)PRIMITIVE_TYPES.get(typeName);
    }

    public final boolean isPrimitive(@NotNull String typeName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        return PRIMITIVE_TYPES.containsKey(typeName);
    }

    public final boolean isBasicMethod(@NotNull String methodName) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        return ArraysKt.contains((Object[])JAVA_BASIC_METHODS, (Object)methodName);
    }

    public final boolean isInterface(@NotNull PsiType psiType) {
        PsiClass cls;
        Intrinsics.checkNotNullParameter((Object)psiType, (String)"psiType");
        PsiClass psiClass = cls = this.resolvePsiClass(psiType);
        return psiClass != null ? psiClass.isInterface() : false;
    }

    public final boolean isEnum(@NotNull PsiType psiType) {
        PsiClass cls;
        Intrinsics.checkNotNullParameter((Object)psiType, (String)"psiType");
        PsiClass psiClass = cls = this.resolvePsiClass(psiType);
        return psiClass != null ? psiClass.isEnum() : false;
    }

    public final boolean isInheritor(@NotNull PsiType psiType, String ... baseClass) {
        Intrinsics.checkNotNullParameter((Object)psiType, (String)"psiType");
        Intrinsics.checkNotNullParameter((Object)baseClass, (String)"baseClass");
        psiType.getCanonicalText();
        String string = psiType.getCanonicalText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
        if (ArraysKt.contains((Object[])baseClass, (Object)StringExtKt.removeParameterType((String)string))) {
            return true;
        }
        PsiClass cls = this.resolvePsiClass(psiType);
        if (cls != null) {
            return this.isInheritor(cls, Arrays.copyOf(baseClass, baseClass.length));
        }
        return false;
    }

    private final boolean isInheritor(PsiClass psiClass, String ... baseClass) {
        Boolean bl = (Boolean)ContextExtKt.runInReadAction(RuntimeContext.Companion, (Function0)new Function0<Boolean>(baseClass, psiClass){
            final /* synthetic */ String[] $baseClass;
            final /* synthetic */ PsiClass $psiClass;
            {
                this.$baseClass = $baseClass;
                this.$psiClass = $psiClass;
                super(0);
            }

            @Nullable
            public final Boolean invoke() {
                Object[] $this$forEach$iv;
                if (ArraysKt.contains((Object[])this.$baseClass, (Object)this.$psiClass.getQualifiedName())) {
                    return true;
                }
                PsiClass[] psiClassArray = this.$psiClass.getSupers();
                Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getSupers(...)");
                Object[] objectArray = psiClassArray;
                Object[] objectArray2 = this.$baseClass;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PsiClass superClass = (PsiClass)element$iv;
                    boolean bl = false;
                    String superFqn = superClass.getQualifiedName();
                    if (ArraysKt.contains((Object[])objectArray2, (Object)superFqn)) {
                        return true;
                    }
                    PsiClass[] psiClassArray2 = superClass.getInterfaces();
                    Intrinsics.checkNotNullExpressionValue((Object)psiClassArray2, (String)"getInterfaces(...)");
                    Object[] $this$forEach$iv2 = psiClassArray2;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        PsiClass it = (PsiClass)element$iv2;
                        boolean bl2 = false;
                        if (!ArraysKt.contains((Object[])objectArray2, (Object)it.getQualifiedName())) continue;
                        return true;
                    }
                }
                PsiClass[] psiClassArray3 = this.$psiClass.getInterfaces();
                Intrinsics.checkNotNullExpressionValue((Object)psiClassArray3, (String)"getInterfaces(...)");
                $this$forEach$iv = psiClassArray3;
                objectArray2 = this.$baseClass;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PsiClass it = (PsiClass)element$iv;
                    boolean bl = false;
                    if (!ArraysKt.contains((Object[])objectArray2, (Object)it.getQualifiedName())) continue;
                    return true;
                }
                return false;
            }
        });
        return bl != null ? bl : false;
    }

    static {
        String[] stringArray = new String[]{"registerNatives", "getClass", "hashCode", "equals", "clone", "toString", "notify", "notifyAll", "wait", "finalize"};
        JAVA_BASIC_METHODS = stringArray;
        stringArray = new Pair[]{TuplesKt.to((Object)PsiType.VOID.getCanonicalText(), (Object)PsiType.VOID), TuplesKt.to((Object)PsiType.BYTE.getCanonicalText(), (Object)PsiType.BYTE), TuplesKt.to((Object)PsiType.CHAR.getCanonicalText(), (Object)PsiType.CHAR), TuplesKt.to((Object)PsiType.DOUBLE.getCanonicalText(), (Object)PsiType.DOUBLE), TuplesKt.to((Object)PsiType.FLOAT.getCanonicalText(), (Object)PsiType.FLOAT), TuplesKt.to((Object)PsiType.LONG.getCanonicalText(), (Object)PsiType.LONG), TuplesKt.to((Object)PsiType.INT.getCanonicalText(), (Object)PsiType.INT), TuplesKt.to((Object)PsiType.SHORT.getCanonicalText(), (Object)PsiType.SHORT), TuplesKt.to((Object)PsiType.BOOLEAN.getCanonicalText(), (Object)PsiType.BOOLEAN)};
        PRIMITIVE_TYPES = MapsKt.mapOf((Pair[])stringArray);
    }
}

