/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.codeinsight;

import com.alibaba.bizworks.codeinsight.CreateMavenProjectRequest;
import com.alibaba.bizworks.codeinsight.DefaultSourceGenerator;
import com.alibaba.bizworks.codeinsight.GenerateProjectSourceByDSLRequest;
import com.alibaba.bizworks.codeinsight.adl.AdlBoundedContext;
import com.alibaba.bizworks.codeinsight.adl.AdlCodeGenModel;
import com.alibaba.bizworks.codeinsight.model.ComponentDescriptor;
import com.alibaba.bizworks.codeinsight.utils.DemoHelper;
import com.alibaba.bizworks.codeinsight.utils.JacksonUtils;
import com.alibaba.bizworks.codeinsight.utils.PackageNameValidator;
import com.alibaba.bizworks.codeinsight.utils.ProjectMeta;
import com.alibaba.bizworks.codeinsight.utils.YamlUtils;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MavenProjectGenerator {
    public static final MavenProjectGenerator INSTANCE = new MavenProjectGenerator();

    public void generateProjectSourceByDSL(GenerateProjectSourceByDSLRequest request) {
        this.generateProjectSourceByDSL(request, false);
    }

    public void generateProjectSourceByDSL(GenerateProjectSourceByDSLRequest request, Boolean full) {
        CharSequence metadataFileName;
        List<AdlBoundedContext> boundedContexts;
        AdlCodeGenModel one;
        Map<String, String> dslJsonsMap = request.getDslJsonsMap();
        List<String> dslJsons = request.getDslJsons();
        if ((dslJsonsMap == null || dslJsonsMap.isEmpty()) && (dslJsons == null || dslJsons.isEmpty())) {
            return;
        }
        String projectPath = request.getProjectPath();
        File project = new File(projectPath);
        if (!project.exists()) {
            throw new RuntimeException("project path not exists: " + projectPath);
        }
        AdlCodeGenModel adlCodegenUnit = new AdlCodeGenModel();
        adlCodegenUnit.setBoundedContexts(new ArrayList<AdlBoundedContext>());
        if (dslJsonsMap != null && !dslJsonsMap.isEmpty()) {
            for (Map.Entry entry : dslJsonsMap.entrySet()) {
                one = JacksonUtils.readValue((String)entry.getValue(), AdlCodeGenModel.class);
                boundedContexts = one.getBoundedContexts();
                adlCodegenUnit.getBoundedContexts().addAll(boundedContexts);
                metadataFileName = (String)entry.getKey();
                try {
                    Files.write((byte[])((String)entry.getValue()).getBytes(), (File)new File(projectPath + "/metadata/" + (String)metadataFileName + ".json"));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        } else if (dslJsons != null && !dslJsons.isEmpty()) {
            for (String string : dslJsons) {
                one = JacksonUtils.readValue(string, AdlCodeGenModel.class);
                boundedContexts = one.getBoundedContexts();
                adlCodegenUnit.getBoundedContexts().addAll(boundedContexts);
                if (boundedContexts == null || boundedContexts.isEmpty()) continue;
                metadataFileName = new StringBuffer();
                for (AdlBoundedContext boundedContext : boundedContexts) {
                    if (((StringBuffer)metadataFileName).length() > 0) {
                        ((StringBuffer)metadataFileName).append("-");
                    }
                    ((StringBuffer)metadataFileName).append(boundedContext.getName().getText());
                }
                try {
                    File file = new File(projectPath + "/metadata/" + metadataFileName + ".json");
                    File parentDir = file.getParentFile();
                    if (parentDir != null && !parentDir.exists()) {
                        parentDir.mkdirs();
                    }
                    Files.write((byte[])string.getBytes(), (File)file);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        ComponentDescriptor componentDescriptor = YamlUtils.loadComponentDescriptorYaml(projectPath + "/component-descriptor.yaml");
        String string = componentDescriptor.getMetadata().getGroup();
        String artifactId = componentDescriptor.getMetadata().getName();
        String parentRootPath = projectPath.substring(0, projectPath.lastIndexOf("/"));
        String projectName = componentDescriptor.getMetadata().getName();
        new DefaultSourceGenerator().generate(adlCodegenUnit, ProjectMeta.builder().groupId(string).artifactId(artifactId).withLombok(true).parentRootPath(parentRootPath).projectName(projectName).build(), full);
    }

    public void createMavenProject(CreateMavenProjectRequest request) {
        File gitIgnore;
        File runSh;
        File parentRoot = new File(request.getParentRootPath());
        if (!parentRoot.exists()) {
            throw new RuntimeException("parent root path not exists: " + request.getParentRootPath());
        }
        File project = new File(parentRoot, request.getProjectName());
        if (!project.exists() && !project.mkdirs()) {
            throw new RuntimeException("failed to create project directory: " + project.getAbsolutePath());
        }
        String group = request.getGroup();
        if (!PackageNameValidator.isValidPackageName(group)) {
            throw new RuntimeException("invalid group name: " + group);
        }
        this.createComponentDescriptorYaml(request);
        File dsl = new File(project, "adl");
        if (!dsl.exists() && !dsl.mkdirs()) {
            throw new RuntimeException("failed to create adl directory: " + dsl.getAbsolutePath());
        }
        File metadata = new File(project, "metadata");
        if (!metadata.exists() && !metadata.mkdirs()) {
            throw new RuntimeException("failed to create metadata directory: " + metadata.getAbsolutePath());
        }
        File buildSh = new File(project, "build.sh");
        if (!buildSh.exists()) {
            try {
                Files.write((byte[])"mvn clean install".getBytes(), (File)buildSh);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!(runSh = new File(project, "run.sh")).exists()) {
            try {
                String version = request.getVersion() == null ? "1.0.0" : request.getVersion();
                String content = "x=${1:-\"\"}\nif [ -n \"$x\" ]; then\n  JAVA_OPS=\"$JAVA_OPS $x\"\n  echo \"JAVA_OPS: $JAVA_OPS\"\nfi\njava $JAVA_OPS -jar " + request.getProjectName() + "-starter/target/" + request.getProjectName() + "-starter-" + version + ".jar";
                Files.write((byte[])content.getBytes(), (File)runSh);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!(gitIgnore = new File(project, ".gitignore")).exists()) {
            try {
                Files.write((byte[])DemoHelper.loadDemoContent("gitignore").getBytes(), (File)gitIgnore);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (request.getIsGenDemo().booleanValue()) {
            MavenProjectGenerator.createDemoDSL(dsl);
            this.createDemoMetadata(metadata);
            this.createDemoProjectSource(request);
        }
    }

    private void createDemoMetadata(File metadata) {
        String json = DemoHelper.loadDemoContent("demo.json");
        File demo = new File(metadata, "demo.json");
        if (!demo.exists()) {
            try {
                Files.write((byte[])json.getBytes(), (File)demo);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void createDemoProjectSource(CreateMavenProjectRequest request) {
        String json = DemoHelper.loadDemoContent("demo.json");
        AdlCodeGenModel adlCodegenUnit = JacksonUtils.readValue(json, AdlCodeGenModel.class);
        new DefaultSourceGenerator().generate(adlCodegenUnit, ProjectMeta.builder().groupId(request.getGroup()).artifactId(request.getProjectName()).withLombok(true).parentRootPath(request.getParentRootPath()).projectName(request.getProjectName()).build());
    }

    private static void createDemoDSL(File dsl) {
        String adlContent = DemoHelper.loadDemoContent("demo.adl");
        File adl = new File(dsl, "demo.adl");
        try {
            Files.write((byte[])adlContent.getBytes(), (File)adl);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void createComponentDescriptorYaml(CreateMavenProjectRequest request) {
        ComponentDescriptor componentDescriptor = new ComponentDescriptor();
        componentDescriptor.setApiVersion("pbc.bizworks.com/v1alpha");
        componentDescriptor.setKind("SVC");
        ComponentDescriptor.Metadata metadata = new ComponentDescriptor.Metadata();
        metadata.setGroup(request.getGroup());
        metadata.setName(request.getProjectName());
        metadata.setDescription(request.getDescription());
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("language", request.getLanguage());
        labels.put("framework", request.getFramework());
        labels.put("scaffoldStyle", request.getArchitectureTemplate());
        metadata.setLabels(labels);
        componentDescriptor.setMetadata(metadata);
        ComponentDescriptor.Spec spec = new ComponentDescriptor.Spec();
        componentDescriptor.setSpec(spec);
        ComponentDescriptor.Lifecycle lifecycle = new ComponentDescriptor.Lifecycle();
        componentDescriptor.setLifecycle(lifecycle);
        YamlUtils.saveYaml(componentDescriptor, request.getParentRootPath() + "/" + request.getProjectName() + "/component-descriptor.yaml");
    }
}

