/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.codeinsight.generator.java;

import com.alibaba.bizworks.codeinsight.adl.AdlDeclaration;
import com.alibaba.bizworks.codeinsight.generator.java.CompilationUnitGenerator;
import com.alibaba.bizworks.codeinsight.generator.java.GeneratedCodeMeta;
import com.alibaba.bizworks.codeinsight.utils.AdlTypeConvertor;
import com.alibaba.bizworks.codeinsight.utils.AnnotationMeta;
import com.alibaba.bizworks.codeinsight.utils.ClassMeta;
import com.alibaba.bizworks.codeinsight.utils.JavaParserHelper;
import com.alibaba.bizworks.codeinsight.utils.ModuleMeta;
import com.alibaba.bizworks.codeinsight.utils.PackageHelper;
import com.alibaba.bizworks.codeinsight.utils.ProjectMeta;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.LineComment;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DomainObjectCompilationUnitGenerator
implements CompilationUnitGenerator {
    protected final AdlDeclaration adlDeclaration;
    protected final ProjectMeta projectMeta;
    protected final ModuleMeta moduleMeta;

    DomainObjectCompilationUnitGenerator(AdlDeclaration adlDeclaration, ProjectMeta projectMeta, ModuleMeta moduleMeta) {
        this.adlDeclaration = adlDeclaration;
        this.projectMeta = projectMeta;
        this.moduleMeta = moduleMeta;
    }

    protected GeneratedCodeMeta generateEntity() {
        List<AdlDeclaration> serviceFuncList;
        String cuName = this.adlDeclaration.getName().getText();
        CompilationUnit cu = new CompilationUnit();
        cu.setPackageDeclaration(PackageHelper.getDomainObjectPackage(this.projectMeta.getGroupId(), this.projectMeta.getArtifactIdForPackage(), this.moduleMeta.getBoundContextName()));
        ClassOrInterfaceDeclaration cid = cu.addClass(cuName);
        cid.setModifiers(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        if (this.projectMeta.isWithLombok()) {
            JavaParserHelper.addBeanLombokAnnotations(cid, this.adlDeclaration);
        }
        AnnotationMeta domainObjectAnnotationMeta = AnnotationMeta.create("com.alibaba.bizworks.core.specification.ddd.DomainObject").addString("name", cuName).addString("boundedContext", this.moduleMeta.getBoundContextName());
        JavaParserHelper.addAnnotation((NodeWithAnnotations)cid, domainObjectAnnotationMeta);
        AdlTypeConvertor adlTypeConvertor = new AdlTypeConvertor(this.projectMeta, this.moduleMeta);
        List<AdlDeclaration> memberVarList = this.adlDeclaration.getMemberVarList();
        if (memberVarList != null && !memberVarList.isEmpty()) {
            for (AdlDeclaration memberVar : memberVarList) {
                ClassMeta classMeta = adlTypeConvertor.to(memberVar.getType());
                JavaParserHelper.addField(cid, classMeta, memberVar.getName().getText());
                JavaParserHelper.addImportIfNecessary(cu, classMeta);
            }
        }
        if ((serviceFuncList = this.adlDeclaration.getFuncList()) != null && !serviceFuncList.isEmpty()) {
            for (AdlDeclaration func : serviceFuncList) {
                String methodName = func.getName().getText();
                MethodDeclaration methodDeclaration = cid.addMethod(methodName, new Modifier.Keyword[0]);
                methodDeclaration.setModifiers(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
                JavaParserHelper.addAnnotation((NodeWithAnnotations)methodDeclaration, AnnotationMeta.create("com.alibaba.bizworks.core.specification.ReturnValue"));
                JavaParserHelper.addAnnotation((NodeWithAnnotations)methodDeclaration, AnnotationMeta.create("com.alibaba.bizworks.core.specification.Method").addString("name", methodName).addString("desc", methodName));
                List<AdlDeclaration> parameters = func.getParameters();
                if (parameters != null && !parameters.isEmpty()) {
                    for (AdlDeclaration parameter : parameters) {
                        ClassMeta classMeta = adlTypeConvertor.to(parameter.getType());
                        Parameter p = methodDeclaration.addAndGetParameter(classMeta.getSimpleName(), parameter.getName().getText());
                        JavaParserHelper.addAnnotation((NodeWithAnnotations)p, AnnotationMeta.create("com.alibaba.bizworks.core.specification.Parameter"));
                    }
                }
                ClassMeta classMeta = adlTypeConvertor.to(func.getReturnType());
                methodDeclaration.setType(classMeta.getSimpleName());
                BlockStmt body = new BlockStmt();
                methodDeclaration.setBody(body);
                body.addOrphanComment((Comment)new LineComment(" TODO: implement method"));
                if (classMeta.isVoid()) continue;
                body.addStatement((Statement)new ReturnStmt((Expression)new NullLiteralExpr()));
            }
        }
        JavaParserHelper.sortImports(cu);
        return new GeneratedCodeMeta(cu, this.getOrCreatePath(), ((PackageDeclaration)cu.getPackageDeclaration().get()).getNameAsString(), cuName);
    }

    @Override
    public List<GeneratedCodeMeta> generate() {
        ArrayList<GeneratedCodeMeta> generatedCodeMetas = new ArrayList<GeneratedCodeMeta>();
        generatedCodeMetas.add(this.generateEntity());
        return generatedCodeMetas;
    }

    private String getOrCreatePath() {
        String bdctx = this.moduleMeta.getBoundContextNameAsCode();
        String path = this.projectMeta.getProjectRootPath() + "/" + bdctx + "/" + bdctx + "-domain/src/main/java";
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return path;
    }
}

