/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.codeinsight.generator.java;

import com.alibaba.bizworks.codeinsight.adl.AdlDeclaration;
import com.alibaba.bizworks.codeinsight.generator.java.CompilationUnitGenerator;
import com.alibaba.bizworks.codeinsight.generator.java.GeneratedCodeMeta;
import com.alibaba.bizworks.codeinsight.utils.AdlTypeConvertor;
import com.alibaba.bizworks.codeinsight.utils.AnnotationMeta;
import com.alibaba.bizworks.codeinsight.utils.ClassMeta;
import com.alibaba.bizworks.codeinsight.utils.JavaParserHelper;
import com.alibaba.bizworks.codeinsight.utils.ModuleMeta;
import com.alibaba.bizworks.codeinsight.utils.PackageHelper;
import com.alibaba.bizworks.codeinsight.utils.ProjectMeta;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class StructureObjectCompilationUnitGenerator
implements CompilationUnitGenerator {
    private final AdlDeclaration adlDeclaration;
    private final ProjectMeta projectMeta;
    private final ModuleMeta moduleMeta;

    StructureObjectCompilationUnitGenerator(AdlDeclaration adlDeclaration, ProjectMeta projectMeta, ModuleMeta moduleMeta) {
        this.adlDeclaration = adlDeclaration;
        this.projectMeta = projectMeta;
        this.moduleMeta = moduleMeta;
    }

    private GeneratedCodeMeta generateEntity() {
        String cuName = this.adlDeclaration.getName().getText();
        CompilationUnit cu = new CompilationUnit();
        cu.setPackageDeclaration(PackageHelper.getStructureObjectPackage(this.projectMeta.getGroupId(), this.projectMeta.getArtifactIdForPackage(), this.moduleMeta.getBoundContextName()));
        ClassOrInterfaceDeclaration cid = cu.addClass(cuName);
        cid.setModifiers(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        if (this.projectMeta.isWithLombok()) {
            JavaParserHelper.addBeanLombokAnnotations(cid, this.adlDeclaration);
        }
        AnnotationMeta domainObjectAnnotationMeta = AnnotationMeta.create("com.alibaba.bizworks.core.specification.StructureObject").addString("name", cuName);
        JavaParserHelper.addAnnotation((NodeWithAnnotations)cid, domainObjectAnnotationMeta);
        AdlTypeConvertor adlTypeConvertor = new AdlTypeConvertor(this.projectMeta, this.moduleMeta);
        List<AdlDeclaration> memberVarList = this.adlDeclaration.getMemberVarList();
        if (memberVarList != null && !memberVarList.isEmpty()) {
            for (AdlDeclaration memberVar : memberVarList) {
                ClassMeta classMeta = adlTypeConvertor.to(memberVar.getType());
                JavaParserHelper.addField(cid, classMeta, memberVar.getName().getText());
                JavaParserHelper.addImportIfNecessary(cu, classMeta);
            }
        }
        JavaParserHelper.sortImports(cu);
        return new GeneratedCodeMeta(cu, this.getOrCreatePath(), ((PackageDeclaration)cu.getPackageDeclaration().get()).getNameAsString(), cuName);
    }

    @Override
    public List<GeneratedCodeMeta> generate() {
        ArrayList<GeneratedCodeMeta> generatedCodeMetas = new ArrayList<GeneratedCodeMeta>();
        generatedCodeMetas.add(this.generateEntity());
        return generatedCodeMetas;
    }

    private String getOrCreatePath() {
        String bdctx = this.moduleMeta.getBoundContextNameAsCode();
        String path = this.projectMeta.getProjectRootPath() + "/" + bdctx + "/" + bdctx + "-application/" + bdctx + "-contract/src/main/java";
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return path;
    }
}

