/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.codeinsight.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;

public class JacksonUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static <T> T readValue(String jsonStr, Class<T> valueType) {
        try {
            return (T)objectMapper.readValue(jsonStr, valueType);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T readValue(byte[] jsonBytes, Class<T> valueType) {
        try {
            return (T)objectMapper.readValue(jsonBytes, valueType);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T readValue(String jsonStr, TypeReference<T> valueTypeRef) {
        try {
            return (T)objectMapper.readValue(jsonStr, valueTypeRef);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T readValue(String jsonStr, Class<T> valueType, Class<?> ... tClasses) {
        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(valueType, (Class[])tClasses);
        try {
            return (T)objectMapper.readValue(jsonStr, javaType);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String toJSon(Object object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T convertValue(Object object, Class<T> valueType) {
        try {
            return (T)objectMapper.convertValue(object, valueType);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> List<T> convertListToOtherList(List list, Class<?> parametrized) {
        try {
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            JavaType javaType = objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{parametrized});
            return (List)objectMapper.readValue(JacksonUtils.toJSon(list), javaType);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList();
        }
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

