/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.codeinsight.utils;

import com.alibaba.bizworks.codeinsight.adl.AdlDeclaration;
import com.alibaba.bizworks.codeinsight.utils.AnnotationMeta;
import com.alibaba.bizworks.codeinsight.utils.ClassMeta;
import com.github.javaparser.HasParentNode;
import com.github.javaparser.JavaParser;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.MarkerAnnotationExpr;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.nodeTypes.NodeWithName;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;

public class JavaParserHelper {
    private static final JavaParser JAVA_PARSER = new JavaParser(new ParserConfiguration().setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_17));

    public static void addField(ClassOrInterfaceDeclaration cid, ClassMeta fieldClassMeta, String fieldName) {
        FieldDeclaration fieldDeclaration = cid.addPrivateField(fieldClassMeta.getSimpleName(), fieldName);
        JavaParserHelper.addAnnotation((NodeWithAnnotations)fieldDeclaration, AnnotationMeta.create("com.alibaba.bizworks.core.specification.Field").addString("name", fieldName));
    }

    public static void addAnnotation(NodeWithAnnotations node, AnnotationMeta annotationMeta) {
        MarkerAnnotationExpr annotation;
        Map<String, String> properties = annotationMeta.readProperties();
        if (properties.isEmpty()) {
            annotation = new MarkerAnnotationExpr();
            annotation.setName(annotationMeta.getSimpleAnnotationName());
            node.addAnnotation((AnnotationExpr)annotation);
        } else {
            annotation = new NormalAnnotationExpr();
            annotation.setName(annotationMeta.getSimpleAnnotationName());
            properties.forEach((arg_0, arg_1) -> ((NormalAnnotationExpr)annotation).addPair(arg_0, arg_1));
            node.addAnnotation((AnnotationExpr)annotation);
        }
        if (node instanceof HasParentNode) {
            CompilationUnit cu = null;
            Optional parentNode = ((HasParentNode)node).getParentNode();
            while (parentNode.isPresent() && !(parentNode.get() instanceof CompilationUnit)) {
                parentNode = ((Node)parentNode.get()).getParentNode();
            }
            if (parentNode.isPresent()) {
                cu = (CompilationUnit)parentNode.get();
            }
            if (cu != null) {
                cu.addImport(annotationMeta.getFullAnnotationName());
            }
        }
    }

    public static void addBeanLombokAnnotations(ClassOrInterfaceDeclaration cid) {
        JavaParserHelper.addBeanLombokAnnotations(cid, null);
    }

    public static void addBeanLombokAnnotations(ClassOrInterfaceDeclaration cid, AdlDeclaration adlDeclaration) {
        JavaParserHelper.addAnnotation((NodeWithAnnotations)cid, AnnotationMeta.create("lombok.Data"));
        if (adlDeclaration != null && adlDeclaration.getMemberVarList() != null && !adlDeclaration.getMemberVarList().isEmpty()) {
            JavaParserHelper.addAnnotation((NodeWithAnnotations)cid, AnnotationMeta.create("lombok.AllArgsConstructor"));
        }
        JavaParserHelper.addAnnotation((NodeWithAnnotations)cid, AnnotationMeta.create("lombok.NoArgsConstructor"));
    }

    public static void addImportIfNecessary(CompilationUnit cu, ClassMeta classMeta) {
        if (classMeta.isJavaLang() || classMeta.isVoid()) {
            return;
        }
        Optional packageDeclaration = cu.getPackageDeclaration();
        if (packageDeclaration.isPresent() && ((PackageDeclaration)packageDeclaration.get()).getNameAsString().equals(classMeta.getPackageName())) {
            return;
        }
        cu.addImport(classMeta.getFullName());
    }

    public static void sortImports(CompilationUnit cu) {
        cu.getImports().sort(Comparator.comparing(NodeWithName::getNameAsString));
    }

    public static Type createTypeWithArguments(String typeName, String ... typeArguments) {
        Type type = (Type)JAVA_PARSER.parseType(typeName).getResult().get();
        for (String typeArgument : typeArguments) {
            Type argumentType = (Type)JAVA_PARSER.parseType(typeArgument).getResult().get();
            type = argumentType.isVoidType() ? (Type)type.asClassOrInterfaceType().setTypeArguments(new Type[]{new ClassOrInterfaceType(null, "Void")}) : (Type)type.asClassOrInterfaceType().setTypeArguments(new Type[]{argumentType});
        }
        return type;
    }

    public static BlockStmt parseBlock(String s) {
        return (BlockStmt)JAVA_PARSER.parseBlock(s).getResult().get();
    }
}

