/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.ide.domain.sync.framework.codegen;

import com.alibaba.bizworks.ads.meta.lang.Metadata;
import com.alibaba.bizworks.ide.common.meta.MdKind;
import com.alibaba.bizworks.ide.domain.common.ActionSourceType;
import com.alibaba.bizworks.ide.domain.sync.framework.codemeta.model.CodeMeta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class GenContext {
    private ActionSourceType actionSourceType;
    private Metadata metadata;
    private CodeMeta codeMeta;
    private List<GenContext> ancestors;

    public GenContext newSubMetaContext(CodeMeta codeMeta) {
        GenContext genContext = this.pushSelfAsParent();
        genContext.setCodeMeta(codeMeta);
        genContext.setMetadata(codeMeta.getMetadata());
        return genContext;
    }

    private GenContext pushSelfAsParent() {
        return this.withPushParent(this);
    }

    private GenContext withPushParent(GenContext parent) {
        ImmutableList theAncestors = this.ancestors;
        if (theAncestors == null) {
            theAncestors = ImmutableList.of((Object)parent);
        } else {
            ArrayList newOne = Lists.newArrayList(this.ancestors);
            newOne.add(parent);
            theAncestors = ImmutableList.copyOf((Collection)newOne);
        }
        return this.withAncestors((List<GenContext>)theAncestors);
    }

    public GenContext getParentContext() {
        if (CollectionUtils.isEmpty(this.ancestors)) {
            return null;
        }
        return this.ancestors.get(this.ancestors.size() - 1);
    }

    public GenContext findContextByMetaType(MdKind mdKind) {
        if (CollectionUtils.isEmpty(this.ancestors)) {
            return null;
        }
        for (int i = this.ancestors.size() - 1; i >= 0; --i) {
            GenContext context = this.ancestors.get(i);
            Metadata metadata = context.getMetadata();
            if (metadata == null || !metadata.getKind().equals((Object)mdKind)) continue;
            return context;
        }
        return null;
    }

    public ActionSourceType getActionSourceType() {
        return this.actionSourceType;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public CodeMeta getCodeMeta() {
        return this.codeMeta;
    }

    public List<GenContext> getAncestors() {
        return this.ancestors;
    }

    public void setActionSourceType(ActionSourceType actionSourceType) {
        this.actionSourceType = actionSourceType;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public void setCodeMeta(CodeMeta codeMeta) {
        this.codeMeta = codeMeta;
    }

    public void setAncestors(List<GenContext> ancestors) {
        this.ancestors = ancestors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenContext)) {
            return false;
        }
        GenContext other = (GenContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ActionSourceType this$actionSourceType = this.getActionSourceType();
        ActionSourceType other$actionSourceType = other.getActionSourceType();
        if (this$actionSourceType == null ? other$actionSourceType != null : !((Object)((Object)this$actionSourceType)).equals((Object)other$actionSourceType)) {
            return false;
        }
        Metadata this$metadata = this.getMetadata();
        Metadata other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
            return false;
        }
        CodeMeta this$codeMeta = this.getCodeMeta();
        CodeMeta other$codeMeta = other.getCodeMeta();
        if (this$codeMeta == null ? other$codeMeta != null : !this$codeMeta.equals(other$codeMeta)) {
            return false;
        }
        List<GenContext> this$ancestors = this.getAncestors();
        List<GenContext> other$ancestors = other.getAncestors();
        return !(this$ancestors == null ? other$ancestors != null : !((Object)this$ancestors).equals(other$ancestors));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GenContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ActionSourceType $actionSourceType = this.getActionSourceType();
        result = result * 59 + ($actionSourceType == null ? 43 : ((Object)((Object)$actionSourceType)).hashCode());
        Metadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        CodeMeta $codeMeta = this.getCodeMeta();
        result = result * 59 + ($codeMeta == null ? 43 : $codeMeta.hashCode());
        List<GenContext> $ancestors = this.getAncestors();
        result = result * 59 + ($ancestors == null ? 43 : ((Object)$ancestors).hashCode());
        return result;
    }

    public String toString() {
        return "GenContext(actionSourceType=" + this.getActionSourceType() + ", metadata=" + this.getMetadata() + ", codeMeta=" + this.getCodeMeta() + ", ancestors=" + this.getAncestors() + ")";
    }

    public GenContext(ActionSourceType actionSourceType, Metadata metadata, CodeMeta codeMeta, List<GenContext> ancestors) {
        this.actionSourceType = actionSourceType;
        this.metadata = metadata;
        this.codeMeta = codeMeta;
        this.ancestors = ancestors;
    }

    public GenContext() {
    }

    public GenContext withAncestors(List<GenContext> ancestors) {
        return this.ancestors == ancestors ? this : new GenContext(this.actionSourceType, this.metadata, this.codeMeta, ancestors);
    }
}

