/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.ide.domain.user;

import com.alibaba.bizworks.ide.domain.sync.framework.config.GlobalConfigManager;
import com.alibaba.bizworks.ide.domain.sync.framework.config.model.BizWorksApiConfig;
import com.alibaba.bizworks.ide.domain.sync.framework.config.model.BizWorksFullUserInfo;
import com.alibaba.bizworks.ide.domain.sync.framework.config.model.BizWorksUserInfo;
import com.alibaba.bizworks.ide.domain.user.UserManager;
import com.alibaba.bizworks.ide.domain.user.gateway.UserGateway;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class UserManagerImpl
implements UserManager {
    public static final int REFRESH_PERMITS = 100;
    private final GlobalConfigManager globalConfigManager;
    private final UserGateway userGateway;
    private final Semaphore refreshUserLock = new Semaphore(100);

    public UserManagerImpl(GlobalConfigManager globalConfigManager, UserGateway userGateway) {
        this.globalConfigManager = globalConfigManager;
        this.userGateway = userGateway;
    }

    @Override
    public boolean isUserInfoReady() {
        BizWorksUserInfo userInfo = this.getUserInfo();
        return userInfo != null && userInfo.isValid();
    }

    @Override
    public boolean isUserInfoReadyWithTry() {
        this.tryGetUserInfo();
        return this.isUserInfoReady();
    }

    @Override
    public BizWorksUserInfo getUserInfo() {
        return this.globalConfigManager.getUserInfo();
    }

    @Override
    @Nullable
    public BizWorksUserInfo tryGetUserInfo() {
        if (this.isUserInfoReady()) {
            return this.getUserInfo();
        }
        return this.tryRefreshUserInfo();
    }

    @Nullable
    public BizWorksUserInfo tryRefreshUserInfo() {
        try {
            return this.refreshUserInfo();
        }
        catch (Exception e) {
            return null;
        }
    }

    public BizWorksUserInfo tryRefreshUserInfoE() {
        return this.refreshUserInfo();
    }

    public void invalidUserInfo() {
        this.globalConfigManager.invalidUserInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BizWorksUserInfo refreshUserInfo() {
        if (this.refreshUserLock.tryAcquire(100)) {
            try {
                this.invalidUserInfo();
                BizWorksApiConfig bizWorksApiConfig = this.globalConfigManager.needValidApiConfig();
                BizWorksUserInfo userInfo = this.loginBizWorks(bizWorksApiConfig);
                if (userInfo != null) {
                    this.globalConfigManager.setUserInfo(userInfo);
                }
            }
            finally {
                this.refreshUserLock.release(100);
            }
        }
        boolean acquired = false;
        try {
            acquired = this.refreshUserLock.tryAcquire(1, 10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (acquired) {
                this.refreshUserLock.release(1);
            }
        }
        return this.globalConfigManager.getUserInfo();
    }

    @Override
    public BizWorksUserInfo loginBizWorks(BizWorksApiConfig bizWorksApiConfig) {
        String token;
        BizWorksUserInfo userInfo;
        if (bizWorksApiConfig == null) {
            bizWorksApiConfig = this.globalConfigManager.needValidApiConfig();
        }
        if ((userInfo = this.userGateway.getCurrentUserInfo(token = bizWorksApiConfig.getToken())) != null) {
            userInfo.setValid(true);
            BizWorksFullUserInfo fullCurrentUserInfo = this.userGateway.getFullCurrentUserInfo(token);
            userInfo.setFullUserInfo(fullCurrentUserInfo);
        }
        return userInfo;
    }
}

