/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.http;

import com.alibaba.bizworks.ide.common.env.EnvUtils;
import com.alibaba.bizworks.ide.common.exception.BizReqException;
import com.alibaba.bizworks.ide.common.exception.RequestException;
import com.alibaba.bizworks.ide.common.utils.JsonKt;
import com.alibaba.bizworks.ide.common.utils.RegistryUtil;
import com.alibaba.bizworks.infra.dto.Response;
import com.alibaba.bizworks.sync.infra.http.ClientUtilsKt;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import java.net.UnknownHostException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\bH\u0002\u001a\u001b\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u000b\u00a2\u0006\u0002\u0010\f\u001aD\u0010\r\u001a\u00020\u000e\"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u000b2\u0006\u0010\u0004\u001a\u00020\u00032\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u0002H\n\u0018\u00010\b2\u0010\b\u0002\u0010\u000f\u001a\n\u0018\u00010\u0010j\u0004\u0018\u0001`\u0011H\u0002\u001a\n\u0010\u0012\u001a\u00020\u0003*\u00020\u0013\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"log", "Lmu/KLogger;", "errorToMessage", "", "msg", "request", "Lokhttp3/Request;", "response", "Lretrofit2/Response;", "get", "T", "Lretrofit2/Call;", "(Lretrofit2/Call;)Ljava/lang/Object;", "logError", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "string", "Lokhttp3/RequestBody;", "toolkit-infra"})
public final class ClientUtilsKt {
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger((Function0)log.1.INSTANCE);

    public static final <T> T get(@NotNull Call<T> $this$get) {
        Intrinsics.checkNotNullParameter($this$get, (String)"<this>");
        try {
            retrofit2.Response response = $this$get.execute();
            if (!response.isSuccessful()) {
                if (response.code() == 407) {
                    RequestException exception = new RequestException("\u8bf7\u68c0\u67e5BizWorks Proxy \u8ba4\u8bc1\u662f\u5426\u5f00\u542f\uff01\u8d26\u53f7\u5bc6\u7801\u914d\u7f6e\u662f\u5426\u6b63\u786e\uff01");
                    String string = exception.getMessage();
                    Intrinsics.checkNotNull((Object)string);
                    ClientUtilsKt.logError($this$get, string, response, (Exception)((Object)exception));
                    throw exception;
                }
                RequestException requestException = new RequestException("\u670d\u52a1\u7aef\u54cd\u5e94\u4e0d\u7b26\u5408\u9884\u671f,Http \u54cd\u5e94\u72b6\u6001\u7801 " + response.code() + "\u3002");
                String string = requestException.getMessage();
                Intrinsics.checkNotNull((Object)string);
                ClientUtilsKt.logError($this$get, string, response, (Exception)((Object)requestException));
                throw requestException;
            }
            Object body = response.body();
            if (body == null) {
                RequestException requestException = new RequestException("\u8bf7\u6c42\u7ed3\u679c\u5f02\u5e38,\u670d\u52a1\u7aef\u672a\u8fd4\u56de\u6570\u636e\u3002");
                String string = requestException.getMessage();
                Intrinsics.checkNotNull((Object)string);
                ClientUtilsKt.logError($this$get, string, response, (Exception)((Object)requestException));
                throw requestException;
            }
            if (body instanceof Response && !((Response)body).isSuccess()) {
                if (Intrinsics.areEqual((Object)"BWE_03050000", (Object)((Response)body).getCode()) || Intrinsics.areEqual((Object)"BWE_03010031", (Object)((Response)body).getCode())) {
                    log.trace((Function0)new Function0<Object>(body){
                        final /* synthetic */ T $body;
                        {
                            this.$body = $body;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "\u670d\u52a1\u7aef\u8d44\u6e90\u4e0d\u5b58\u5728\uff01server error code: " + ((Response)this.$body).getCode();
                        }
                    });
                    return (T)body;
                }
                BizReqException bizReqException = new BizReqException(((Response)body).getCode(), ((Response)body).getMessage());
                ClientUtilsKt.logError($this$get, ((Response)body).getCode() + ":" + ((Response)body).getMessage(), response, (Exception)((Object)bizReqException));
                throw bizReqException;
            }
            return (T)body;
        }
        catch (RequestException e) {
            throw e;
        }
        catch (UnknownHostException e) {
            String msg = "\u7f51\u7edc\u5f02\u5e38,\u8bf7\u68c0\u67e5\u670d\u52a1\u5668\u5730\u5740\u914d\u7f6e\u548c\u57df\u540d\u89e3\u6790\u662f\u5426\u6b63\u786e\uff01";
            ClientUtilsKt.logError$default($this$get, msg, null, e, 2, null);
            throw new RequestException(msg, (Throwable)e);
        }
        catch (MismatchedInputException e) {
            String msg = "\u670d\u52a1\u7aef\u5185\u5bb9\u65e0\u6cd5\u6b63\u786e\u89e3\u6790\u3002\u8bf7\u68c0\u67e5\u8ba4\u8bc1\u914d\u7f6e\u6216\u670d\u52a1\u7aef\u662f\u5426\u6709\u810f\u6570\u636e!";
            ClientUtilsKt.logError$default($this$get, msg, null, (Exception)((Object)e), 2, null);
            throw new RequestException(msg, (Throwable)e);
        }
        catch (Exception e) {
            String msg = "\u8bf7\u6c42\u670d\u52a1\u7aef\u53d1\u751f\u672a\u77e5\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a[" + e.getMessage() + "]";
            ClientUtilsKt.logError$default($this$get, msg, null, e, 2, null);
            throw new RequestException(msg, (Throwable)e);
        }
    }

    private static final <T> void logError(Call<T> $this$logError, String msg, retrofit2.Response<T> response, Exception e) {
        boolean logErrorWithException = EnvUtils.INSTANCE.isDev() || RegistryUtil.Companion.booleanValue("bizworks.log.fatal.request", false);
        Request request = $this$logError.request();
        Intrinsics.checkNotNullExpressionValue((Object)request, (String)"request(...)");
        Request request2 = request;
        String errorMsg = ClientUtilsKt.errorToMessage(msg, request2, response);
        if (logErrorWithException) {
            log.error((Throwable)e, (Function0)new Function0<Object>(errorMsg){
                final /* synthetic */ String $errorMsg;
                {
                    this.$errorMsg = $errorMsg;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.$errorMsg;
                }
            });
        } else {
            log.warn((Function0)new Function0<Object>(errorMsg){
                final /* synthetic */ String $errorMsg;
                {
                    this.$errorMsg = $errorMsg;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.$errorMsg;
                }
            });
        }
    }

    static /* synthetic */ void logError$default(Call call, String string, retrofit2.Response response, Exception exception, int n, Object object) {
        if ((n & 2) != 0) {
            response = null;
        }
        if ((n & 4) != 0) {
            exception = null;
        }
        ClientUtilsKt.logError(call, string, response, exception);
    }

    private static final String errorToMessage(String msg, Request request, retrofit2.Response<?> response) {
        String string;
        okhttp3.Response rawResponse;
        retrofit2.Response<?> response2 = response;
        okhttp3.Response response3 = rawResponse = response2 != null ? response2.raw() : null;
        Object rawRequest = response3 != null ? response3.request() : null;
        Request request2 = rawRequest;
        if (request2 == null) {
            request2 = request;
        }
        Request theReq = request2;
        boolean isRaw = rawRequest != null;
        String url = isRaw ? theReq.url().toString() : StringsKt.removePrefix((String)theReq.url().toString(), (CharSequence)"https://bizworks.aliyun.com/");
        RequestBody requestBody = theReq.body();
        String body = requestBody != null ? ClientUtilsKt.string(requestBody) : null;
        try {
            okhttp3.Response response4 = rawResponse;
            string = response4 != null && (response4 = response4.body()) != null ? response4.string() : null;
        }
        catch (Exception e) {
            String string2;
            try {
                retrofit2.Response<?> response5 = response;
                string2 = JsonKt.getJson().writeValueAsString(response5 != null ? response5.body() : null);
            }
            catch (Exception e2) {
                string2 = null;
            }
            string = string2;
        }
        String responseBody = string;
        retrofit2.Response<?> response6 = response;
        String resInfo = response6 != null ? response6.toString() : null;
        return StringsKt.trimIndent((String)("\n            \u4e0e\u670d\u52a1\u7aef\u4ea4\u4e92\u671f\u95f4\u53d1\u751f\u975e\u9884\u671f\u7684\u7ed3\u679c\u3002\u5f02\u5e38\u4fe1\u606f\u8bf4\u660e\uff1a\"" + msg + "\"\n            (\u53ef\u901a\u8fc7 Registry \u5207\u6362 key \"bizworks.log.fatal.request\" \u4ee5\u63a7\u5236\u6b64\u4fe1\u606f\u662f\u5426\u901a\u8fc7 IDE Fatal Errors \u5c55\u793a\uff0c\u4ee5\u521b\u5efa\u9519\u8bef\u62a5\u544a\u3002)\n            \n            \n            \u8bf7\u6c42\u8be6\u60c5\uff1a\n                request url: " + url + "\n                request body: " + body + "\n                response info: " + resInfo + "\n                response Body: " + responseBody + "\n        "));
    }

    @NotNull
    public static final String string(@NotNull RequestBody $this$string) {
        Intrinsics.checkNotNullParameter((Object)$this$string, (String)"<this>");
        Buffer buffer = new Buffer();
        $this$string.writeTo((BufferedSink)buffer);
        return buffer.readUtf8();
    }
}

