/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.http;

import com.alibaba.bizworks.ide.common.env.EnvUtils;
import com.alibaba.bizworks.ide.common.utils.Enums;
import com.alibaba.bizworks.ide.common.utils.RegistryUtil;
import com.alibaba.bizworks.sync.infra.http.CustomHttpLoggingInterceptor;
import com.alibaba.bizworks.sync.infra.http.CustomHttpLoggingInterceptorKt;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import okhttp3.Connection;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0007R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/alibaba/bizworks/sync/infra/http/CustomHttpLoggingInterceptor;", "Lokhttp3/Interceptor;", "logger", "Lcom/alibaba/bizworks/sync/infra/http/CustomHttpLoggingInterceptor$Logger;", "(Lcom/alibaba/bizworks/sync/infra/http/CustomHttpLoggingInterceptor$Logger;)V", "headersToRedact", "", "", "bodyHasUnknownEncoding", "", "headers", "Lokhttp3/Headers;", "getLevel", "Lcom/alibaba/bizworks/sync/infra/http/CustomHttpLoggingInterceptor$Level;", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "logHeader", "", "i", "", "traceId", "", "redactHeader", "name", "Level", "Logger", "toolkit-infra"})
@SourceDebugExtension(value={"SMAP\nCustomHttpLoggingInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomHttpLoggingInterceptor.kt\ncom/alibaba/bizworks/sync/infra/http/CustomHttpLoggingInterceptor\n+ 2 EnvUtils.kt\ncom/alibaba/bizworks/ide/common/env/EnvUtils\n+ 3 Enums.kt\ncom/alibaba/bizworks/ide/common/utils/Enums\n*L\n1#1,335:1\n83#2,4:336\n25#3:340\n*S KotlinDebug\n*F\n+ 1 CustomHttpLoggingInterceptor.kt\ncom/alibaba/bizworks/sync/infra/http/CustomHttpLoggingInterceptor\n*L\n156#1:336,4\n161#1:340\n*E\n"})
public final class CustomHttpLoggingInterceptor
implements Interceptor {
    @NotNull
    private final Logger logger;
    @NotNull
    private volatile Set<String> headersToRedact;

    @JvmOverloads
    public CustomHttpLoggingInterceptor(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.headersToRedact = SetsKt.emptySet();
    }

    public /* synthetic */ CustomHttpLoggingInterceptor(Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            logger = Logger.Companion.getDEFAULT();
        }
        this(logger);
    }

    public final void redactHeader(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        TreeSet newHeadersToRedact = new TreeSet(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        CollectionsKt.addAll((Collection)newHeadersToRedact, (Iterable)this.headersToRedact);
        ((Collection)newHeadersToRedact).add(name);
        this.headersToRedact = newHeadersToRedact;
    }

    /*
     * WARNING - void declaration
     */
    private final Level getLevel() {
        void this_$iv;
        EnvUtils this_$iv2 = EnvUtils.INSTANCE;
        boolean $i$f$dev22 = false;
        if (this_$iv2.isDev()) {
            boolean bl = false;
            return Level.BODY;
        }
        String level = RegistryUtil.Companion.stringValue("bizworks.log.interceptor.level");
        Enums $i$f$dev22 = Enums.INSTANCE;
        Enum default$iv = Level.NONE;
        boolean $i$f$enumValueOf = false;
        Enum enum_ = Enums.getEnum$default((Enums)this_$iv, Level.class, (String)level, (Enum)default$iv, null, (int)8, null);
        Intrinsics.checkNotNull((Object)enum_);
        return (Level)enum_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        String string;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Level level = this.getLevel();
        Request request = chain.request();
        if (level == Level.NONE) {
            return chain.proceed(request);
        }
        long traceId = UUID.randomUUID().getLeastSignificantBits();
        boolean logBody = level == Level.BODY;
        boolean logHeaders = logBody || level == Level.HEADERS;
        RequestBody requestBody = request.body();
        Connection connection = chain.connection();
        Connection connection2 = connection;
        String requestStartMessage = "[" + traceId + "]--> " + request.method() + " " + request.url() + (String)(connection2 != null ? " " + connection2.protocol() : "");
        if (!logHeaders && requestBody != null) {
            requestStartMessage = requestStartMessage + " (" + requestBody.contentLength() + "-byte body)";
        }
        this.logger.log(requestStartMessage);
        if (logHeaders) {
            Headers headers = request.headers();
            if (requestBody != null) {
                MediaType mediaType = requestBody.contentType();
                if (mediaType != null) {
                    MediaType it = mediaType;
                    boolean bl = false;
                    if (headers.get("Content-Type") == null) {
                        this.logger.log("[" + traceId + "] Content-Type: " + it);
                    }
                }
                if (requestBody.contentLength() != -1L && headers.get("Content-Length") == null) {
                    this.logger.log("[" + traceId + "] Content-Length: " + requestBody.contentLength());
                }
            }
            int n = headers.size();
            for (int i = 0; i < n; ++i) {
                this.logHeader(headers, i, traceId);
            }
            if (!logBody || requestBody == null) {
                this.logger.log("[" + traceId + "]--> END " + request.method());
            } else if (this.bodyHasUnknownEncoding(request.headers())) {
                this.logger.log("[" + traceId + "]--> END " + request.method() + " (encoded body omitted)");
            } else if (requestBody.isDuplex()) {
                this.logger.log("[" + traceId + "]--> END " + request.method() + " (duplex request body omitted)");
            } else if (requestBody.isOneShot()) {
                this.logger.log("[" + traceId + "]--> END " + request.method() + " (one-shot body omitted)");
            } else {
                Buffer buffer = new Buffer();
                requestBody.writeTo((BufferedSink)buffer);
                MediaType contentType = requestBody.contentType();
                Object object = contentType;
                if (object == null || (object = object.charset(StandardCharsets.UTF_8)) == null) {
                    Charset charset = StandardCharsets.UTF_8;
                    object = charset;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                }
                Object charset = object;
                this.logger.log("");
                if (CustomHttpLoggingInterceptorKt.isProbablyUtf8(buffer)) {
                    this.logger.log("[" + traceId + "]--> " + buffer.readString((Charset)charset));
                    this.logger.log("[" + traceId + "]--> END " + request.method() + " (" + requestBody.contentLength() + "-byte body)");
                } else {
                    this.logger.log("[" + traceId + "]--> END " + request.method() + " (binary " + requestBody.contentLength() + "-byte body omitted)");
                }
            }
        }
        long startNs = System.nanoTime();
        Response response = null;
        try {
            response = chain.proceed(request);
        }
        catch (Exception e) {
            this.logger.log("[" + traceId + "]<-- HTTP FAILED: " + e);
            throw e;
        }
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        ResponseBody responseBody = response.body();
        Intrinsics.checkNotNull((Object)responseBody);
        ResponseBody responseBody2 = responseBody;
        long contentLength = responseBody2.contentLength();
        Object bodySize = contentLength != -1L ? contentLength + "-byte" : "unknown-length";
        int n = response.code();
        if (((CharSequence)response.message()).length() == 0) {
            string = "";
        } else {
            char c = ' ';
            String string2 = response.message();
            string = c + string2;
        }
        this.logger.log("[" + traceId + "]<-- " + n + string + " " + response.request().url() + " (" + tookMs + "ms" + (String)(!logHeaders ? ", " + (String)bodySize + " body" : "") + ")");
        if (logHeaders) {
            Headers headers = response.headers();
            int n2 = headers.size();
            for (int i = 0; i < n2; ++i) {
                this.logHeader(headers, i, traceId);
            }
            if (!logBody || !HttpHeaders.promisesBody((Response)response)) {
                this.logger.log("[" + traceId + "]<-- END HTTP");
            } else if (this.bodyHasUnknownEncoding(response.headers())) {
                this.logger.log("[" + traceId + "]<-- END HTTP (encoded body omitted)");
            } else {
                MediaType contentType;
                Object object;
                BufferedSource source = responseBody2.source();
                source.request(Long.MAX_VALUE);
                Buffer buffer = null;
                buffer = source.getBuffer();
                Long gzippedLength = null;
                if (StringsKt.equals((String)"gzip", (String)headers.get("Content-Encoding"), (boolean)true)) {
                    gzippedLength = buffer.size();
                    Closeable closeable = (Closeable)new GzipSource((Source)buffer.clone());
                    Throwable throwable = null;
                    try {
                        GzipSource gzippedResponseBody = (GzipSource)closeable;
                        boolean bl = false;
                        buffer = new Buffer();
                        long l = buffer.writeAll((Source)gzippedResponseBody);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                if ((object = (contentType = responseBody2.contentType())) == null || (object = object.charset(StandardCharsets.UTF_8)) == null) {
                    Charset charset = StandardCharsets.UTF_8;
                    object = charset;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                }
                Object charset = object;
                if (!CustomHttpLoggingInterceptorKt.isProbablyUtf8(buffer)) {
                    this.logger.log("");
                    this.logger.log("[" + traceId + "]<-- END HTTP (binary " + buffer.size() + "-byte body omitted)");
                    return response;
                }
                if (contentLength != 0L) {
                    this.logger.log("");
                    this.logger.log("[" + traceId + "]<-- " + buffer.clone().readString((Charset)charset));
                }
                if (gzippedLength != null) {
                    this.logger.log("[" + traceId + "]<-- END HTTP (" + buffer.size() + "-byte, " + gzippedLength + "-gzipped-byte body)");
                } else {
                    this.logger.log("[" + traceId + "]<-- END HTTP (" + buffer.size() + "-byte body)");
                }
            }
        }
        return response;
    }

    private final void logHeader(Headers headers, int i, long traceId) {
        String value = this.headersToRedact.contains(headers.name(i)) ? "\u2588\u2588" : headers.value(i);
        this.logger.log("[" + traceId + "] -- " + headers.name(i) + ": " + value);
    }

    private final boolean bodyHasUnknownEncoding(Headers headers) {
        String string = headers.get("Content-Encoding");
        if (string == null) {
            return false;
        }
        String contentEncoding = string;
        return !StringsKt.equals((String)contentEncoding, (String)"identity", (boolean)true) && !StringsKt.equals((String)contentEncoding, (String)"gzip", (boolean)true);
    }

    @JvmOverloads
    public CustomHttpLoggingInterceptor() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/alibaba/bizworks/sync/infra/http/CustomHttpLoggingInterceptor$Level;", "", "(Ljava/lang/String;I)V", "NONE", "BASIC", "HEADERS", "BODY", "toolkit-infra"})
    public static final class Level
    extends Enum<Level> {
        public static final /* enum */ Level NONE = new Level();
        public static final /* enum */ Level BASIC = new Level();
        public static final /* enum */ Level HEADERS = new Level();
        public static final /* enum */ Level BODY = new Level();
        private static final /* synthetic */ Level[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Level[] values() {
            return (Level[])$VALUES.clone();
        }

        public static Level valueOf(String value) {
            return Enum.valueOf(Level.class, value);
        }

        @NotNull
        public static EnumEntries<Level> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = levelArray = new Level[]{Level.NONE, Level.BASIC, Level.HEADERS, Level.BODY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/alibaba/bizworks/sync/infra/http/CustomHttpLoggingInterceptor$Logger;", "", "log", "", "message", "", "Companion", "toolkit-infra"})
    public static interface Logger {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public void log(@NotNull String var1);

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lcom/alibaba/bizworks/sync/infra/http/CustomHttpLoggingInterceptor$Logger$Companion;", "", "()V", "DEFAULT", "Lcom/alibaba/bizworks/sync/infra/http/CustomHttpLoggingInterceptor$Logger;", "getDEFAULT", "()Lcom/alibaba/bizworks/sync/infra/http/CustomHttpLoggingInterceptor$Logger;", "log", "Lmu/KLogger;", "getLog", "()Lmu/KLogger;", "DefaultLogger", "toolkit-infra"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Logger DEFAULT;
            @NotNull
            private static final KLogger log;

            private Companion() {
            }

            @NotNull
            public final Logger getDEFAULT() {
                return DEFAULT;
            }

            @NotNull
            public final KLogger getLog() {
                return log;
            }

            static {
                $$INSTANCE = new Companion();
                DEFAULT = new DefaultLogger();
                log = KotlinLogging.INSTANCE.logger((Function0)log.1.INSTANCE);
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/alibaba/bizworks/sync/infra/http/CustomHttpLoggingInterceptor$Logger$Companion$DefaultLogger;", "Lcom/alibaba/bizworks/sync/infra/http/CustomHttpLoggingInterceptor$Logger;", "()V", "log", "", "message", "", "toolkit-infra"})
            private static final class DefaultLogger
            implements Logger {
                @Override
                public void log(@NotNull String message) {
                    Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                    $$INSTANCE.getLog().info(message);
                }
            }
        }
    }
}

