/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.meta.converter;

import com.alibaba.bizworks.ads.meta.lang.element.MdDataField;
import com.alibaba.bizworks.ads.meta.lang.element.MdField;
import com.alibaba.bizworks.ads.meta.lang.file.MdDataModel;
import com.alibaba.bizworks.sync.infra.meta.converter.DataModelDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.FieldDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.MetadataExtInfoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.ModuleDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.OriginTypeConverter;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.DataFieldDTO;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.DataModelDTO;
import java.util.ArrayList;
import java.util.List;

public class DataModelDtoConverterImpl
implements DataModelDtoConverter {
    private final ModuleDtoConverter moduleDtoConverter = ModuleDtoConverter.INSTANCE;
    private final FieldDtoConverter fieldDtoConverter = FieldDtoConverter.INSTANCE;
    private final OriginTypeConverter originTypeConverter = OriginTypeConverter.INSTANCE;
    private final MetadataExtInfoConverter metadataExtInfoConverter = MetadataExtInfoConverter.INSTANCE;

    @Override
    public DataModelDTO toDto(MdDataModel md) {
        if (md == null) {
            return null;
        }
        DataModelDTO dataModelDTO = new DataModelDTO();
        dataModelDTO.setFields(this.mdDataFieldListToDataFieldDTOList(md.getDataFields()));
        dataModelDTO.setName(md.getName());
        dataModelDTO.setDisplayName(md.getDisplayName());
        dataModelDTO.setExt(this.metadataExtInfoConverter.toStr(md.getExt()));
        dataModelDTO.setOrigin(this.originTypeConverter.toStr(md.getOrigin()));
        if (md.getPlatformReadOnly() != null) {
            dataModelDTO.setPlatformReadOnly(String.valueOf(md.getPlatformReadOnly()));
        }
        dataModelDTO.setDescription(md.getDescription());
        dataModelDTO.setNamespace(md.getNamespace());
        dataModelDTO.setUuid(md.getUuid());
        dataModelDTO.setCommitId(md.getCommitId());
        dataModelDTO.setModule(this.moduleDtoConverter.toDto(md.getModule()));
        dataModelDTO.setTableName(md.getTableName());
        if (md.getKind() != null) {
            dataModelDTO.setKind(md.getKind().name());
        }
        return dataModelDTO;
    }

    @Override
    public MdDataModel toMd(DataModelDTO dto) {
        if (dto == null) {
            return null;
        }
        MdDataModel mdDataModel = new MdDataModel();
        mdDataModel.setDataFields(this.dataFieldDTOListToMdDataFieldList(dto.getFields()));
        mdDataModel.setName(dto.getName());
        mdDataModel.setDisplayName(dto.getDisplayName());
        mdDataModel.setDescription(dto.getDescription());
        mdDataModel.setNamespace(dto.getNamespace());
        mdDataModel.setUuid(dto.getUuid());
        mdDataModel.setCommitId(dto.getCommitId());
        mdDataModel.setModule(this.moduleDtoConverter.toMd(dto.getModule()));
        mdDataModel.setOrigin(this.originTypeConverter.toEnum(dto.getOrigin()));
        if (dto.getPlatformReadOnly() != null) {
            mdDataModel.setPlatformReadOnly(Boolean.valueOf(Boolean.parseBoolean(dto.getPlatformReadOnly())));
        }
        mdDataModel.setExt(this.metadataExtInfoConverter.toMd(dto.getExt()));
        mdDataModel.setTableName(dto.getTableName());
        mdDataModel.setFields(this.dataFieldDTOListToMdFieldList(dto.getFields()));
        return mdDataModel;
    }

    protected List<DataFieldDTO> mdDataFieldListToDataFieldDTOList(List<MdDataField> list) {
        if (list == null) {
            return null;
        }
        ArrayList<DataFieldDTO> list1 = new ArrayList<DataFieldDTO>(list.size());
        for (MdDataField mdDataField : list) {
            list1.add(this.fieldDtoConverter.toDto(mdDataField));
        }
        return list1;
    }

    protected List<MdDataField> dataFieldDTOListToMdDataFieldList(List<DataFieldDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MdDataField> list1 = new ArrayList<MdDataField>(list.size());
        for (DataFieldDTO dataFieldDTO : list) {
            list1.add(this.fieldDtoConverter.toMd(dataFieldDTO));
        }
        return list1;
    }

    protected List<MdField> dataFieldDTOListToMdFieldList(List<DataFieldDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MdField> list1 = new ArrayList<MdField>(list.size());
        for (DataFieldDTO dataFieldDTO : list) {
            list1.add((MdField)this.fieldDtoConverter.toMd(dataFieldDTO));
        }
        return list1;
    }
}

