/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.meta.converter;

import com.alibaba.bizworks.ads.meta.lang.element.MdField;
import com.alibaba.bizworks.ads.meta.lang.element.MdMethod;
import com.alibaba.bizworks.ads.meta.lang.element.MdRelationship;
import com.alibaba.bizworks.ads.meta.lang.file.MdDomainObject;
import com.alibaba.bizworks.sync.infra.meta.converter.DomainObjectDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.DomainObjectTypeConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.ExtendsConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.FieldDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.MetadataExtInfoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.MethodDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.ModuleDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.OriginTypeConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.RelationshipDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.DomainObjectDTO;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.FieldDTO;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.MethodDTO;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.RelationshipDTO;
import java.util.ArrayList;
import java.util.List;
import org.mapstruct.factory.Mappers;

public class DomainObjectDtoConverterImpl
implements DomainObjectDtoConverter {
    private final FieldDtoConverter fieldDtoConverter = FieldDtoConverter.INSTANCE;
    private final MethodDtoConverter methodDtoConverter = MethodDtoConverter.INSTANCE;
    private final RelationshipDtoConverter relationshipDtoConverter = RelationshipDtoConverter.INSTANCE;
    private final ModuleDtoConverter moduleDtoConverter = ModuleDtoConverter.INSTANCE;
    private final DomainObjectTypeConverter domainObjectTypeConverter = (DomainObjectTypeConverter)Mappers.getMapper(DomainObjectTypeConverter.class);
    private final ExtendsConverter extendsConverter = ExtendsConverter.INSTANCE;
    private final OriginTypeConverter originTypeConverter = OriginTypeConverter.INSTANCE;
    private final MetadataExtInfoConverter metadataExtInfoConverter = MetadataExtInfoConverter.INSTANCE;

    @Override
    public DomainObjectDTO toDto(MdDomainObject md) {
        if (md == null) {
            return null;
        }
        DomainObjectDTO domainObjectDTO = new DomainObjectDTO();
        domainObjectDTO.setRealName(md.getCodeName());
        domainObjectDTO.setLabel(md.getPresentableText());
        domainObjectDTO.setName(md.getName());
        domainObjectDTO.setDisplayName(md.getDisplayName());
        domainObjectDTO.setExt(this.metadataExtInfoConverter.toStr(md.getExt()));
        domainObjectDTO.setOrigin(this.originTypeConverter.toStr(md.getOrigin()));
        if (md.getPlatformReadOnly() != null) {
            domainObjectDTO.setPlatformReadOnly(String.valueOf(md.getPlatformReadOnly()));
        }
        domainObjectDTO.setDescription(md.getDescription());
        domainObjectDTO.setNamespace(md.getNamespace());
        domainObjectDTO.setUuid(md.getUuid());
        domainObjectDTO.setFields(this.mdFieldListToFieldDTOList(md.getFields()));
        domainObjectDTO.setMethods(this.mdMethodListToMethodDTOList(md.getMethods()));
        domainObjectDTO.setCommitId(md.getCommitId());
        domainObjectDTO.setModule(this.moduleDtoConverter.toDto(md.getModule()));
        domainObjectDTO.setRelationships(this.mdRelationshipListToRelationshipDTOList(md.getRelationships()));
        domainObjectDTO.setRoot(md.getRoot());
        domainObjectDTO.setObjectType(this.domainObjectTypeConverter.toStr(md.getObjectType()));
        domainObjectDTO.setExtends(this.extendsConverter.toDto(md.getExtends()));
        domainObjectDTO.setKind(md.getKind());
        domainObjectDTO.setVersionNumber(md.getVersionNumber());
        return domainObjectDTO;
    }

    @Override
    public MdDomainObject toMd(DomainObjectDTO dto) {
        if (dto == null) {
            return null;
        }
        MdDomainObject mdDomainObject = new MdDomainObject();
        mdDomainObject.setPresentableText(dto.getLabel());
        mdDomainObject.setCodeName(dto.getRealName());
        mdDomainObject.setName(dto.getName());
        mdDomainObject.setDisplayName(dto.getDisplayName());
        mdDomainObject.setDescription(dto.getDescription());
        mdDomainObject.setNamespace(dto.getNamespace());
        mdDomainObject.setUuid(dto.getUuid());
        mdDomainObject.setFields(this.fieldDTOListToMdFieldList(dto.getFields()));
        mdDomainObject.setMethods(this.methodDTOListToMdMethodList(dto.getMethods()));
        mdDomainObject.setCommitId(dto.getCommitId());
        mdDomainObject.setModule(this.moduleDtoConverter.toMd(dto.getModule()));
        mdDomainObject.setOrigin(this.originTypeConverter.toEnum(dto.getOrigin()));
        if (dto.getPlatformReadOnly() != null) {
            mdDomainObject.setPlatformReadOnly(Boolean.valueOf(Boolean.parseBoolean(dto.getPlatformReadOnly())));
        }
        mdDomainObject.setExt(this.metadataExtInfoConverter.toMd(dto.getExt()));
        mdDomainObject.setRelationships(this.relationshipDTOListToMdRelationshipList(dto.getRelationships()));
        mdDomainObject.setRoot(dto.getRoot());
        mdDomainObject.setExtends(this.extendsConverter.toMd(dto.getExtends()));
        mdDomainObject.setObjectType(this.domainObjectTypeConverter.toEnum(dto.getObjectType()));
        mdDomainObject.setVersionNumber(dto.getVersionNumber());
        return mdDomainObject;
    }

    protected List<FieldDTO> mdFieldListToFieldDTOList(List<MdField> list) {
        if (list == null) {
            return null;
        }
        ArrayList<FieldDTO> list1 = new ArrayList<FieldDTO>(list.size());
        for (MdField mdField : list) {
            list1.add(this.fieldDtoConverter.toDto(mdField));
        }
        return list1;
    }

    protected List<MethodDTO> mdMethodListToMethodDTOList(List<MdMethod> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MethodDTO> list1 = new ArrayList<MethodDTO>(list.size());
        for (MdMethod mdMethod : list) {
            list1.add(this.methodDtoConverter.toDto(mdMethod));
        }
        return list1;
    }

    protected List<RelationshipDTO> mdRelationshipListToRelationshipDTOList(List<MdRelationship> list) {
        if (list == null) {
            return null;
        }
        ArrayList<RelationshipDTO> list1 = new ArrayList<RelationshipDTO>(list.size());
        for (MdRelationship mdRelationship : list) {
            list1.add(this.relationshipDtoConverter.toDto(mdRelationship));
        }
        return list1;
    }

    protected List<MdField> fieldDTOListToMdFieldList(List<FieldDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MdField> list1 = new ArrayList<MdField>(list.size());
        for (FieldDTO fieldDTO : list) {
            list1.add(this.fieldDtoConverter.toMd(fieldDTO));
        }
        return list1;
    }

    protected List<MdMethod> methodDTOListToMdMethodList(List<MethodDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MdMethod> list1 = new ArrayList<MdMethod>(list.size());
        for (MethodDTO methodDTO : list) {
            list1.add(this.methodDtoConverter.toMd(methodDTO));
        }
        return list1;
    }

    protected List<MdRelationship> relationshipDTOListToMdRelationshipList(List<RelationshipDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MdRelationship> list1 = new ArrayList<MdRelationship>(list.size());
        for (RelationshipDTO relationshipDTO : list) {
            list1.add(this.relationshipDtoConverter.toMd(relationshipDTO));
        }
        return list1;
    }
}

