/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.meta.converter;

import com.alibaba.bizworks.ads.meta.lang.element.MdField;
import com.alibaba.bizworks.ads.meta.lang.file.MdExtensionPoint;
import com.alibaba.bizworks.sync.infra.meta.converter.ExtensionPointDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.FieldDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.MetadataExtInfoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.MethodDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.ModuleDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.OriginTypeConverter;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.ExtensionPointDTO;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.FieldDTO;
import java.util.ArrayList;
import java.util.List;

public class ExtensionPointDtoConverterImpl
implements ExtensionPointDtoConverter {
    private final FieldDtoConverter fieldDtoConverter = FieldDtoConverter.INSTANCE;
    private final MethodDtoConverter methodDtoConverter = MethodDtoConverter.INSTANCE;
    private final ModuleDtoConverter moduleDtoConverter = ModuleDtoConverter.INSTANCE;
    private final OriginTypeConverter originTypeConverter = OriginTypeConverter.INSTANCE;
    private final MetadataExtInfoConverter metadataExtInfoConverter = MetadataExtInfoConverter.INSTANCE;

    @Override
    public ExtensionPointDTO toDto(MdExtensionPoint md) {
        if (md == null) {
            return null;
        }
        ExtensionPointDTO extensionPointDTO = new ExtensionPointDTO();
        extensionPointDTO.setLabel(md.getPresentableText());
        extensionPointDTO.setRealName(md.getCodeName());
        extensionPointDTO.setName(md.getName());
        extensionPointDTO.setDisplayName(md.getDisplayName());
        extensionPointDTO.setExt(this.metadataExtInfoConverter.toStr(md.getExt()));
        extensionPointDTO.setOrigin(this.originTypeConverter.toStr(md.getOrigin()));
        if (md.getPlatformReadOnly() != null) {
            extensionPointDTO.setPlatformReadOnly(String.valueOf(md.getPlatformReadOnly()));
        }
        extensionPointDTO.setDescription(md.getDescription());
        extensionPointDTO.setNamespace(md.getNamespace());
        extensionPointDTO.setUuid(md.getUuid());
        extensionPointDTO.setFields(this.mdFieldListToFieldDTOList(md.getFields()));
        extensionPointDTO.setCommitId(md.getCommitId());
        extensionPointDTO.setModule(this.moduleDtoConverter.toDto(md.getModule()));
        extensionPointDTO.setOperation(this.methodDtoConverter.toDto(md.getOperation()));
        extensionPointDTO.setKind(md.getKind());
        return extensionPointDTO;
    }

    @Override
    public MdExtensionPoint toMd(ExtensionPointDTO dto) {
        if (dto == null) {
            return null;
        }
        MdExtensionPoint mdExtensionPoint = new MdExtensionPoint();
        mdExtensionPoint.setPresentableText(dto.getLabel());
        mdExtensionPoint.setCodeName(dto.getRealName());
        mdExtensionPoint.setName(dto.getName());
        mdExtensionPoint.setDisplayName(dto.getDisplayName());
        mdExtensionPoint.setDescription(dto.getDescription());
        mdExtensionPoint.setNamespace(dto.getNamespace());
        mdExtensionPoint.setUuid(dto.getUuid());
        mdExtensionPoint.setFields(this.fieldDTOListToMdFieldList(dto.getFields()));
        mdExtensionPoint.setCommitId(dto.getCommitId());
        mdExtensionPoint.setModule(this.moduleDtoConverter.toMd(dto.getModule()));
        mdExtensionPoint.setOrigin(this.originTypeConverter.toEnum(dto.getOrigin()));
        if (dto.getPlatformReadOnly() != null) {
            mdExtensionPoint.setPlatformReadOnly(Boolean.valueOf(Boolean.parseBoolean(dto.getPlatformReadOnly())));
        }
        mdExtensionPoint.setExt(this.metadataExtInfoConverter.toMd(dto.getExt()));
        mdExtensionPoint.setOperation(this.methodDtoConverter.toMd(dto.getOperation()));
        return mdExtensionPoint;
    }

    protected List<FieldDTO> mdFieldListToFieldDTOList(List<MdField> list) {
        if (list == null) {
            return null;
        }
        ArrayList<FieldDTO> list1 = new ArrayList<FieldDTO>(list.size());
        for (MdField mdField : list) {
            list1.add(this.fieldDtoConverter.toDto(mdField));
        }
        return list1;
    }

    protected List<MdField> fieldDTOListToMdFieldList(List<FieldDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MdField> list1 = new ArrayList<MdField>(list.size());
        for (FieldDTO fieldDTO : list) {
            list1.add(this.fieldDtoConverter.toMd(fieldDTO));
        }
        return list1;
    }
}

