/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.meta.converter;

import com.alibaba.bizworks.ads.meta.lang.file.MdFile;
import com.alibaba.bizworks.ads.meta.lang.module.MdModule;
import com.alibaba.bizworks.sync.infra.meta.converter.FileMetaDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.MetadataExtInfoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.ModuleDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.ModuleVersionStatusConverter;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.MetaDTO;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.ModuleDTO;
import java.util.ArrayList;
import java.util.List;
import org.mapstruct.factory.Mappers;

public class ModuleDtoConverterImpl
implements ModuleDtoConverter {
    private final ModuleVersionStatusConverter moduleVersionStatusConverter = (ModuleVersionStatusConverter)Mappers.getMapper(ModuleVersionStatusConverter.class);
    private final MetadataExtInfoConverter metadataExtInfoConverter = MetadataExtInfoConverter.INSTANCE;

    @Override
    public ModuleDTO toDto(MdModule md) {
        if (md == null) {
            return null;
        }
        ModuleDTO moduleDTO = new ModuleDTO();
        moduleDTO.setName(md.getName());
        moduleDTO.setDisplayName(md.getDisplayName());
        moduleDTO.setExt(this.metadataExtInfoConverter.toStr(md.getExt()));
        moduleDTO.setKind(md.getKind());
        moduleDTO.setDescription(md.getDescription());
        moduleDTO.setProjectCode(md.getProjectCode());
        moduleDTO.setUuid(md.getUuid());
        moduleDTO.setVersion(md.getVersion());
        moduleDTO.setVersionStatus(this.moduleVersionStatusConverter.toStr(md.getVersionStatus()));
        moduleDTO.setLastVersion(md.getLastVersion());
        moduleDTO.setLastVersionStatus(this.moduleVersionStatusConverter.toStr(md.getLastVersionStatus()));
        moduleDTO.setContains(this.mdFileListToMetaDTOList(md.getContains()));
        return moduleDTO;
    }

    @Override
    public MdModule toMd(ModuleDTO dto) {
        if (dto == null) {
            return null;
        }
        MdModule mdModule = new MdModule();
        mdModule.setKind(dto.getKind());
        mdModule.setName(dto.getName());
        mdModule.setDisplayName(dto.getDisplayName());
        mdModule.setDescription(dto.getDescription());
        mdModule.setProjectCode(dto.getProjectCode());
        mdModule.setUuid(dto.getUuid());
        mdModule.setVersion(dto.getVersion());
        mdModule.setVersionStatus(this.moduleVersionStatusConverter.toEnum(dto.getVersionStatus()));
        mdModule.setLastVersion(dto.getLastVersion());
        mdModule.setLastVersionStatus(this.moduleVersionStatusConverter.toEnum(dto.getLastVersionStatus()));
        mdModule.setContains(this.metaDTOListToMdFileList(dto.getContains()));
        mdModule.setExt(this.metadataExtInfoConverter.toMd(dto.getExt()));
        return mdModule;
    }

    protected List<MetaDTO> mdFileListToMetaDTOList(List<MdFile> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MetaDTO> list1 = new ArrayList<MetaDTO>(list.size());
        for (MdFile mdFile : list) {
            list1.add(FileMetaDtoConverter.mdFileToDto(mdFile));
        }
        return list1;
    }

    protected List<MdFile> metaDTOListToMdFileList(List<MetaDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MdFile> list1 = new ArrayList<MdFile>(list.size());
        for (MetaDTO metaDTO : list) {
            list1.add(FileMetaDtoConverter.toMdFile(metaDTO));
        }
        return list1;
    }
}

