/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.meta.converter;

import com.alibaba.bizworks.ads.meta.lang.MdReference;
import com.alibaba.bizworks.ads.meta.lang.element.MdInput;
import com.alibaba.bizworks.ads.meta.lang.element.MdOperation;
import com.alibaba.bizworks.sync.infra.meta.converter.InputDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.MetadataExtInfoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.OperationDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.OutputDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.ReferenceDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.InputDTO;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.OperationDTO;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.ReferenceDTO;
import java.util.ArrayList;
import java.util.List;

public class OperationDtoConverterImpl
implements OperationDtoConverter {
    private final InputDtoConverter inputDtoConverter = InputDtoConverter.INSTANCE;
    private final OutputDtoConverter outputDtoConverter = OutputDtoConverter.INSTANCE;
    private final ReferenceDtoConverter referenceDtoConverter = ReferenceDtoConverter.INSTANCE;
    private final MetadataExtInfoConverter metadataExtInfoConverter = MetadataExtInfoConverter.INSTANCE;

    @Override
    public OperationDTO toDto(MdOperation md) {
        if (md == null) {
            return null;
        }
        OperationDTO operationDTO = new OperationDTO();
        operationDTO.setOutputs(this.outputDtoConverter.toDtoList(md.getOutput()));
        operationDTO.setRealName(md.getCodeName());
        operationDTO.setName(md.getName());
        operationDTO.setDisplayName(md.getDisplayName());
        operationDTO.setExt(this.metadataExtInfoConverter.toStr(md.getExt()));
        operationDTO.setDescription(md.getDescription());
        operationDTO.setInherited(md.getInherited());
        operationDTO.setInputs(this.mdInputListToInputDTOList(md.getInputs()));
        operationDTO.setUuid(md.getUuid());
        operationDTO.setExtensionPointRefs(this.mdReferenceListToReferenceDTOList(md.getExtensionPointRefs()));
        operationDTO.setKind(md.getKind());
        return operationDTO;
    }

    @Override
    public MdOperation toMd(OperationDTO dto) {
        if (dto == null) {
            return null;
        }
        MdOperation mdOperation = new MdOperation();
        mdOperation.setCodeName(dto.getRealName());
        mdOperation.setOutput(this.outputDtoConverter.toMd(dto.getOutputs()));
        mdOperation.setName(dto.getName());
        mdOperation.setDisplayName(dto.getDisplayName());
        mdOperation.setDescription(dto.getDescription());
        mdOperation.setUuid(dto.getUuid());
        mdOperation.setExt(this.metadataExtInfoConverter.toMd(dto.getExt()));
        mdOperation.setInherited(dto.getInherited());
        mdOperation.setInputs(this.inputDTOListToMdInputList(dto.getInputs()));
        mdOperation.setExtensionPointRefs(this.referenceDTOListToMdReferenceList(dto.getExtensionPointRefs()));
        return mdOperation;
    }

    protected List<InputDTO> mdInputListToInputDTOList(List<MdInput> list) {
        if (list == null) {
            return null;
        }
        ArrayList<InputDTO> list1 = new ArrayList<InputDTO>(list.size());
        for (MdInput mdInput : list) {
            list1.add(this.inputDtoConverter.toDto(mdInput));
        }
        return list1;
    }

    protected List<ReferenceDTO> mdReferenceListToReferenceDTOList(List<MdReference> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ReferenceDTO> list1 = new ArrayList<ReferenceDTO>(list.size());
        for (MdReference mdReference : list) {
            list1.add(this.referenceDtoConverter.toDto(mdReference));
        }
        return list1;
    }

    protected List<MdInput> inputDTOListToMdInputList(List<InputDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MdInput> list1 = new ArrayList<MdInput>(list.size());
        for (InputDTO inputDTO : list) {
            list1.add(this.inputDtoConverter.toMd(inputDTO));
        }
        return list1;
    }

    protected List<MdReference> referenceDTOListToMdReferenceList(List<ReferenceDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MdReference> list1 = new ArrayList<MdReference>(list.size());
        for (ReferenceDTO referenceDTO : list) {
            list1.add(this.referenceDtoConverter.toMd(referenceDTO));
        }
        return list1;
    }
}

