/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.module.converter;

import com.alibaba.bizworks.ads.meta.lang.module.MdModule;
import com.alibaba.bizworks.ide.common.meta.MdKind;
import com.alibaba.bizworks.sync.infra.meta.dto.apimeta.ModuleVersionDetailDTO;
import com.alibaba.bizworks.sync.infra.module.converter.ApiModuleVersionDetailDTOConverter;
import java.util.ArrayList;
import java.util.List;

public class ApiModuleVersionDetailDTOConverterImpl
implements ApiModuleVersionDetailDTOConverter {
    @Override
    public ModuleVersionDetailDTO toDto(MdModule mdModule) {
        if (mdModule == null) {
            return null;
        }
        ModuleVersionDetailDTO moduleVersionDetailDTO = new ModuleVersionDetailDTO();
        moduleVersionDetailDTO.setModuleCode(mdModule.getName());
        moduleVersionDetailDTO.setVersion(mdModule.getVersion());
        moduleVersionDetailDTO.setProjectCode(mdModule.getProjectCode());
        moduleVersionDetailDTO.setModuleType(mdModule.getKind().getCode());
        return moduleVersionDetailDTO;
    }

    @Override
    public MdModule toMd(ModuleVersionDetailDTO dto) {
        if (dto == null) {
            return null;
        }
        MdModule mdModule = new MdModule();
        mdModule.setName(dto.getModuleCode());
        mdModule.setVersion(dto.getVersion());
        mdModule.setReversionId(dto.getLatestRevisionId());
        mdModule.setProjectCode(dto.getProjectCode());
        mdModule.setKind(MdKind.fromCode((String)dto.getModuleType()));
        return mdModule;
    }

    @Override
    public List<ModuleVersionDetailDTO> toDtoList(List<MdModule> modules) {
        if (modules == null) {
            return null;
        }
        ArrayList<ModuleVersionDetailDTO> list = new ArrayList<ModuleVersionDetailDTO>(modules.size());
        for (MdModule mdModule : modules) {
            list.add(this.toDto(mdModule));
        }
        return list;
    }

    @Override
    public List<MdModule> toMdList(List<ModuleVersionDetailDTO> modules) {
        if (modules == null) {
            return null;
        }
        ArrayList<MdModule> list = new ArrayList<MdModule>(modules.size());
        for (ModuleVersionDetailDTO moduleVersionDetailDTO : modules) {
            list.add(this.toMd(moduleVersionDetailDTO));
        }
        return list;
    }
}

