/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.version.gateway;

import com.alibaba.bizworks.ide.common.utils.RegistryUtil;
import com.alibaba.bizworks.ide.domain.version.BizWorksServerInfoGateway;
import com.alibaba.bizworks.ide.domain.version.BwServerInfo;
import com.alibaba.bizworks.infra.dto.SingleResponse;
import com.alibaba.bizworks.sync.infra.http.ClientManager;
import com.alibaba.bizworks.sync.infra.http.ClientUtilsKt;
import com.alibaba.bizworks.sync.infra.user.dto.LoginDTO;
import com.alibaba.bizworks.sync.infra.version.client.BizWorksServerInfoClient;
import com.alibaba.bizworks.sync.infra.version.converter.ServerInfoDTOConverter;
import com.alibaba.bizworks.sync.infra.version.dto.ServerInfoDTO;
import com.alibaba.bizworks.sync.infra.version.gateway.BizWorksServerInfoGatewayImpl;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/alibaba/bizworks/sync/infra/version/gateway/BizWorksServerInfoGatewayImpl;", "Lcom/alibaba/bizworks/ide/domain/version/BizWorksServerInfoGateway;", "clientManager", "Lcom/alibaba/bizworks/sync/infra/http/ClientManager;", "(Lcom/alibaba/bizworks/sync/infra/http/ClientManager;)V", "serverInfoClient", "Lcom/alibaba/bizworks/sync/infra/version/client/BizWorksServerInfoClient;", "getServerInfo", "Lcom/alibaba/bizworks/ide/domain/version/BwServerInfo;", "mockServerVersionIfNeed", "", "serverInfo", "Companion", "toolkit-infra"})
public class BizWorksServerInfoGatewayImpl
implements BizWorksServerInfoGateway {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BizWorksServerInfoClient serverInfoClient;
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger((Function0)Companion.log.1.INSTANCE);

    public BizWorksServerInfoGatewayImpl(@NotNull ClientManager clientManager) {
        Intrinsics.checkNotNullParameter((Object)clientManager, (String)"clientManager");
        this.serverInfoClient = clientManager.getClient(BizWorksServerInfoClient.class);
    }

    @NotNull
    public BwServerInfo getServerInfo() {
        SingleResponse<ServerInfoDTO> response = ClientUtilsKt.get(this.serverInfoClient.bizWorksServerInfo(new LoginDTO()));
        BwServerInfo rs = ServerInfoDTOConverter.INSTANCE.toMd((ServerInfoDTO)response.getData());
        this.mockServerVersionIfNeed(rs);
        Intrinsics.checkNotNull((Object)rs);
        return rs;
    }

    private final void mockServerVersionIfNeed(BwServerInfo serverInfo) {
        if (serverInfo == null) {
            return;
        }
        String mockVersion = RegistryUtil.Companion.stringValue("bizworks.mock.bizworks.version");
        if (StringUtils.isBlank((CharSequence)mockVersion) || Intrinsics.areEqual((Object)"NONE", (Object)mockVersion)) {
            return;
        }
        log.info("mock bizworks server version to {}", (Object)mockVersion);
        serverInfo.setVersion(mockVersion);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/alibaba/bizworks/sync/infra/version/gateway/BizWorksServerInfoGatewayImpl$Companion;", "", "()V", "log", "Lmu/KLogger;", "toolkit-infra"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

