function needUserInput(data) {
    // 弹窗,请用户输入文本信息
    let input = prompt('Please enter some text:', '');

    window.responseCall(JSON.stringify({
        callId: data.callId,
        data: {
            message: 'Hello from the web page!',
            input: input
        }
    }))
}

function unknownCallType(data) {
    // 将 data 转为 json
    let json = JSON.stringify(data);
    // 弹窗,提示用户,并展示json 文本化的 data 数据
    alert(`收到了来自IDE的识别不了的请求: \n${json}`)
    window.responseCall(JSON.stringify({
        callId: data.callId,
        code: 404,
        message: `无法识别的请求type ${data.callType}`,
    }))
}

function callFromIde(data) {
    switch (data.callType) {
        case 'userInput':
            needUserInput(data);
            break;
        default:
            unknownCallType(data);
            break;
    }
}

function updateAdl(data) {
    // 查找 Mermaid 容器
    const container = document.getElementById('mermaid-container');
    // 清空容器内容
    container.innerHTML = '';
    // 添加新的 Mermaid 图表定义
    const mermaidDiv = document.createElement('pre');
    mermaidDiv.classList.add('mermaid');
    mermaidDiv.innerHTML = data.adlText;
    container.appendChild(mermaidDiv);

    // 重新渲染 Mermaid 图表
    mermaid.init(undefined, mermaidDiv);
}

// 处理 window 上收到的消息,根据 type,分别路由到不同的处理函数
window.addEventListener('message', function (event) {
    // 处理消息体,根据 type,分别路由到不同的处理函数
    switch (event.data.type) {
        case 'callJs':
            // 获取 adl-design 数据
            callFromIde(event.data);
            break;
        case 'alert':
            alert(`收到信息: ${JSON.stringify(event.data)}`);
            break;
        case 'updateAdl':
            // 设置 adl-design 数据
            updateAdl(event.data)
            break;
        default:
            break;
    }
});



