import React from "react";
import { Nav } from "@alifd/next";
import { getHistory } from "./history";

import Router from "./router";
import "./root.scss";

type ComponentProps = {};

type ComponentState = {};

export default class Root extends React.Component<ComponentProps, ComponentState> {
    componentDidMount() {}

    render() {
        return (
            <div className="app">
                <div className="app-header">
                    <div style={{ padding: "4px 0 0 10px" }}>
                        <img
                            src="//g.alicdn.com/bizworks-fe/bwf-sub-operating-custom/1.14.0/images/0f992faa179c9d8fb58420fab4ebc094.png"
                            alt="Logo"
                            style={{ width: "150px" }}
                        />
                    </div>
                </div>
                <div className="app-content">
                    <div className="app-left">
                        <Nav embeddable={true} defaultOpenAll iconOnly={false} hasArrow={false} hasTooltip mode={"inline"}>
                            <Nav.Item
                                onClick={() => {
                                    getHistory().push("/order");
                                }}
                            >
                                订单
                            </Nav.Item>
                        </Nav>
                    </div>
                    <div className="app-right">
                        <Router />
                    </div>
                </div>
            </div>
        );
    }
}
