import { get, post } from "../../lib/request";

type DataSource<T> = {
    items: T[];
    totalCount: number;
};

type QueryOrderListParam = {
    pageNumber: number;
    pageSize: number;
    sortName?: string;
    sortType?: "asc" | "desc";
    condition: any;
};

export function queryOrderList(params: QueryOrderListParam): Promise<DataSource<any>> {
    const { pageNumber, pageSize, sortName, sortType, condition } = params;
    return post("/api/getOrderList", { pageNumber, pageSize, sortName, sortType, condition });
}

export function queryOrder(id: number): Promise<any> {
    return post("/api/getOrder", { id });
}

export function createOrder(entity: any): Promise<void> {
    return post("/api/createOrder", { entity });
}

export function updateOrder(entity: any): Promise<void> {
    return post("/api/updateOrder", { entity });
}

export function deleteOrder(id: number): Promise<void> {
    return post("/api/deleteOrder", { id });
}
