/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.infra.dto;

import com.alibaba.security.SecurityUtil;
import org.apache.commons.lang3.StringUtils;

public class PageQuery {
    public static final String ASC = "ASC";
    public static final String DESC = "DESC";
    public static final int DEFAULT_PAGE_SIZE = 10;
    private String[] orderBy;
    private String order = "DESC";
    private String groupBy;
    @Deprecated
    private String searchTerm;
    private int pageNumber = 1;
    private int pageSize = 10;

    public boolean isNeedOrderBy() {
        return this.orderBy != null && this.orderBy.length > 0;
    }

    public String[] getOrderBy() {
        return this.orderBy;
    }

    public PageQuery setOrderBy(String[] orderBy) {
        String[] trimOrderBys = null;
        if (orderBy != null && orderBy.length > 0) {
            trimOrderBys = new String[orderBy.length];
            for (int i = 0; i < orderBy.length; ++i) {
                trimOrderBys[i] = SecurityUtil.trimSql((String)orderBy[i]);
            }
        }
        this.orderBy = trimOrderBys;
        return this;
    }

    public String getOrder() {
        return this.order;
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }

    public void setSearchTerm(String searchTerm) {
        this.searchTerm = searchTerm;
    }

    public PageQuery setOrder(String order) {
        if (order.equals(ASC) || order.equals(DESC)) {
            this.order = order;
        }
        return this;
    }

    public boolean isNeedGroupBy() {
        return StringUtils.isNotEmpty((CharSequence)this.groupBy);
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    public PageQuery setGroupBy(String groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public PageQuery setPageNumber(int pageNumber) {
        if (pageNumber < 1) {
            pageNumber = 1;
        }
        this.pageNumber = pageNumber;
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public PageQuery setPageSize(int pageSize) {
        if (pageSize < 1) {
            pageSize = 10;
        }
        this.pageSize = pageSize;
        return this;
    }

    public int getOffset() {
        return (this.getPageNumber() - 1) * this.getPageSize();
    }
}

