/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.ide.common.utils;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.resource.ClassPathResource;
import cn.hutool.core.io.resource.FileResource;
import cn.hutool.core.io.resource.NoResourceException;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.util.StrUtil;
import com.alibaba.bizworks.ide.common.log.LoggerExtKt;
import com.alibaba.bizworks.ide.common.utils.ClassLoaderUtils;
import com.alibaba.bizworks.ide.common.utils.FileUtils;
import com.alibaba.bizworks.ide.common.utils.FileUtilsKt;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\bJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\bJ\u0006\u0010\u0012\u001a\u00020\bJ\u0016\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/alibaba/bizworks/ide/common/utils/FileUtils;", "", "()V", "log", "Lmu/KLogger;", "copyResourcesFromJar", "", "jarFilePath", "", "resourcePath", "destinationDir", "getResourceObj", "Lcn/hutool/core/io/resource/Resource;", "path", "getResourceObjSafe", "getStreamSafe", "Ljava/io/InputStream;", "resource", "guessDevProjectDir", "readStr", "charset", "Ljava/nio/charset/Charset;", "readUtf8Str", "component-common"})
@SourceDebugExtension(value={"SMAP\nFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUtils.kt\ncom/alibaba/bizworks/ide/common/utils/FileUtils\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,146:1\n1313#2,2:147\n*S KotlinDebug\n*F\n+ 1 FileUtils.kt\ncom/alibaba/bizworks/ide/common/utils/FileUtils\n*L\n109#1:147,2\n*E\n"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger((Function0)log.1.INSTANCE);

    private FileUtils() {
    }

    @NotNull
    public final String readUtf8Str(@NotNull String resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        String string = this.getResourceObj(resource).readUtf8Str();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readUtf8Str(...)");
        return string;
    }

    @NotNull
    public final String readStr(@NotNull String resource, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        String string = this.getResourceObj(resource).readStr(charset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readStr(...)");
        return string;
    }

    @Nullable
    public final InputStream getStreamSafe(@NotNull String resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        try {
            return this.getResourceObj(resource).getStream();
        }
        catch (NoResourceException noResourceException) {
            return null;
        }
    }

    @NotNull
    public final Resource getResourceObj(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (StrUtil.isNotBlank((CharSequence)path) && (StringsKt.startsWith$default((String)path, (String)"file:", (boolean)false, (int)2, null) || FileUtil.isAbsolutePath((String)path))) {
            return (Resource)new FileResource(path);
        }
        return (Resource)new ClassPathResource(path, ClassLoaderUtils.INSTANCE.getClassLoader());
    }

    @Nullable
    public final Resource getResourceObjSafe(@NotNull String path) {
        Resource resource;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            Resource obj;
            Resource resource2;
            Resource it = resource2 = (obj = this.getResourceObj(path));
            boolean bl = false;
            resource = FileUtilsKt.isExists(it) ? resource2 : null;
        }
        catch (NoResourceException noResourceException) {
            resource = null;
        }
        return resource;
    }

    @NotNull
    public final String guessDevProjectDir() {
        URL uRL = FileUtils.class.getClassLoader().getResource("");
        Intrinsics.checkNotNull((Object)uRL);
        String string = uRL.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String classPath = string;
        Object[] objectArray = new String[]{"common/build", "plugin/build"};
        int index = StringsKt.indexOfAny$default((CharSequence)classPath, (Collection)CollectionsKt.listOf((Object[])objectArray), (int)0, (boolean)false, (int)6, null);
        if (index < 0) {
            return classPath;
        }
        String string2 = classPath.substring(0, index);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void copyResourcesFromJar(@NotNull String jarFilePath, @NotNull String resourcePath, @NotNull String destinationDir) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)jarFilePath, (String)"jarFilePath");
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        LoggerExtKt.devDebugT(log, (Function0<String>)((Function0)new Function0<String>(jarFilePath, resourcePath, destinationDir){
            final /* synthetic */ String $jarFilePath;
            final /* synthetic */ String $resourcePath;
            final /* synthetic */ String $destinationDir;
            {
                this.$jarFilePath = $jarFilePath;
                this.$resourcePath = $resourcePath;
                this.$destinationDir = $destinationDir;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "jarFilePath: " + this.$jarFilePath + ",resourcePath: " + this.$resourcePath + ",destinationDir: " + this.$destinationDir;
            }
        }));
        JarFile jarFile = new JarFile(jarFilePath);
        File file = FileUtil.mkdir((String)destinationDir);
        Intrinsics.checkNotNull((Object)file);
        File outputDir = file;
        Enumeration<JarEntry> enumeration = jarFile.entries();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
        Sequence entries = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
        Sequence sequence = SequencesKt.filter((Sequence)entries, (Function1)((Function1)new Function1<JarEntry, Boolean>(resourcePath){
            final /* synthetic */ String $resourcePath;
            {
                this.$resourcePath = $resourcePath;
                super(1);
            }

            @NotNull
            public final Boolean invoke(JarEntry it) {
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                return StringsKt.startsWith$default((String)string, (String)this.$resourcePath, (boolean)false, (int)2, null);
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JarEntry entry = (JarEntry)element$iv;
            boolean bl = false;
            if (entry.isDirectory()) continue;
            String string = entry.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            File destinationFile = new File(outputDir, StringsKt.removePrefix((String)string, (CharSequence)resourcePath));
            destinationFile.getParentFile().mkdirs();
            Closeable closeable = jarFile.getInputStream(entry);
            Throwable throwable = null;
            try {
                InputStream input = (InputStream)closeable;
                boolean bl2 = false;
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                long l = Files.copy(input, destinationFile.toPath(), copyOptionArray);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        jarFile.close();
    }
}

