/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.codeinsight.generator.java;

import com.alibaba.bizworks.codeinsight.adl.AdlDeclaration;
import com.alibaba.bizworks.codeinsight.generator.java.CompilationUnitGenerator;
import com.alibaba.bizworks.codeinsight.generator.java.GeneratedCodeMeta;
import com.alibaba.bizworks.codeinsight.utils.AdlTypeConvertor;
import com.alibaba.bizworks.codeinsight.utils.AnnotationMeta;
import com.alibaba.bizworks.codeinsight.utils.ClassMeta;
import com.alibaba.bizworks.codeinsight.utils.JavaParserHelper;
import com.alibaba.bizworks.codeinsight.utils.ModuleMeta;
import com.alibaba.bizworks.codeinsight.utils.PackageHelper;
import com.alibaba.bizworks.codeinsight.utils.ProjectMeta;
import com.alibaba.bizworks.codeinsight.utils.ProjectPathResolver;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.LineComment;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.util.ArrayList;
import java.util.List;

public class ApplicationServiceCompilationUnitGenerator
implements CompilationUnitGenerator {
    private final AdlDeclaration adlDeclaration;
    private final ProjectMeta projectMeta;
    private final ModuleMeta moduleMeta;
    private final AdlTypeConvertor adlTypeConvertor;
    private final ProjectPathResolver projectPathResolver;

    ApplicationServiceCompilationUnitGenerator(AdlDeclaration adlDeclaration, ProjectMeta projectMeta, ModuleMeta moduleMeta) {
        this.adlDeclaration = adlDeclaration;
        this.projectMeta = projectMeta;
        this.moduleMeta = moduleMeta;
        this.adlTypeConvertor = new AdlTypeConvertor(projectMeta, moduleMeta);
        this.projectPathResolver = new ProjectPathResolver(projectMeta, moduleMeta);
    }

    private GeneratedCodeMeta generateInterface() {
        String cuName = this.adlDeclaration.getName().getText();
        CompilationUnit cu = new CompilationUnit();
        cu.setPackageDeclaration(PackageHelper.getApplicationServiceInterfacePackage(this.projectMeta.getGroupId(), this.projectMeta.getArtifactIdForPackage(), this.moduleMeta.getBoundContextName()));
        ClassOrInterfaceDeclaration cid = cu.addInterface(cuName);
        JavaParserHelper.addAnnotation((NodeWithAnnotations)cid, AnnotationMeta.create("com.alibaba.bizworks.core.specification.ddd.ApplicationService").addString("name", cuName).addString("boundedContext", this.moduleMeta.getBoundContextName()));
        List<AdlDeclaration> serviceFuncList = this.adlDeclaration.getFuncList();
        if (serviceFuncList != null && !serviceFuncList.isEmpty()) {
            for (AdlDeclaration func : serviceFuncList) {
                String methodName = func.getName().getText();
                MethodDeclaration methodDeclaration = cid.addMethod(methodName, new Modifier.Keyword[0]);
                methodDeclaration.setBody(null);
                JavaParserHelper.addAnnotation((NodeWithAnnotations)methodDeclaration, AnnotationMeta.create("com.alibaba.bizworks.core.specification.ReturnValue"));
                JavaParserHelper.addAnnotation((NodeWithAnnotations)methodDeclaration, AnnotationMeta.create("com.alibaba.bizworks.core.specification.Method").addString("name", methodName).addString("desc", methodName));
                List<AdlDeclaration> parameters = func.getParameters();
                if (parameters != null && !parameters.isEmpty()) {
                    for (AdlDeclaration parameter : parameters) {
                        ClassMeta classMeta = this.adlTypeConvertor.to(parameter.getType());
                        Parameter p = methodDeclaration.addAndGetParameter(classMeta.getSimpleName(), parameter.getName().getText());
                        JavaParserHelper.addImportIfNecessary(cu, classMeta);
                        JavaParserHelper.addAnnotation((NodeWithAnnotations)p, AnnotationMeta.create("com.alibaba.bizworks.core.specification.Parameter"));
                    }
                }
                ClassMeta classMeta = this.adlTypeConvertor.to(func.getReturnType());
                methodDeclaration.setType(classMeta.getSimpleName());
                JavaParserHelper.addImportIfNecessary(cu, classMeta);
            }
        }
        JavaParserHelper.sortImports(cu);
        return new GeneratedCodeMeta(cu, this.projectPathResolver.getOrCreateApplicationInterfacePath(), ((PackageDeclaration)cu.getPackageDeclaration().get()).getNameAsString(), cuName);
    }

    private GeneratedCodeMeta generateImplementation() {
        String cuName = this.adlDeclaration.getName().getText();
        CompilationUnit cu = new CompilationUnit();
        cu.setPackageDeclaration(PackageHelper.getApplicationServiceImplementationPackage(this.projectMeta.getGroupId(), this.projectMeta.getArtifactIdForPackage(), this.moduleMeta.getBoundContextName()));
        ClassOrInterfaceDeclaration cid = cu.addClass(cuName + "Impl");
        String asInterfacePackage = PackageHelper.getApplicationServiceInterfacePackage(this.projectMeta.getGroupId(), this.projectMeta.getArtifactIdForPackage(), this.moduleMeta.getBoundContextName());
        JavaParserHelper.addImportIfNecessary(cu, new ClassMeta(asInterfacePackage, cuName));
        cid.addImplementedType(cuName);
        JavaParserHelper.addAnnotation((NodeWithAnnotations)cid, AnnotationMeta.create("org.springframework.stereotype.Component"));
        List<AdlDeclaration> serviceFuncList = this.adlDeclaration.getFuncList();
        if (serviceFuncList != null && !serviceFuncList.isEmpty()) {
            for (AdlDeclaration func : serviceFuncList) {
                String methodName = func.getName().getText();
                MethodDeclaration methodDeclaration = cid.addMethod(methodName, new Modifier.Keyword[0]);
                methodDeclaration.setModifiers(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
                JavaParserHelper.addAnnotation((NodeWithAnnotations)methodDeclaration, AnnotationMeta.create(Override.class.getName()));
                List<AdlDeclaration> parameters = func.getParameters();
                if (parameters != null && !parameters.isEmpty()) {
                    for (AdlDeclaration parameter : parameters) {
                        ClassMeta classMeta = this.adlTypeConvertor.to(parameter.getType());
                        methodDeclaration.addAndGetParameter(classMeta.getSimpleName(), parameter.getName().getText());
                        JavaParserHelper.addImportIfNecessary(cu, classMeta);
                    }
                }
                ClassMeta classMeta = this.adlTypeConvertor.to(func.getReturnType());
                methodDeclaration.setType(classMeta.getSimpleName());
                JavaParserHelper.addImportIfNecessary(cu, classMeta);
                BlockStmt body = new BlockStmt();
                methodDeclaration.setBody(body);
                body.addOrphanComment((Comment)new LineComment(" TODO: implement method"));
                if (classMeta.isVoid()) continue;
                body.addStatement((Statement)new ReturnStmt((Expression)new NullLiteralExpr()));
            }
        }
        JavaParserHelper.sortImports(cu);
        return new GeneratedCodeMeta(cu, this.projectPathResolver.getOrCreateApplicationImplementationPath(), ((PackageDeclaration)cu.getPackageDeclaration().get()).getNameAsString(), cuName + "Impl");
    }

    private GeneratedCodeMeta generateClient() {
        String cuName = this.adlDeclaration.getName().getText();
        CompilationUnit cu = new CompilationUnit();
        cu.setPackageDeclaration(PackageHelper.getApplicationServiceClientPackage(this.projectMeta.getGroupId(), this.projectMeta.getArtifactIdForPackage(), this.moduleMeta.getBoundContextName()));
        ClassOrInterfaceDeclaration cid = cu.addInterface(cuName + "I");
        JavaParserHelper.addAnnotation((NodeWithAnnotations)cid, AnnotationMeta.create("org.springframework.cloud.openfeign.FeignClient").addString("value", this.projectMeta.getArtifactId()).addString("path", "/" + this.moduleMeta.getBoundContextName()).addString("contextId", cuName + "I"));
        List<AdlDeclaration> serviceFuncList = this.adlDeclaration.getFuncList();
        if (serviceFuncList != null && !serviceFuncList.isEmpty()) {
            for (AdlDeclaration func : serviceFuncList) {
                String methodName = func.getName().getText();
                MethodDeclaration methodDeclaration = cid.addMethod(methodName, new Modifier.Keyword[0]);
                methodDeclaration.setBody(null);
                JavaParserHelper.addAnnotation((NodeWithAnnotations)methodDeclaration, AnnotationMeta.create("org.springframework.web.bind.annotation.PostMapping").addString("path", "/" + cuName + "/" + methodName + "/v1"));
                List<AdlDeclaration> parameters = func.getParameters();
                if (parameters != null && !parameters.isEmpty()) {
                    for (AdlDeclaration parameter : parameters) {
                        ClassMeta classMeta = this.adlTypeConvertor.to(parameter.getType());
                        Parameter p = methodDeclaration.addAndGetParameter(classMeta.getSimpleName(), parameter.getName().getText());
                        JavaParserHelper.addImportIfNecessary(cu, classMeta);
                        JavaParserHelper.addAnnotation((NodeWithAnnotations)p, AnnotationMeta.create("org.springframework.web.bind.annotation.RequestBody"));
                    }
                }
                ClassMeta classMeta = this.adlTypeConvertor.to(func.getReturnType());
                methodDeclaration.setType(JavaParserHelper.createTypeWithArguments("Response", classMeta.getSimpleName()));
                cu.addImport("com.alibaba.bizworks.core.runtime.common.Response");
                JavaParserHelper.addImportIfNecessary(cu, classMeta);
            }
        }
        JavaParserHelper.sortImports(cu);
        return new GeneratedCodeMeta(cu, this.projectPathResolver.getOrCreateApplicationClientPath(), ((PackageDeclaration)cu.getPackageDeclaration().get()).getNameAsString(), cuName + "I");
    }

    private GeneratedCodeMeta generateEntry() {
        String cuName = this.adlDeclaration.getName().getText();
        CompilationUnit cu = new CompilationUnit();
        cu.setPackageDeclaration(PackageHelper.getApplicationServiceEntryPackage(this.projectMeta.getGroupId(), this.projectMeta.getArtifactIdForPackage(), this.moduleMeta.getBoundContextName()));
        ClassOrInterfaceDeclaration cid = cu.addClass(cuName + "Controller");
        String asInterfacePackage = PackageHelper.getApplicationServiceClientPackage(this.projectMeta.getGroupId(), this.projectMeta.getArtifactIdForPackage(), this.moduleMeta.getBoundContextName());
        JavaParserHelper.addImportIfNecessary(cu, new ClassMeta(asInterfacePackage, cuName + "I"));
        cid.addImplementedType(cuName + "I");
        JavaParserHelper.addAnnotation((NodeWithAnnotations)cid, AnnotationMeta.create("org.springframework.web.bind.annotation.RestController"));
        JavaParserHelper.addAnnotation((NodeWithAnnotations)cid, AnnotationMeta.create("org.springframework.web.bind.annotation.RequestMapping").addString("path", "/" + this.moduleMeta.getBoundContextName()));
        List<AdlDeclaration> serviceFuncList = this.adlDeclaration.getFuncList();
        if (serviceFuncList != null && !serviceFuncList.isEmpty()) {
            for (AdlDeclaration func : serviceFuncList) {
                String methodName = func.getName().getText();
                MethodDeclaration methodDeclaration = cid.addMethod(methodName, new Modifier.Keyword[0]);
                methodDeclaration.setModifiers(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
                JavaParserHelper.addAnnotation((NodeWithAnnotations)methodDeclaration, AnnotationMeta.create(Override.class.getName()));
                List<AdlDeclaration> parameters = func.getParameters();
                if (parameters != null && !parameters.isEmpty()) {
                    for (AdlDeclaration parameter : parameters) {
                        ClassMeta classMeta = this.adlTypeConvertor.to(parameter.getType());
                        methodDeclaration.addAndGetParameter(classMeta.getSimpleName(), parameter.getName().getText());
                        JavaParserHelper.addImportIfNecessary(cu, classMeta);
                    }
                }
                ClassMeta classMeta = this.adlTypeConvertor.to(func.getReturnType());
                methodDeclaration.setType(JavaParserHelper.createTypeWithArguments("Response", classMeta.getSimpleName()));
                cu.addImport("com.alibaba.bizworks.core.runtime.common.Response");
                JavaParserHelper.addImportIfNecessary(cu, classMeta);
                BlockStmt methodBody = new BlockStmt();
                Statement returnStmt = StaticJavaParser.parseStatement((String)"return Response.buildSuccess();");
                methodBody.addStatement(returnStmt);
                methodDeclaration.setBody(methodBody);
            }
        }
        JavaParserHelper.sortImports(cu);
        return new GeneratedCodeMeta(cu, this.projectPathResolver.getOrCreateApplicationEntryPath(), ((PackageDeclaration)cu.getPackageDeclaration().get()).getNameAsString(), cuName + "Controller");
    }

    @Override
    public List<GeneratedCodeMeta> generate() {
        ArrayList<GeneratedCodeMeta> generatedCodeMetas = new ArrayList<GeneratedCodeMeta>();
        generatedCodeMetas.add(this.generateInterface());
        generatedCodeMetas.add(this.generateImplementation());
        generatedCodeMetas.add(this.generateClient());
        generatedCodeMetas.add(this.generateEntry());
        return generatedCodeMetas;
    }
}

