/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.codeinsight.generator.java;

import com.alibaba.bizworks.codeinsight.generator.java.CompilationUnitGenerator;
import com.alibaba.bizworks.codeinsight.generator.java.GeneratedCodeMeta;
import com.alibaba.bizworks.codeinsight.utils.AnnotationMeta;
import com.alibaba.bizworks.codeinsight.utils.JavaParserHelper;
import com.alibaba.bizworks.codeinsight.utils.PackageHelper;
import com.alibaba.bizworks.codeinsight.utils.ProjectMeta;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class MainAppCompilationUnitGenerator
implements CompilationUnitGenerator {
    private final ProjectMeta projectMeta;

    MainAppCompilationUnitGenerator(ProjectMeta projectMeta) {
        this.projectMeta = projectMeta;
    }

    private GeneratedCodeMeta generateEntity() {
        String cuName = "Application";
        CompilationUnit cu = new CompilationUnit();
        cu.setPackageDeclaration(PackageHelper.getMainAppPackage(this.projectMeta.getGroupId(), this.projectMeta.getArtifactIdForPackage()));
        ClassOrInterfaceDeclaration cid = cu.addClass(cuName);
        cid.setModifiers(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        AnnotationMeta springBootApplicationAnno = AnnotationMeta.create("org.springframework.boot.autoconfigure.SpringBootApplication");
        JavaParserHelper.addAnnotation((NodeWithAnnotations)cid, springBootApplicationAnno);
        cu.addImport("org.springframework.boot.SpringApplication");
        MethodDeclaration methodDeclaration = cid.addMethod("main", new Modifier.Keyword[0]);
        methodDeclaration.setModifiers(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC, Modifier.Keyword.STATIC});
        methodDeclaration.addParameter("String[]", "args");
        methodDeclaration.setType("void");
        BlockStmt body = new BlockStmt();
        methodDeclaration.setBody(body);
        body.addStatement("SpringApplication.run(Application.class, args);");
        JavaParserHelper.sortImports(cu);
        return new GeneratedCodeMeta(cu, this.getOrCreatePath(), ((PackageDeclaration)cu.getPackageDeclaration().get()).getNameAsString(), cuName);
    }

    @Override
    public List<GeneratedCodeMeta> generate() {
        ArrayList<GeneratedCodeMeta> generatedCodeMetas = new ArrayList<GeneratedCodeMeta>();
        generatedCodeMetas.add(this.generateEntity());
        return generatedCodeMetas;
    }

    private String getOrCreatePath() {
        String appName = this.projectMeta.getAppName();
        String path = this.projectMeta.getProjectRootPath() + "/" + appName + "-starter/src/main/java";
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return path;
    }
}

