/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.codeinsight.generator.maven;

import com.alibaba.bizworks.codeinsight.generator.maven.GeneratedPomMeta;
import com.alibaba.bizworks.codeinsight.generator.maven.PomGenerator;
import com.alibaba.bizworks.codeinsight.utils.ModuleMeta;
import com.alibaba.bizworks.codeinsight.utils.ProjectMeta;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;

public class BoundedContextPomGenerator
implements PomGenerator {
    private final ProjectMeta projectMeta;
    private final ModuleMeta moduleMeta;

    public BoundedContextPomGenerator(ProjectMeta projectMeta, ModuleMeta moduleMeta) {
        this.projectMeta = projectMeta;
        this.moduleMeta = moduleMeta;
    }

    @Override
    public List<GeneratedPomMeta> generate() {
        ArrayList generatedPomMetas = Lists.newArrayList();
        generatedPomMetas.add(this.generateModulePom());
        generatedPomMetas.add(this.generateInterfacePom());
        generatedPomMetas.add(this.generateInterfaceClientPom());
        generatedPomMetas.add(this.generateInterfaceEntryPom());
        generatedPomMetas.add(this.generateApplicationPom());
        generatedPomMetas.add(this.generateApplicationContractPom());
        generatedPomMetas.add(this.generateApplicationServicePom());
        generatedPomMetas.add(this.generateApplicationServiceImplPom());
        generatedPomMetas.add(this.generateDomainPom());
        generatedPomMetas.add(this.generateInfrastructurePom());
        return generatedPomMetas;
    }

    private GeneratedPomMeta generateModulePom() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        Parent parent = new Parent();
        model.setParent(parent);
        parent.setGroupId(this.projectMeta.getGroupId());
        parent.setArtifactId(this.projectMeta.getArtifactId());
        parent.setVersion(this.projectMeta.getVersion());
        model.setArtifactId(this.moduleMeta.getBoundContextNameAsCode());
        model.setVersion(this.projectMeta.getVersion());
        model.setPackaging("pom");
        model.setName(this.moduleMeta.getBoundContextName());
        model.addModule(this.moduleMeta.getBoundContextNameAsCode() + "-interface");
        model.addModule(this.moduleMeta.getBoundContextNameAsCode() + "-application");
        model.addModule(this.moduleMeta.getBoundContextNameAsCode() + "-domain");
        model.addModule(this.moduleMeta.getBoundContextNameAsCode() + "-infrastructure");
        return new GeneratedPomMeta(model, this.getOrCreateModulePathAndFile());
    }

    private GeneratedPomMeta generateInterfacePom() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        Parent parent = new Parent();
        model.setParent(parent);
        parent.setGroupId(this.projectMeta.getGroupId());
        parent.setArtifactId(this.moduleMeta.getBoundContextNameAsCode());
        parent.setVersion(this.projectMeta.getVersion());
        model.setArtifactId(this.moduleMeta.getBoundContextNameAsCode() + "-interface");
        model.setVersion(this.projectMeta.getVersion());
        model.setPackaging("pom");
        model.addModule(this.moduleMeta.getBoundContextNameAsCode() + "-client");
        model.addModule(this.moduleMeta.getBoundContextNameAsCode() + "-entry");
        return new GeneratedPomMeta(model, this.getOrCreateInterfacePathAndFile());
    }

    private GeneratedPomMeta generateInterfaceClientPom() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        Parent parent = new Parent();
        model.setParent(parent);
        parent.setGroupId(this.projectMeta.getGroupId());
        parent.setArtifactId(this.moduleMeta.getBoundContextNameAsCode() + "-interface");
        parent.setVersion(this.projectMeta.getVersion());
        model.setArtifactId(this.moduleMeta.getBoundContextNameAsCode() + "-client");
        model.setVersion(this.projectMeta.getVersion());
        model.setPackaging("jar");
        Dependency contractDependency = new Dependency();
        contractDependency.setGroupId(this.projectMeta.getGroupId());
        contractDependency.setArtifactId(this.moduleMeta.getBoundContextNameAsCode() + "-contract");
        contractDependency.setVersion(this.projectMeta.getVersion());
        model.addDependency(contractDependency);
        Dependency springfoxBootStarter = new Dependency();
        springfoxBootStarter.setGroupId("io.springfox");
        springfoxBootStarter.setArtifactId("springfox-boot-starter");
        model.addDependency(springfoxBootStarter);
        Dependency springCloudStarterOpenfeign = new Dependency();
        springCloudStarterOpenfeign.setGroupId("org.springframework.cloud");
        springCloudStarterOpenfeign.setArtifactId("spring-cloud-starter-openfeign");
        model.addDependency(springCloudStarterOpenfeign);
        Dependency springCloudOpenfeignCore = new Dependency();
        springCloudOpenfeignCore.setGroupId("org.springframework.cloud");
        springCloudOpenfeignCore.setArtifactId("spring-cloud-openfeign-core");
        model.addDependency(springCloudOpenfeignCore);
        return new GeneratedPomMeta(model, this.getOrCreateInterfaceClientPathAndFile());
    }

    private GeneratedPomMeta generateInterfaceEntryPom() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        Parent parent = new Parent();
        model.setParent(parent);
        parent.setGroupId(this.projectMeta.getGroupId());
        parent.setArtifactId(this.moduleMeta.getBoundContextNameAsCode() + "-interface");
        parent.setVersion(this.projectMeta.getVersion());
        model.setArtifactId(this.moduleMeta.getBoundContextNameAsCode() + "-entry");
        model.setVersion(this.projectMeta.getVersion());
        model.setPackaging("jar");
        Dependency clientDependency = new Dependency();
        clientDependency.setGroupId(this.projectMeta.getGroupId());
        clientDependency.setArtifactId(this.moduleMeta.getBoundContextNameAsCode() + "-client");
        clientDependency.setVersion(this.projectMeta.getVersion());
        model.addDependency(clientDependency);
        Dependency serviceDependency = new Dependency();
        serviceDependency.setGroupId(this.projectMeta.getGroupId());
        serviceDependency.setArtifactId(this.moduleMeta.getBoundContextNameAsCode() + "-service");
        serviceDependency.setVersion(this.projectMeta.getVersion());
        model.addDependency(serviceDependency);
        return new GeneratedPomMeta(model, this.getOrCreateInterfaceEntryPathAndFile());
    }

    private GeneratedPomMeta generateApplicationPom() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        Parent parent = new Parent();
        model.setParent(parent);
        parent.setGroupId(this.projectMeta.getGroupId());
        parent.setArtifactId(this.moduleMeta.getBoundContextNameAsCode());
        parent.setVersion(this.projectMeta.getVersion());
        model.setArtifactId(this.moduleMeta.getBoundContextNameAsCode() + "-application");
        model.setVersion(this.projectMeta.getVersion());
        model.setPackaging("pom");
        model.addModule(this.moduleMeta.getBoundContextNameAsCode() + "-contract");
        model.addModule(this.moduleMeta.getBoundContextNameAsCode() + "-service");
        model.addModule(this.moduleMeta.getBoundContextNameAsCode() + "-service-impl");
        return new GeneratedPomMeta(model, this.getOrCreateApplicationPathAndFile());
    }

    private GeneratedPomMeta generateApplicationContractPom() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        Parent parent = new Parent();
        model.setParent(parent);
        parent.setGroupId(this.projectMeta.getGroupId());
        parent.setArtifactId(this.moduleMeta.getBoundContextNameAsCode() + "-application");
        parent.setVersion(this.projectMeta.getVersion());
        model.setArtifactId(this.moduleMeta.getBoundContextNameAsCode() + "-contract");
        model.setVersion(this.projectMeta.getVersion());
        model.setPackaging("jar");
        Dependency bwafCommonDto = new Dependency();
        bwafCommonDto.setGroupId("com.alibaba.bizworks");
        bwafCommonDto.setArtifactId("bwaf-common-dto");
        model.addDependency(bwafCommonDto);
        Dependency bwafCoreSpecificationCommon = new Dependency();
        bwafCoreSpecificationCommon.setGroupId("com.alibaba.bizworks");
        bwafCoreSpecificationCommon.setArtifactId("bwaf-core-specification-common");
        model.addDependency(bwafCoreSpecificationCommon);
        Dependency bwafCoreSpecificationDdd = new Dependency();
        bwafCoreSpecificationDdd.setGroupId("com.alibaba.bizworks");
        bwafCoreSpecificationDdd.setArtifactId("bwaf-core-specification-ddd");
        model.addDependency(bwafCoreSpecificationDdd);
        Dependency bwafCoreSpecificationPbc = new Dependency();
        bwafCoreSpecificationPbc.setGroupId("com.alibaba.bizworks");
        bwafCoreSpecificationPbc.setArtifactId("bwaf-core-specification-pbc");
        model.addDependency(bwafCoreSpecificationPbc);
        Dependency lombok = new Dependency();
        lombok.setGroupId("org.projectlombok");
        lombok.setArtifactId("lombok");
        model.addDependency(lombok);
        return new GeneratedPomMeta(model, this.getOrCreateApplicationContractPathAndFile());
    }

    private GeneratedPomMeta generateApplicationServicePom() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        Parent parent = new Parent();
        model.setParent(parent);
        parent.setGroupId(this.projectMeta.getGroupId());
        parent.setArtifactId(this.moduleMeta.getBoundContextNameAsCode() + "-application");
        parent.setVersion(this.projectMeta.getVersion());
        model.setArtifactId(this.moduleMeta.getBoundContextNameAsCode() + "-service");
        model.setVersion(this.projectMeta.getVersion());
        model.setPackaging("jar");
        Dependency contractDependency = new Dependency();
        contractDependency.setGroupId(this.projectMeta.getGroupId());
        contractDependency.setArtifactId(this.moduleMeta.getBoundContextNameAsCode() + "-contract");
        contractDependency.setVersion(this.projectMeta.getVersion());
        model.addDependency(contractDependency);
        return new GeneratedPomMeta(model, this.getOrCreateApplicationServicePathAndFile());
    }

    private GeneratedPomMeta generateApplicationServiceImplPom() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        Parent parent = new Parent();
        model.setParent(parent);
        parent.setGroupId(this.projectMeta.getGroupId());
        parent.setArtifactId(this.moduleMeta.getBoundContextNameAsCode() + "-application");
        parent.setVersion(this.projectMeta.getVersion());
        model.setArtifactId(this.moduleMeta.getBoundContextNameAsCode() + "-service-impl");
        model.setVersion(this.projectMeta.getVersion());
        model.setPackaging("jar");
        Dependency serviceDependency = new Dependency();
        serviceDependency.setGroupId(this.projectMeta.getGroupId());
        serviceDependency.setArtifactId(this.moduleMeta.getBoundContextNameAsCode() + "-service");
        serviceDependency.setVersion(this.projectMeta.getVersion());
        model.addDependency(serviceDependency);
        Dependency domainDependency = new Dependency();
        domainDependency.setGroupId(this.projectMeta.getGroupId());
        domainDependency.setArtifactId(this.moduleMeta.getBoundContextNameAsCode() + "-domain");
        domainDependency.setVersion(this.projectMeta.getVersion());
        model.addDependency(domainDependency);
        Dependency infrastructureDependency = new Dependency();
        infrastructureDependency.setGroupId(this.projectMeta.getGroupId());
        infrastructureDependency.setArtifactId(this.moduleMeta.getBoundContextNameAsCode() + "-infrastructure");
        infrastructureDependency.setVersion(this.projectMeta.getVersion());
        model.addDependency(infrastructureDependency);
        return new GeneratedPomMeta(model, this.getOrCreateApplicationServiceImplPathAndFile());
    }

    private GeneratedPomMeta generateDomainPom() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        Parent parent = new Parent();
        model.setParent(parent);
        parent.setGroupId(this.projectMeta.getGroupId());
        parent.setArtifactId(this.moduleMeta.getBoundContextNameAsCode());
        parent.setVersion(this.projectMeta.getVersion());
        model.setArtifactId(this.moduleMeta.getBoundContextNameAsCode() + "-domain");
        model.setVersion(this.projectMeta.getVersion());
        model.setPackaging("jar");
        Dependency bwafCommonDto = new Dependency();
        bwafCommonDto.setGroupId("com.alibaba.bizworks");
        bwafCommonDto.setArtifactId("bwaf-common-dto");
        model.addDependency(bwafCommonDto);
        Dependency bwafCoreSpecificationCommon = new Dependency();
        bwafCoreSpecificationCommon.setGroupId("com.alibaba.bizworks");
        bwafCoreSpecificationCommon.setArtifactId("bwaf-core-specification-common");
        model.addDependency(bwafCoreSpecificationCommon);
        Dependency bwafCoreSpecificationDdd = new Dependency();
        bwafCoreSpecificationDdd.setGroupId("com.alibaba.bizworks");
        bwafCoreSpecificationDdd.setArtifactId("bwaf-core-specification-ddd");
        model.addDependency(bwafCoreSpecificationDdd);
        Dependency bwafComponentDddDomainfactorySdk = new Dependency();
        bwafComponentDddDomainfactorySdk.setGroupId("com.alibaba.bizworks");
        bwafComponentDddDomainfactorySdk.setArtifactId("bwaf-component-ddd-domainfactory-sdk");
        model.addDependency(bwafComponentDddDomainfactorySdk);
        Dependency lombok = new Dependency();
        lombok.setGroupId("org.projectlombok");
        lombok.setArtifactId("lombok");
        model.addDependency(lombok);
        return new GeneratedPomMeta(model, this.getOrCreateDomainPathAndFile());
    }

    private GeneratedPomMeta generateInfrastructurePom() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        Parent parent = new Parent();
        model.setParent(parent);
        parent.setGroupId(this.projectMeta.getGroupId());
        parent.setArtifactId(this.moduleMeta.getBoundContextNameAsCode());
        parent.setVersion(this.projectMeta.getVersion());
        model.setArtifactId(this.moduleMeta.getBoundContextNameAsCode() + "-infrastructure");
        model.setVersion(this.projectMeta.getVersion());
        model.setPackaging("jar");
        Dependency domainDependency = new Dependency();
        domainDependency.setGroupId(this.projectMeta.getGroupId());
        domainDependency.setArtifactId(this.moduleMeta.getBoundContextNameAsCode() + "-domain");
        domainDependency.setVersion(this.projectMeta.getVersion());
        model.addDependency(domainDependency);
        Dependency mybatisPlusExtension = new Dependency();
        mybatisPlusExtension.setGroupId("com.baomidou");
        mybatisPlusExtension.setArtifactId("mybatis-plus-extension");
        model.addDependency(mybatisPlusExtension);
        Dependency mysqlConnectorJava = new Dependency();
        mysqlConnectorJava.setGroupId("mysql");
        mysqlConnectorJava.setArtifactId("mysql-connector-java");
        model.addDependency(mysqlConnectorJava);
        Dependency mybatisEnhanceActable = new Dependency();
        mybatisEnhanceActable.setGroupId("com.gitee.sunchenbin.mybatis.actable");
        mybatisEnhanceActable.setArtifactId("mybatis-enhance-actable");
        model.addDependency(mybatisEnhanceActable);
        Dependency springCloudOpenfeignCore = new Dependency();
        springCloudOpenfeignCore.setGroupId("org.springframework.cloud");
        springCloudOpenfeignCore.setArtifactId("spring-cloud-openfeign-core");
        model.addDependency(springCloudOpenfeignCore);
        Dependency mapstruct = new Dependency();
        mapstruct.setGroupId("org.mapstruct");
        mapstruct.setArtifactId("mapstruct");
        model.addDependency(mapstruct);
        Dependency mapstructProcessor = new Dependency();
        mapstructProcessor.setGroupId("org.mapstruct");
        mapstructProcessor.setArtifactId("mapstruct-processor");
        model.addDependency(mapstructProcessor);
        Dependency mapstructJdk8 = new Dependency();
        mapstructJdk8.setGroupId("org.mapstruct");
        mapstructJdk8.setArtifactId("mapstruct-jdk8");
        model.addDependency(mapstructJdk8);
        return new GeneratedPomMeta(model, this.getOrCreateInfrastructurePathAndFile());
    }

    private String getOrCreatePath(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return path;
    }

    private String getBasePath() {
        return this.projectMeta.getProjectRootPath() + "/" + this.moduleMeta.getBoundContextNameAsCode();
    }

    private String getOrCreateModulePathAndFile() {
        return this.getOrCreatePath(this.getBasePath()) + "/pom.xml";
    }

    private String getOrCreateInterfacePathAndFile() {
        String path = this.getBasePath() + "/" + this.moduleMeta.getBoundContextNameAsCode() + "-interface";
        return this.getOrCreatePath(path) + "/pom.xml";
    }

    private String getOrCreateInterfaceClientPathAndFile() {
        String path = this.getBasePath() + "/" + this.moduleMeta.getBoundContextNameAsCode() + "-interface/" + this.moduleMeta.getBoundContextNameAsCode() + "-client";
        return this.getOrCreatePath(path) + "/pom.xml";
    }

    private String getOrCreateInterfaceEntryPathAndFile() {
        String path = this.getBasePath() + "/" + this.moduleMeta.getBoundContextNameAsCode() + "-interface/" + this.moduleMeta.getBoundContextNameAsCode() + "-entry";
        return this.getOrCreatePath(path) + "/pom.xml";
    }

    private String getOrCreateApplicationPathAndFile() {
        String path = this.getBasePath() + "/" + this.moduleMeta.getBoundContextNameAsCode() + "-application";
        return this.getOrCreatePath(path) + "/pom.xml";
    }

    private String getOrCreateApplicationContractPathAndFile() {
        String path = this.getBasePath() + "/" + this.moduleMeta.getBoundContextNameAsCode() + "-application/" + this.moduleMeta.getBoundContextNameAsCode() + "-contract";
        return this.getOrCreatePath(path) + "/pom.xml";
    }

    private String getOrCreateApplicationServicePathAndFile() {
        String path = this.getBasePath() + "/" + this.moduleMeta.getBoundContextNameAsCode() + "-application/" + this.moduleMeta.getBoundContextNameAsCode() + "-service";
        return this.getOrCreatePath(path) + "/pom.xml";
    }

    private String getOrCreateApplicationServiceImplPathAndFile() {
        String path = this.getBasePath() + "/" + this.moduleMeta.getBoundContextNameAsCode() + "-application/" + this.moduleMeta.getBoundContextNameAsCode() + "-service-impl";
        return this.getOrCreatePath(path) + "/pom.xml";
    }

    private String getOrCreateDomainPathAndFile() {
        String path = this.getBasePath() + "/" + this.moduleMeta.getBoundContextNameAsCode() + "-domain";
        return this.getOrCreatePath(path) + "/pom.xml";
    }

    private String getOrCreateInfrastructurePathAndFile() {
        String path = this.getBasePath() + "/" + this.moduleMeta.getBoundContextNameAsCode() + "-infrastructure";
        return this.getOrCreatePath(path) + "/pom.xml";
    }
}

