/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.codeinsight.generator.maven;

import com.alibaba.bizworks.codeinsight.generator.maven.GeneratedPomMeta;
import com.alibaba.bizworks.codeinsight.generator.maven.PomGenerator;
import com.alibaba.bizworks.codeinsight.utils.ProjectMeta;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class ProjectRootPomGenerator
implements PomGenerator {
    private ProjectMeta projectMeta;

    public ProjectRootPomGenerator(ProjectMeta projectMeta) {
        this.projectMeta = projectMeta;
    }

    @Override
    public List<GeneratedPomMeta> generate() {
        ArrayList generatedPomMetas = Lists.newArrayList();
        generatedPomMetas.add(this.generateProjectRootPom());
        return generatedPomMetas;
    }

    private GeneratedPomMeta generateProjectRootPom() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(this.projectMeta.getGroupId());
        model.setArtifactId(this.projectMeta.getArtifactId());
        model.setVersion(this.projectMeta.getVersion());
        model.setPackaging("pom");
        model.setName(this.projectMeta.getArtifactId());
        Properties properties = new Properties();
        properties.setProperty("maven.compiler.source", "1.8");
        properties.setProperty("maven.compiler.target", "1.8");
        properties.setProperty("java.product.version", "1.8");
        properties.setProperty("spring-cloud-dependencies-version", "Hoxton.RELEASE");
        properties.setProperty("springfox-boot-starter.version", "3.0.0");
        properties.setProperty("spring-boot.version", "2.3.12.RELEASE");
        properties.setProperty("mapstruct-jdk8.version", "1.4.2.Final");
        properties.setProperty("mybatis-enhance-actable.version", "1.5.0.RELEASE");
        properties.setProperty("mapstruct-processor.version", "1.4.2.Final");
        properties.setProperty("h2.version", "2.1.214");
        properties.setProperty("mapstruct.version", "1.4.2.Final");
        properties.setProperty("project.reporting.outputEncoding", "UTF-8");
        properties.setProperty("springcloud-alicloud-version", "2.2.0.RELEASE");
        properties.setProperty("project.build.sourceEncoding", "UTF-8");
        properties.setProperty("bizworks.bwaf.version", "2.3.1");
        properties.setProperty("mybatis-plus-extension.version", "3.2.0");
        properties.setProperty("mybatis-plus-boot-starter.version", "3.2.0");
        model.setProperties(properties);
        DependencyManagement dependencyManagement = new DependencyManagement();
        model.setDependencyManagement(dependencyManagement);
        Dependency springBootDependencies = new Dependency();
        springBootDependencies.setGroupId("org.springframework.boot");
        springBootDependencies.setArtifactId("spring-boot-dependencies");
        springBootDependencies.setVersion("${spring-boot.version}");
        springBootDependencies.setType("pom");
        springBootDependencies.setScope("import");
        Dependency springCloudAlibabaDependencies = new Dependency();
        springCloudAlibabaDependencies.setGroupId("com.alibaba.cloud");
        springCloudAlibabaDependencies.setArtifactId("spring-cloud-alibaba-dependencies");
        springCloudAlibabaDependencies.setVersion("${springcloud-alicloud-version}");
        springCloudAlibabaDependencies.setType("pom");
        springCloudAlibabaDependencies.setScope("import");
        Dependency springCloudDependencies = new Dependency();
        springCloudDependencies.setGroupId("org.springframework.cloud");
        springCloudDependencies.setArtifactId("spring-cloud-dependencies");
        springCloudDependencies.setVersion("${spring-cloud-dependencies-version}");
        springCloudDependencies.setType("pom");
        springCloudDependencies.setScope("import");
        Dependency bwafCommonDto = new Dependency();
        bwafCommonDto.setGroupId("com.alibaba.bizworks");
        bwafCommonDto.setArtifactId("bwaf-common-dto");
        bwafCommonDto.setVersion("${bizworks.bwaf.version}");
        Dependency bwafCoreSpecificationCommon = new Dependency();
        bwafCoreSpecificationCommon.setGroupId("com.alibaba.bizworks");
        bwafCoreSpecificationCommon.setArtifactId("bwaf-core-specification-common");
        bwafCoreSpecificationCommon.setVersion("${bizworks.bwaf.version}");
        Dependency bwafCoreSpecificationDdd = new Dependency();
        bwafCoreSpecificationDdd.setGroupId("com.alibaba.bizworks");
        bwafCoreSpecificationDdd.setArtifactId("bwaf-core-specification-ddd");
        bwafCoreSpecificationDdd.setVersion("${bizworks.bwaf.version}");
        Dependency bwafCoreSpecificationPbc = new Dependency();
        bwafCoreSpecificationPbc.setGroupId("com.alibaba.bizworks");
        bwafCoreSpecificationPbc.setArtifactId("bwaf-core-specification-pbc");
        bwafCoreSpecificationPbc.setVersion("${bizworks.bwaf.version}");
        Dependency bwafCoreTrafficLogging = new Dependency();
        bwafCoreTrafficLogging.setGroupId("com.alibaba.bizworks");
        bwafCoreTrafficLogging.setArtifactId("bwaf-core-traffic-logging");
        bwafCoreTrafficLogging.setVersion("${bizworks.bwaf.version}");
        Dependency bwafComponentDddDomainfactorySdk = new Dependency();
        bwafComponentDddDomainfactorySdk.setGroupId("com.alibaba.bizworks");
        bwafComponentDddDomainfactorySdk.setArtifactId("bwaf-component-ddd-domainfactory-sdk");
        bwafComponentDddDomainfactorySdk.setVersion("${bizworks.bwaf.version}");
        Dependency springfoxBootStarter = new Dependency();
        springfoxBootStarter.setGroupId("io.springfox");
        springfoxBootStarter.setArtifactId("springfox-boot-starter");
        springfoxBootStarter.setVersion("${springfox-boot-starter.version}");
        Dependency mybatisPlusBootStarter = new Dependency();
        mybatisPlusBootStarter.setGroupId("com.baomidou");
        mybatisPlusBootStarter.setArtifactId("mybatis-plus-boot-starter");
        mybatisPlusBootStarter.setVersion("${mybatis-plus-boot-starter.version}");
        Dependency mybatisPlusExtension = new Dependency();
        mybatisPlusExtension.setGroupId("com.baomidou");
        mybatisPlusExtension.setArtifactId("mybatis-plus-extension");
        mybatisPlusExtension.setVersion("${mybatis-plus-extension.version}");
        Dependency h2 = new Dependency();
        h2.setGroupId("com.h2database");
        h2.setArtifactId("h2");
        h2.setVersion("${h2.version}");
        Dependency mybatisEnhanceActable = new Dependency();
        mybatisEnhanceActable.setGroupId("com.gitee.sunchenbin.mybatis.actable");
        mybatisEnhanceActable.setArtifactId("mybatis-enhance-actable");
        mybatisEnhanceActable.setVersion("${mybatis-enhance-actable.version}");
        Dependency mapstruct = new Dependency();
        mapstruct.setGroupId("org.mapstruct");
        mapstruct.setArtifactId("mapstruct");
        mapstruct.setVersion("${mapstruct.version}");
        Dependency mapstructProcessor = new Dependency();
        mapstructProcessor.setGroupId("org.mapstruct");
        mapstructProcessor.setArtifactId("mapstruct-processor");
        mapstructProcessor.setVersion("${mapstruct-processor.version}");
        Dependency mapstructJdk8 = new Dependency();
        mapstructJdk8.setGroupId("org.mapstruct");
        mapstructJdk8.setArtifactId("mapstruct-jdk8");
        mapstructJdk8.setVersion("${mapstruct-jdk8.version}");
        dependencyManagement.addDependency(springBootDependencies);
        dependencyManagement.addDependency(springCloudAlibabaDependencies);
        dependencyManagement.addDependency(springCloudDependencies);
        dependencyManagement.addDependency(bwafCommonDto);
        dependencyManagement.addDependency(bwafCoreSpecificationCommon);
        dependencyManagement.addDependency(bwafCoreSpecificationDdd);
        dependencyManagement.addDependency(bwafCoreSpecificationPbc);
        dependencyManagement.addDependency(bwafCoreTrafficLogging);
        dependencyManagement.addDependency(bwafComponentDddDomainfactorySdk);
        dependencyManagement.addDependency(springfoxBootStarter);
        dependencyManagement.addDependency(mybatisPlusBootStarter);
        dependencyManagement.addDependency(mybatisPlusExtension);
        dependencyManagement.addDependency(h2);
        dependencyManagement.addDependency(mybatisEnhanceActable);
        dependencyManagement.addDependency(mapstruct);
        dependencyManagement.addDependency(mapstructProcessor);
        dependencyManagement.addDependency(mapstructJdk8);
        Build build = new Build();
        model.setBuild(build);
        Plugin mavenSourcePlugin = new Plugin();
        mavenSourcePlugin.setGroupId("org.apache.maven.plugins");
        mavenSourcePlugin.setArtifactId("maven-source-plugin");
        mavenSourcePlugin.setVersion("3.0.1");
        build.addPlugin(mavenSourcePlugin);
        Plugin springBootMavenPlugin = new Plugin();
        springBootMavenPlugin.setGroupId("org.springframework.boot");
        springBootMavenPlugin.setArtifactId("spring-boot-maven-plugin");
        springBootMavenPlugin.setVersion("2.4.4");
        build.addPlugin(springBootMavenPlugin);
        Plugin mavenCompilerPlugin = new Plugin();
        mavenCompilerPlugin.setGroupId("org.apache.maven.plugins");
        mavenCompilerPlugin.setArtifactId("maven-compiler-plugin");
        mavenCompilerPlugin.setVersion("3.5.1");
        build.addPlugin(mavenCompilerPlugin);
        Xpp3Dom configuration = new Xpp3Dom("configuration");
        Xpp3Dom source = new Xpp3Dom("source");
        source.setValue("1.8");
        configuration.addChild(source);
        Xpp3Dom target = new Xpp3Dom("target");
        target.setValue("1.8");
        configuration.addChild(target);
        Xpp3Dom compilerArgument = new Xpp3Dom("compilerArgument");
        compilerArgument.setValue("-parameters");
        configuration.addChild(compilerArgument);
        mavenCompilerPlugin.setConfiguration((Object)configuration);
        GeneratedPomMeta generatedPomMeta = new GeneratedPomMeta(model, this.getOrCreatePathAndFile());
        return generatedPomMeta;
    }

    private String getOrCreatePathAndFile() {
        String path = this.projectMeta.getProjectRootPath();
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return path + "/pom.xml";
    }
}

