/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.codeinsight.utils;

public class ClassMeta {
    private String packageName;
    private String simpleName;

    public ClassMeta(String packageName, String simpleName) {
        this.packageName = packageName;
        this.simpleName = simpleName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getFullName() {
        if (this.packageName == null || this.packageName.isEmpty()) {
            return this.simpleName;
        }
        return this.packageName + "." + this.simpleName;
    }

    public boolean isVoid() {
        return "void".equals(this.simpleName);
    }

    public boolean isJavaLang() {
        return "java.lang".equals(this.packageName);
    }

    public static ClassMeta to(Class<?> clazz) {
        String packageName = clazz.getPackage() == null ? "" : clazz.getPackage().getName();
        return new ClassMeta(packageName, clazz.getSimpleName());
    }

    public static ClassMeta to(String packageName, String simpleName) {
        return new ClassMeta(packageName, simpleName);
    }

    public static ClassMeta to(String className) {
        int index = className.lastIndexOf(".");
        if (index == -1) {
            return new ClassMeta("", className);
        }
        return new ClassMeta(className.substring(0, index), className.substring(index + 1));
    }
}

