/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.app.converter;

import com.alibaba.bizworks.ide.domain.app.BwApp;
import com.alibaba.bizworks.sync.infra.app.converter.BwAppConverter;
import com.alibaba.bizworks.sync.infra.app.dto.AppDTO;
import com.alibaba.bizworks.sync.infra.app.dto.AppVersionOnlyDTO;
import com.alibaba.bizworks.sync.infra.meta.converter.AppResourceTypeConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.AppTypeConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.ModuleVersionStatusConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.mapstruct.factory.Mappers;

public class BwAppConverterImpl
implements BwAppConverter {
    private final ModuleVersionStatusConverter moduleVersionStatusConverter = (ModuleVersionStatusConverter)Mappers.getMapper(ModuleVersionStatusConverter.class);
    private final AppResourceTypeConverter appResourceTypeConverter = (AppResourceTypeConverter)Mappers.getMapper(AppResourceTypeConverter.class);
    private final AppTypeConverter appTypeConverter = (AppTypeConverter)Mappers.getMapper(AppTypeConverter.class);

    @Override
    public BwApp toBwApp(AppDTO appDTO) {
        if (appDTO == null) {
            return null;
        }
        BwApp bwApp = new BwApp();
        bwApp.setVersion(this.appDTOVersionNumber(appDTO));
        bwApp.setVersionStatus(this.moduleVersionStatusConverter.toEnum(this.appDTOVersionStatus(appDTO)));
        bwApp.setProjectCode(appDTO.getProjectCode());
        bwApp.setProjectName(appDTO.getProjectName());
        bwApp.setApplicationCode(appDTO.getApplicationCode());
        bwApp.setName(appDTO.getName());
        bwApp.setDemo(appDTO.isDemo());
        bwApp.setType(this.appTypeConverter.toEnum(appDTO.getType()));
        bwApp.setResourceType(this.appResourceTypeConverter.toEnum(appDTO.getResourceType()));
        bwApp.setProjectIconId(appDTO.getProjectIconId());
        bwApp.setProjectIconColor(appDTO.getProjectIconColor());
        bwApp.setApplicationIconId(appDTO.getApplicationIconId());
        bwApp.setApplicationIconColor(appDTO.getApplicationIconColor());
        bwApp.setCodebaseWebUrl(appDTO.getCodebaseWebUrl());
        bwApp.setCodebaseSourceUrl(appDTO.getCodebaseSourceUrl());
        return bwApp;
    }

    @Override
    public List<BwApp> toBwAppList(Collection<AppDTO> appDTOList) {
        if (appDTOList == null) {
            return null;
        }
        ArrayList<BwApp> list = new ArrayList<BwApp>(appDTOList.size());
        for (AppDTO appDTO : appDTOList) {
            list.add(this.toBwApp(appDTO));
        }
        return list;
    }

    private String appDTOVersionNumber(AppDTO appDTO) {
        if (appDTO == null) {
            return null;
        }
        AppVersionOnlyDTO version = appDTO.getVersion();
        if (version == null) {
            return null;
        }
        String number = version.getNumber();
        if (number == null) {
            return null;
        }
        return number;
    }

    private String appDTOVersionStatus(AppDTO appDTO) {
        if (appDTO == null) {
            return null;
        }
        AppVersionOnlyDTO version = appDTO.getVersion();
        if (version == null) {
            return null;
        }
        String status = version.getStatus();
        if (status == null) {
            return null;
        }
        return status;
    }
}

