/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.app.converter;

import com.alibaba.bizworks.ide.domain.app.BwAppVersion;
import com.alibaba.bizworks.sync.infra.app.converter.BwAppVersionConverter;
import com.alibaba.bizworks.sync.infra.app.dto.AppVersionOnlyDTO;
import com.alibaba.bizworks.sync.infra.app.dto.AppVersionWrapperDTO;
import com.alibaba.bizworks.sync.infra.meta.converter.ModuleVersionStatusConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.mapstruct.factory.Mappers;

public class BwAppVersionConverterImpl
implements BwAppVersionConverter {
    private final ModuleVersionStatusConverter moduleVersionStatusConverter = (ModuleVersionStatusConverter)Mappers.getMapper(ModuleVersionStatusConverter.class);

    @Override
    public BwAppVersion toBwAppVersion(AppVersionWrapperDTO source) {
        if (source == null) {
            return null;
        }
        BwAppVersion bwAppVersion = new BwAppVersion();
        bwAppVersion.setVersion(this.sourceVersionNumber(source));
        bwAppVersion.setVersionStatus(this.moduleVersionStatusConverter.toEnum(this.sourceVersionStatus(source)));
        bwAppVersion.setProjectCode(source.getProjectCode());
        bwAppVersion.setName(source.getName());
        bwAppVersion.setSourceVersion(source.getSourceVersion());
        bwAppVersion.setGmtCreate(source.getGmtCreate());
        return bwAppVersion;
    }

    @Override
    public BwAppVersion toBwAppVersion(AppVersionWrapperDTO source, String applicationCode) {
        if (source == null && applicationCode == null) {
            return null;
        }
        BwAppVersion bwAppVersion = new BwAppVersion();
        if (source != null) {
            bwAppVersion.setVersion(this.sourceVersionNumber(source));
            bwAppVersion.setVersionStatus(this.moduleVersionStatusConverter.toEnum(this.sourceVersionStatus(source)));
            bwAppVersion.setProjectCode(source.getProjectCode());
            bwAppVersion.setName(source.getName());
            bwAppVersion.setSourceVersion(source.getSourceVersion());
            bwAppVersion.setGmtCreate(source.getGmtCreate());
        }
        bwAppVersion.setAppCode(applicationCode);
        return bwAppVersion;
    }

    @Override
    public List<BwAppVersion> toBwAppVersionList(Collection<AppVersionWrapperDTO> source) {
        if (source == null) {
            return null;
        }
        ArrayList<BwAppVersion> list = new ArrayList<BwAppVersion>(source.size());
        for (AppVersionWrapperDTO appVersionWrapperDTO : source) {
            list.add(this.toBwAppVersion(appVersionWrapperDTO));
        }
        return list;
    }

    private String sourceVersionNumber(AppVersionWrapperDTO appVersionWrapperDTO) {
        if (appVersionWrapperDTO == null) {
            return null;
        }
        AppVersionOnlyDTO version = appVersionWrapperDTO.getVersion();
        if (version == null) {
            return null;
        }
        String number = version.getNumber();
        if (number == null) {
            return null;
        }
        return number;
    }

    private String sourceVersionStatus(AppVersionWrapperDTO appVersionWrapperDTO) {
        if (appVersionWrapperDTO == null) {
            return null;
        }
        AppVersionOnlyDTO version = appVersionWrapperDTO.getVersion();
        if (version == null) {
            return null;
        }
        String status = version.getStatus();
        if (status == null) {
            return null;
        }
        return status;
    }
}

