/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.app.gateway;

import com.alibaba.bizworks.ads.meta.lang.module.MdModule;
import com.alibaba.bizworks.ide.common.exception.BizReqException;
import com.alibaba.bizworks.ide.common.meta.MdKind;
import com.alibaba.bizworks.ide.common.utils.RegistryUtil;
import com.alibaba.bizworks.ide.domain.app.BwApp;
import com.alibaba.bizworks.ide.domain.app.BwAppGateway;
import com.alibaba.bizworks.ide.domain.app.BwAppInfo;
import com.alibaba.bizworks.ide.domain.app.BwAppVersion;
import com.alibaba.bizworks.sync.infra.app.client.FrontAppRpcClient;
import com.alibaba.bizworks.sync.infra.app.converter.BwAppConverter;
import com.alibaba.bizworks.sync.infra.app.converter.BwAppInfoConverter;
import com.alibaba.bizworks.sync.infra.app.converter.BwAppVersionConverter;
import com.alibaba.bizworks.sync.infra.app.dto.AppDTO;
import com.alibaba.bizworks.sync.infra.app.dto.AppInfoDTO;
import com.alibaba.bizworks.sync.infra.app.dto.AppInfoReq;
import com.alibaba.bizworks.sync.infra.app.dto.AppListDomainOrPbcReq;
import com.alibaba.bizworks.sync.infra.app.dto.ListAppVersionsReq;
import com.alibaba.bizworks.sync.infra.app.dto.ListApplicationsReq;
import com.alibaba.bizworks.sync.infra.http.ClientManager;
import com.alibaba.bizworks.sync.infra.http.ClientUtilsKt;
import com.alibaba.bizworks.sync.infra.meta.client.FrontMetaRpcClient;
import com.alibaba.bizworks.sync.infra.meta.dto.apimeta.ModuleVersionDTO;
import com.alibaba.bizworks.sync.infra.meta.dto.apimeta.SelectVersionsParam;
import com.alibaba.bizworks.sync.infra.meta.dto.apimeta.VersionQueryOption;
import com.alibaba.bizworks.sync.infra.module.converter.ApiModuleVersionConverter;
import com.alibaba.bizworks.sync.infra.module.converter.ApiModuleVersionDetailDTOConverter;
import com.alibaba.bizworks.sync.infra.module.converter.MdModuleConverter;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J.\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J&\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J&\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u0010 \u001a\u00020\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\"H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/alibaba/bizworks/sync/infra/app/gateway/BwAppGatewayImpl;", "Lcom/alibaba/bizworks/ide/domain/app/BwAppGateway;", "clientManager", "Lcom/alibaba/bizworks/sync/infra/http/ClientManager;", "(Lcom/alibaba/bizworks/sync/infra/http/ClientManager;)V", "frontAppRpcClient", "Lcom/alibaba/bizworks/sync/infra/app/client/FrontAppRpcClient;", "frontMetaRpcClient", "Lcom/alibaba/bizworks/sync/infra/meta/client/FrontMetaRpcClient;", "getAppInfo", "Lcom/alibaba/bizworks/ide/domain/app/BwAppInfo;", "projectCode", "", "applicationCode", "version", "getReversionId", "", "Lcom/alibaba/bizworks/ads/meta/lang/module/MdModule;", "modules", "listApplicationVersions", "Lcom/alibaba/bizworks/ide/domain/app/BwAppVersion;", "pageNum", "", "pageSize", "listApplications", "Lcom/alibaba/bizworks/ide/domain/app/BwApp;", "listBusinessCapability", "listDomain", "mockAppIfNeed", "", "appDto", "Lcom/alibaba/bizworks/sync/infra/app/dto/AppDTO;", "mockAppListIfNeed", "appList", "", "toolkit-infra"})
@SourceDebugExtension(value={"SMAP\nBwAppGatewayImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BwAppGatewayImpl.kt\ncom/alibaba/bizworks/sync/infra/app/gateway/BwAppGatewayImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1855#2,2:103\n*S KotlinDebug\n*F\n+ 1 BwAppGatewayImpl.kt\ncom/alibaba/bizworks/sync/infra/app/gateway/BwAppGatewayImpl\n*L\n48#1:103,2\n*E\n"})
public class BwAppGatewayImpl
implements BwAppGateway {
    @NotNull
    private final FrontAppRpcClient frontAppRpcClient;
    @NotNull
    private final FrontMetaRpcClient frontMetaRpcClient;

    public BwAppGatewayImpl(@NotNull ClientManager clientManager) {
        Intrinsics.checkNotNullParameter((Object)clientManager, (String)"clientManager");
        this.frontAppRpcClient = clientManager.getClient(FrontAppRpcClient.class);
        this.frontMetaRpcClient = clientManager.getClient(FrontMetaRpcClient.class);
    }

    @NotNull
    public List<BwApp> listApplications(@NotNull String projectCode, int pageNum, int pageSize) {
        Intrinsics.checkNotNullParameter((Object)projectCode, (String)"projectCode");
        Object[] objectArray = new String[]{"gmtModified"};
        List order = CollectionsKt.mutableListOf((Object[])objectArray);
        ListApplicationsReq req = new ListApplicationsReq(projectCode, order, "DESC", pageNum, pageSize);
        Collection listApplications = ClientUtilsKt.get(this.frontAppRpcClient.listApplications(req)).getData().getItems();
        Intrinsics.checkNotNull((Object)listApplications);
        this.mockAppListIfNeed(listApplications);
        List<BwApp> list = BwAppConverter.INSTANCE.toBwAppList(listApplications);
        Intrinsics.checkNotNullExpressionValue(list, (String)"toBwAppList(...)");
        return list;
    }

    private final void mockAppListIfNeed(Collection<AppDTO> appList) {
        Iterable $this$forEach$iv = appList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AppDTO it = (AppDTO)element$iv;
            boolean bl = false;
            this.mockAppIfNeed(it);
        }
    }

    private final void mockAppIfNeed(AppDTO appDto) {
        String mockAppType = RegistryUtil.Companion.stringValue("bizworks.mock.app.type");
        if (StringUtils.isBlank((CharSequence)mockAppType) || Intrinsics.areEqual((Object)"NONE", (Object)mockAppType)) {
            return;
        }
        appDto.setType(mockAppType);
    }

    @NotNull
    public List<BwAppVersion> listApplicationVersions(@NotNull String projectCode, @NotNull String applicationCode, int pageNum, int pageSize) {
        Intrinsics.checkNotNullParameter((Object)projectCode, (String)"projectCode");
        Intrinsics.checkNotNullParameter((Object)applicationCode, (String)"applicationCode");
        Object[] objectArray = new String[]{"gmtModified"};
        List order = CollectionsKt.mutableListOf((Object[])objectArray);
        ListAppVersionsReq req = new ListAppVersionsReq(projectCode, applicationCode, order, "DESC", pageNum, pageSize);
        Collection listApplicationVersion = ClientUtilsKt.get(this.frontAppRpcClient.listApplicationVersions(req)).getData().getItems();
        List<BwAppVersion> list = BwAppVersionConverter.INSTANCE.toBwAppVersionList(listApplicationVersion, applicationCode);
        Intrinsics.checkNotNullExpressionValue(list, (String)"toBwAppVersionList(...)");
        return list;
    }

    @NotNull
    public List<MdModule> listDomain(@NotNull String projectCode, @NotNull String applicationCode, @NotNull String version) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)projectCode, (String)"projectCode");
        Intrinsics.checkNotNullParameter((Object)applicationCode, (String)"applicationCode");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        try {
            AppListDomainOrPbcReq appListDomainOrPbcReq = new AppListDomainOrPbcReq(projectCode, applicationCode, version);
            collection = ClientUtilsKt.get(this.frontAppRpcClient.listDomain(appListDomainOrPbcReq)).getData().getItems();
        }
        catch (Exception e) {
            if (e instanceof BizReqException && Intrinsics.areEqual((Object)((BizReqException)((Object)e)).getCode(), (Object)"BWE_04010005")) {
                return CollectionsKt.emptyList();
            }
            throw e;
        }
        Collection listDomain = collection;
        List<MdModule> list = MdModuleConverter.INSTANCE.toMdList(listDomain, MdKind.DOMAIN);
        Intrinsics.checkNotNullExpressionValue(list, (String)"toMdList(...)");
        return list;
    }

    @NotNull
    public List<MdModule> listBusinessCapability(@NotNull String projectCode, @NotNull String applicationCode, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)projectCode, (String)"projectCode");
        Intrinsics.checkNotNullParameter((Object)applicationCode, (String)"applicationCode");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        AppListDomainOrPbcReq appListDomainOrPbcReq = new AppListDomainOrPbcReq(projectCode, applicationCode, version);
        Collection capList = ClientUtilsKt.get(this.frontAppRpcClient.listBusinessCapability(appListDomainOrPbcReq)).getData().getItems();
        List<MdModule> list = MdModuleConverter.INSTANCE.toMdList(capList, MdKind.BUSINESS_CAPABILITY);
        Intrinsics.checkNotNullExpressionValue(list, (String)"toMdList(...)");
        return list;
    }

    @NotNull
    public List<MdModule> getReversionId(@NotNull String projectCode, @NotNull List<? extends MdModule> modules) {
        Intrinsics.checkNotNullParameter((Object)projectCode, (String)"projectCode");
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        SelectVersionsParam selectVersionsParam = new SelectVersionsParam();
        selectVersionsParam.setProjectCode(projectCode);
        List<ModuleVersionDTO> toDtoList = ApiModuleVersionConverter.INSTANCE.toDtoList(modules);
        selectVersionsParam.setVersionList(toDtoList);
        VersionQueryOption versionQueryOption = new VersionQueryOption();
        selectVersionsParam.setOption(versionQueryOption);
        Collection selectVersions = ClientUtilsKt.get(this.frontMetaRpcClient.selectVersions(selectVersionsParam)).getData().getItems();
        Intrinsics.checkNotNull((Object)selectVersions);
        List<MdModule> list = ApiModuleVersionDetailDTOConverter.INSTANCE.toMdList(CollectionsKt.toList((Iterable)selectVersions));
        Intrinsics.checkNotNullExpressionValue(list, (String)"toMdList(...)");
        return list;
    }

    @Nullable
    public BwAppInfo getAppInfo(@NotNull String projectCode, @NotNull String applicationCode, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)projectCode, (String)"projectCode");
        Intrinsics.checkNotNullParameter((Object)applicationCode, (String)"applicationCode");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        AppInfoDTO data = (AppInfoDTO)ClientUtilsKt.get(this.frontAppRpcClient.getApplication(new AppInfoReq(projectCode, applicationCode, version))).getData();
        return BwAppInfoConverter.INSTANCE.toBwAppInfo(data);
    }
}

