/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.deployment.converter;

import com.alibaba.bizworks.ide.domain.sync.framework.deployment.converter.EnvironmentTypeConverter;
import com.alibaba.bizworks.ide.domain.sync.framework.deployment.model.BwDeploymentDetail;
import com.alibaba.bizworks.ide.domain.sync.framework.deployment.model.BwEnvironment;
import com.alibaba.bizworks.ide.domain.sync.framework.deployment.model.BwInstanceAccessInfo;
import com.alibaba.bizworks.ide.domain.sync.framework.deployment.model.BwRoutes;
import com.alibaba.bizworks.sync.infra.deployment.converter.BwDeploymentConverter;
import com.alibaba.bizworks.sync.infra.deployment.converter.DeploymentStatusConverter;
import com.alibaba.bizworks.sync.infra.deployment.dto.DeploymentDetailDTO;
import com.alibaba.bizworks.sync.infra.deployment.dto.EnvironmentDTO;
import com.alibaba.bizworks.sync.infra.deployment.dto.InstanceAccessInfoDTO;
import com.alibaba.bizworks.sync.infra.deployment.dto.RoutesDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.mapstruct.factory.Mappers;

public class BwDeploymentConverterImpl
implements BwDeploymentConverter {
    private final DeploymentStatusConverter deploymentStatusConverter = (DeploymentStatusConverter)Mappers.getMapper(DeploymentStatusConverter.class);
    private final EnvironmentTypeConverter environmentTypeConverter = (EnvironmentTypeConverter)Mappers.getMapper(EnvironmentTypeConverter.class);

    @Override
    public BwDeploymentDetail toBw(DeploymentDetailDTO dto) {
        if (dto == null) {
            return null;
        }
        BwDeploymentDetail bwDeploymentDetail = new BwDeploymentDetail();
        bwDeploymentDetail.setProjectCode(dto.getProjectCode());
        bwDeploymentDetail.setApplicationCode(dto.getApplicationCode());
        bwDeploymentDetail.setEnvironmentCode(dto.getEnvironmentCode());
        bwDeploymentDetail.setDeploymentCode(dto.getDeploymentCode());
        bwDeploymentDetail.setBranch(dto.getBranch());
        bwDeploymentDetail.setCommitId(dto.getCommitId());
        bwDeploymentDetail.setAppVersion(dto.getAppVersion());
        bwDeploymentDetail.setStatus(this.deploymentStatusConverter.toEnum(dto.getStatus()));
        bwDeploymentDetail.setType(dto.getType());
        bwDeploymentDetail.setInstanceAccessInfo(this.instanceAccessInfoDTOToBwInstanceAccessInfo(dto.getInstanceAccessInfo()));
        bwDeploymentDetail.setCodeBaseUrl(dto.getCodeBaseUrl());
        return bwDeploymentDetail;
    }

    @Override
    public List<BwDeploymentDetail> toBwList(Collection<DeploymentDetailDTO> dtoList) {
        if (dtoList == null) {
            return null;
        }
        ArrayList<BwDeploymentDetail> list = new ArrayList<BwDeploymentDetail>(dtoList.size());
        for (DeploymentDetailDTO deploymentDetailDTO : dtoList) {
            list.add(this.toBw(deploymentDetailDTO));
        }
        return list;
    }

    protected BwEnvironment environmentDTOToBwEnvironment(EnvironmentDTO environmentDTO) {
        if (environmentDTO == null) {
            return null;
        }
        BwEnvironment bwEnvironment = new BwEnvironment();
        bwEnvironment.setProjectCode(environmentDTO.getProjectCode());
        bwEnvironment.setEnvironmentCode(environmentDTO.getEnvironmentCode());
        bwEnvironment.setType(this.environmentTypeConverter.toEnum(environmentDTO.getType()));
        bwEnvironment.setHost(environmentDTO.getHost());
        bwEnvironment.setExtId(environmentDTO.getExtId());
        bwEnvironment.setClusterType(environmentDTO.getClusterType());
        bwEnvironment.setClusterName(environmentDTO.getClusterName());
        bwEnvironment.setNamespace(environmentDTO.getNamespace());
        bwEnvironment.setSlsProject(environmentDTO.getSlsProject());
        bwEnvironment.setSlsLogStore(environmentDTO.getSlsLogStore());
        bwEnvironment.setInstancesCount(environmentDTO.getInstancesCount());
        bwEnvironment.setDomainCode(environmentDTO.getDomainCode());
        bwEnvironment.setNamespaceSource(environmentDTO.getNamespaceSource());
        bwEnvironment.setName(environmentDTO.getName());
        bwEnvironment.setDescription(environmentDTO.getDescription());
        bwEnvironment.setGmtCreate(environmentDTO.getGmtCreate());
        bwEnvironment.setGmtModified(environmentDTO.getGmtModified());
        bwEnvironment.setCreator(environmentDTO.getCreator());
        bwEnvironment.setModifier(environmentDTO.getModifier());
        bwEnvironment.setDemo(environmentDTO.isDemo());
        return bwEnvironment;
    }

    protected BwRoutes routesDTOToBwRoutes(RoutesDTO routesDTO) {
        if (routesDTO == null) {
            return null;
        }
        BwRoutes bwRoutes = new BwRoutes();
        bwRoutes.setPort(routesDTO.getPort());
        bwRoutes.setServiceName(routesDTO.getServiceName());
        bwRoutes.setServicePort(routesDTO.getServicePort());
        bwRoutes.setAddress(routesDTO.getAddress());
        bwRoutes.setDomain(routesDTO.getDomain());
        bwRoutes.setApiGatewaySld(routesDTO.getApiGatewaySld());
        bwRoutes.setProtocol(routesDTO.getProtocol());
        return bwRoutes;
    }

    protected List<BwRoutes> routesDTOListToBwRoutesList(List<RoutesDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<BwRoutes> list1 = new ArrayList<BwRoutes>(list.size());
        for (RoutesDTO routesDTO : list) {
            list1.add(this.routesDTOToBwRoutes(routesDTO));
        }
        return list1;
    }

    protected BwInstanceAccessInfo instanceAccessInfoDTOToBwInstanceAccessInfo(InstanceAccessInfoDTO instanceAccessInfoDTO) {
        if (instanceAccessInfoDTO == null) {
            return null;
        }
        BwInstanceAccessInfo bwInstanceAccessInfo = new BwInstanceAccessInfo();
        bwInstanceAccessInfo.setEnvironment(this.environmentDTOToBwEnvironment(instanceAccessInfoDTO.getEnvironment()));
        bwInstanceAccessInfo.setRoutes(this.routesDTOListToBwRoutesList(instanceAccessInfoDTO.getRoutes()));
        return bwInstanceAccessInfo;
    }
}

