/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.meta.converter;

import com.alibaba.bizworks.ads.meta.lang.element.MdBusinessOperation;
import com.alibaba.bizworks.ads.meta.lang.file.MdBusinessCapability;
import com.alibaba.bizworks.sync.infra.meta.converter.BusinessDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.BusinessOperationDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.MetadataExtInfoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.ModuleDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.OriginTypeConverter;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.BusinessCapabilityDTO;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.BusinessOperationDTO;
import java.util.ArrayList;
import java.util.List;

public class BusinessDtoConverterImpl
implements BusinessDtoConverter {
    private final ModuleDtoConverter moduleDtoConverter = ModuleDtoConverter.INSTANCE;
    private final BusinessOperationDtoConverter businessOperationDtoConverter = BusinessOperationDtoConverter.INSTANCE;
    private final OriginTypeConverter originTypeConverter = OriginTypeConverter.INSTANCE;
    private final MetadataExtInfoConverter metadataExtInfoConverter = MetadataExtInfoConverter.INSTANCE;

    @Override
    public BusinessCapabilityDTO toDto(MdBusinessCapability md) {
        if (md == null) {
            return null;
        }
        BusinessCapabilityDTO businessCapabilityDTO = new BusinessCapabilityDTO();
        businessCapabilityDTO.setLabel(md.getPresentableText());
        businessCapabilityDTO.setRealName(md.getCodeName());
        businessCapabilityDTO.setName(md.getName());
        businessCapabilityDTO.setDisplayName(md.getDisplayName());
        businessCapabilityDTO.setExt(this.metadataExtInfoConverter.toStr(md.getExt()));
        businessCapabilityDTO.setOrigin(this.originTypeConverter.toStr(md.getOrigin()));
        if (md.getPlatformReadOnly() != null) {
            businessCapabilityDTO.setPlatformReadOnly(String.valueOf(md.getPlatformReadOnly()));
        }
        businessCapabilityDTO.setDescription(md.getDescription());
        businessCapabilityDTO.setNamespace(md.getNamespace());
        businessCapabilityDTO.setUuid(md.getUuid());
        businessCapabilityDTO.setCommitId(md.getCommitId());
        businessCapabilityDTO.setOperations(this.mdBusinessOperationListToBusinessOperationDTOList(md.getOperations()));
        businessCapabilityDTO.setModule(this.moduleDtoConverter.toDto(md.getModule()));
        businessCapabilityDTO.setKind(md.getKind());
        return businessCapabilityDTO;
    }

    @Override
    public MdBusinessCapability toMd(BusinessCapabilityDTO dto) {
        if (dto == null) {
            return null;
        }
        MdBusinessCapability mdBusinessCapability = new MdBusinessCapability();
        mdBusinessCapability.setPresentableText(dto.getLabel());
        mdBusinessCapability.setCodeName(dto.getRealName());
        mdBusinessCapability.setName(dto.getName());
        mdBusinessCapability.setDisplayName(dto.getDisplayName());
        mdBusinessCapability.setDescription(dto.getDescription());
        mdBusinessCapability.setNamespace(dto.getNamespace());
        mdBusinessCapability.setUuid(dto.getUuid());
        mdBusinessCapability.setCommitId(dto.getCommitId());
        mdBusinessCapability.setModule(this.moduleDtoConverter.toMd(dto.getModule()));
        mdBusinessCapability.setOrigin(this.originTypeConverter.toEnum(dto.getOrigin()));
        if (dto.getPlatformReadOnly() != null) {
            mdBusinessCapability.setPlatformReadOnly(Boolean.valueOf(Boolean.parseBoolean(dto.getPlatformReadOnly())));
        }
        mdBusinessCapability.setExt(this.metadataExtInfoConverter.toMd(dto.getExt()));
        mdBusinessCapability.setOperations(this.businessOperationDTOListToMdBusinessOperationList(dto.getOperations()));
        return mdBusinessCapability;
    }

    protected List<BusinessOperationDTO> mdBusinessOperationListToBusinessOperationDTOList(List<MdBusinessOperation> list) {
        if (list == null) {
            return null;
        }
        ArrayList<BusinessOperationDTO> list1 = new ArrayList<BusinessOperationDTO>(list.size());
        for (MdBusinessOperation mdBusinessOperation : list) {
            list1.add(this.businessOperationDtoConverter.toDto(mdBusinessOperation));
        }
        return list1;
    }

    protected List<MdBusinessOperation> businessOperationDTOListToMdBusinessOperationList(List<BusinessOperationDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MdBusinessOperation> list1 = new ArrayList<MdBusinessOperation>(list.size());
        for (BusinessOperationDTO businessOperationDTO : list) {
            list1.add(this.businessOperationDtoConverter.toMd(businessOperationDTO));
        }
        return list1;
    }
}

