/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.meta.converter;

import com.alibaba.bizworks.ads.meta.lang.element.MdApiOperation;
import com.alibaba.bizworks.ads.meta.lang.element.MdBusinessOperation;
import com.alibaba.bizworks.ads.meta.lang.element.MdDependencies;
import com.alibaba.bizworks.ads.meta.lang.element.MdInput;
import com.alibaba.bizworks.ads.meta.lang.element.MdServiceRef;
import com.alibaba.bizworks.sync.infra.meta.converter.BusinessOperationDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.DependenciesDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.InputDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.MetadataExtInfoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.OutputDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.ApiOperationDTO;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.BusinessOperationDTO;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.InputDTO;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.ServiceOperationsDTO;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.ServiceRefDTO;
import java.util.ArrayList;
import java.util.List;

public class BusinessOperationDtoConverterImpl
implements BusinessOperationDtoConverter {
    private final InputDtoConverter inputDtoConverter = InputDtoConverter.INSTANCE;
    private final OutputDtoConverter outputDtoConverter = OutputDtoConverter.INSTANCE;
    private final DependenciesDtoConverter dependenciesDtoConverter = DependenciesDtoConverter.INSTANCE;
    private final MetadataExtInfoConverter metadataExtInfoConverter = MetadataExtInfoConverter.INSTANCE;

    @Override
    public BusinessOperationDTO toDto(MdBusinessOperation md) {
        if (md == null) {
            return null;
        }
        BusinessOperationDTO businessOperationDTO = new BusinessOperationDTO();
        businessOperationDTO.setApiOperation(this.mdApiOperationToApiOperationDTO(md.getApiOperation()));
        businessOperationDTO.setRealName(md.getCodeName());
        businessOperationDTO.setName(md.getName());
        businessOperationDTO.setDisplayName(md.getDisplayName());
        businessOperationDTO.setExt(this.metadataExtInfoConverter.toStr(md.getExt()));
        businessOperationDTO.setDescription(md.getDescription());
        businessOperationDTO.setUuid(md.getUuid());
        businessOperationDTO.setDependencies(this.dependenciesDtoConverter.toDto(md.getDependencies()));
        businessOperationDTO.setOperationType(md.getOperationType());
        businessOperationDTO.setServiceOperation(this.mdDependenciesToServiceOperationsDTO(md.getServiceOperation()));
        businessOperationDTO.setKind(md.getKind());
        return businessOperationDTO;
    }

    @Override
    public MdBusinessOperation toMd(BusinessOperationDTO dto) {
        if (dto == null) {
            return null;
        }
        MdBusinessOperation mdBusinessOperation = new MdBusinessOperation();
        mdBusinessOperation.setApiOperation(this.apiOperationDTOToMdApiOperation(dto.getApiOperation()));
        mdBusinessOperation.setCodeName(dto.getRealName());
        mdBusinessOperation.setName(dto.getName());
        mdBusinessOperation.setDisplayName(dto.getDisplayName());
        mdBusinessOperation.setDescription(dto.getDescription());
        mdBusinessOperation.setUuid(dto.getUuid());
        mdBusinessOperation.setExt(this.metadataExtInfoConverter.toMd(dto.getExt()));
        mdBusinessOperation.setDependencies(this.dependenciesDtoConverter.toMd(dto.getDependencies()));
        mdBusinessOperation.setOperationType(dto.getOperationType());
        mdBusinessOperation.setServiceOperation(this.serviceOperationsDTOToMdDependencies(dto.getServiceOperation()));
        return mdBusinessOperation;
    }

    protected List<InputDTO> mdInputListToInputDTOList(List<MdInput> list) {
        if (list == null) {
            return null;
        }
        ArrayList<InputDTO> list1 = new ArrayList<InputDTO>(list.size());
        for (MdInput mdInput : list) {
            list1.add(this.inputDtoConverter.toDto(mdInput));
        }
        return list1;
    }

    protected ApiOperationDTO mdApiOperationToApiOperationDTO(MdApiOperation mdApiOperation) {
        if (mdApiOperation == null) {
            return null;
        }
        ApiOperationDTO apiOperationDTO = new ApiOperationDTO();
        apiOperationDTO.setOutputs(this.outputDtoConverter.toDtoList(mdApiOperation.getOutput()));
        apiOperationDTO.setName(mdApiOperation.getName());
        apiOperationDTO.setDisplayName(mdApiOperation.getDisplayName());
        apiOperationDTO.setExt(this.metadataExtInfoConverter.toStr(mdApiOperation.getExt()));
        apiOperationDTO.setInputs(this.mdInputListToInputDTOList(mdApiOperation.getInputs()));
        return apiOperationDTO;
    }

    protected ServiceRefDTO mdServiceRefToServiceRefDTO(MdServiceRef mdServiceRef) {
        if (mdServiceRef == null) {
            return null;
        }
        ServiceRefDTO serviceRefDTO = new ServiceRefDTO();
        serviceRefDTO.setNamespace(mdServiceRef.getNamespace());
        serviceRefDTO.setName(mdServiceRef.getName());
        serviceRefDTO.setDisplayName(mdServiceRef.getDisplayName());
        return serviceRefDTO;
    }

    protected ServiceOperationsDTO mdDependenciesToServiceOperationsDTO(MdDependencies mdDependencies) {
        if (mdDependencies == null) {
            return null;
        }
        ServiceOperationsDTO serviceOperationsDTO = new ServiceOperationsDTO();
        serviceOperationsDTO.setServiceRef(this.mdServiceRefToServiceRefDTO(mdDependencies.getServiceRef()));
        serviceOperationsDTO.setBindingOperation(mdDependencies.getBindingOperation());
        serviceOperationsDTO.setDomainCode(mdDependencies.getDomainCode());
        return serviceOperationsDTO;
    }

    protected List<MdInput> inputDTOListToMdInputList(List<InputDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MdInput> list1 = new ArrayList<MdInput>(list.size());
        for (InputDTO inputDTO : list) {
            list1.add(this.inputDtoConverter.toMd(inputDTO));
        }
        return list1;
    }

    protected MdApiOperation apiOperationDTOToMdApiOperation(ApiOperationDTO apiOperationDTO) {
        if (apiOperationDTO == null) {
            return null;
        }
        MdApiOperation mdApiOperation = new MdApiOperation();
        mdApiOperation.setOutput(this.outputDtoConverter.toMd(apiOperationDTO.getOutputs()));
        mdApiOperation.setName(apiOperationDTO.getName());
        mdApiOperation.setDisplayName(apiOperationDTO.getDisplayName());
        mdApiOperation.setExt(this.metadataExtInfoConverter.toMd(apiOperationDTO.getExt()));
        mdApiOperation.setInputs(this.inputDTOListToMdInputList(apiOperationDTO.getInputs()));
        return mdApiOperation;
    }

    protected MdServiceRef serviceRefDTOToMdServiceRef(ServiceRefDTO serviceRefDTO) {
        if (serviceRefDTO == null) {
            return null;
        }
        MdServiceRef mdServiceRef = new MdServiceRef();
        mdServiceRef.setNamespace(serviceRefDTO.getNamespace());
        mdServiceRef.setName(serviceRefDTO.getName());
        mdServiceRef.setDisplayName(serviceRefDTO.getDisplayName());
        return mdServiceRef;
    }

    protected MdDependencies serviceOperationsDTOToMdDependencies(ServiceOperationsDTO serviceOperationsDTO) {
        if (serviceOperationsDTO == null) {
            return null;
        }
        MdDependencies mdDependencies = new MdDependencies();
        mdDependencies.setServiceRef(this.serviceRefDTOToMdServiceRef(serviceOperationsDTO.getServiceRef()));
        mdDependencies.setBindingOperation(serviceOperationsDTO.getBindingOperation());
        mdDependencies.setDomainCode(serviceOperationsDTO.getDomainCode());
        return mdDependencies;
    }
}

