/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.meta.converter;

import com.alibaba.bizworks.ads.meta.lang.element.MdMethod;
import com.alibaba.bizworks.ads.meta.lang.file.MdDomainService;
import com.alibaba.bizworks.sync.infra.meta.converter.DomainServiceDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.MetadataExtInfoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.MethodDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.ModuleDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.OriginTypeConverter;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.DomainServiceDTO;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.MethodDTO;
import java.util.ArrayList;
import java.util.List;

public class DomainServiceDtoConverterImpl
implements DomainServiceDtoConverter {
    private final MethodDtoConverter methodDtoConverter = MethodDtoConverter.INSTANCE;
    private final ModuleDtoConverter moduleDtoConverter = ModuleDtoConverter.INSTANCE;
    private final OriginTypeConverter originTypeConverter = OriginTypeConverter.INSTANCE;
    private final MetadataExtInfoConverter metadataExtInfoConverter = MetadataExtInfoConverter.INSTANCE;

    @Override
    public DomainServiceDTO toDto(MdDomainService md) {
        if (md == null) {
            return null;
        }
        DomainServiceDTO domainServiceDTO = new DomainServiceDTO();
        domainServiceDTO.setLabel(md.getPresentableText());
        domainServiceDTO.setRealName(md.getCodeName());
        domainServiceDTO.setName(md.getName());
        domainServiceDTO.setDisplayName(md.getDisplayName());
        domainServiceDTO.setExt(this.metadataExtInfoConverter.toStr(md.getExt()));
        domainServiceDTO.setOrigin(this.originTypeConverter.toStr(md.getOrigin()));
        if (md.getPlatformReadOnly() != null) {
            domainServiceDTO.setPlatformReadOnly(String.valueOf(md.getPlatformReadOnly()));
        }
        domainServiceDTO.setDescription(md.getDescription());
        domainServiceDTO.setNamespace(md.getNamespace());
        domainServiceDTO.setUuid(md.getUuid());
        domainServiceDTO.setMethods(this.mdMethodListToMethodDTOList(md.getMethods()));
        domainServiceDTO.setCommitId(md.getCommitId());
        domainServiceDTO.setModule(this.moduleDtoConverter.toDto(md.getModule()));
        domainServiceDTO.setKind(md.getKind());
        return domainServiceDTO;
    }

    @Override
    public MdDomainService toMd(DomainServiceDTO dto) {
        if (dto == null) {
            return null;
        }
        MdDomainService mdDomainService = new MdDomainService();
        mdDomainService.setPresentableText(dto.getLabel());
        mdDomainService.setCodeName(dto.getRealName());
        mdDomainService.setName(dto.getName());
        mdDomainService.setDisplayName(dto.getDisplayName());
        mdDomainService.setDescription(dto.getDescription());
        mdDomainService.setNamespace(dto.getNamespace());
        mdDomainService.setUuid(dto.getUuid());
        mdDomainService.setMethods(this.methodDTOListToMdMethodList(dto.getMethods()));
        mdDomainService.setCommitId(dto.getCommitId());
        mdDomainService.setModule(this.moduleDtoConverter.toMd(dto.getModule()));
        mdDomainService.setOrigin(this.originTypeConverter.toEnum(dto.getOrigin()));
        if (dto.getPlatformReadOnly() != null) {
            mdDomainService.setPlatformReadOnly(Boolean.valueOf(Boolean.parseBoolean(dto.getPlatformReadOnly())));
        }
        mdDomainService.setExt(this.metadataExtInfoConverter.toMd(dto.getExt()));
        return mdDomainService;
    }

    protected List<MethodDTO> mdMethodListToMethodDTOList(List<MdMethod> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MethodDTO> list1 = new ArrayList<MethodDTO>(list.size());
        for (MdMethod mdMethod : list) {
            list1.add(this.methodDtoConverter.toDto(mdMethod));
        }
        return list1;
    }

    protected List<MdMethod> methodDTOListToMdMethodList(List<MethodDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MdMethod> list1 = new ArrayList<MdMethod>(list.size());
        for (MethodDTO methodDTO : list) {
            list1.add(this.methodDtoConverter.toMd(methodDTO));
        }
        return list1;
    }
}

