/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.meta.converter;

import com.alibaba.bizworks.ads.meta.lang.element.MdInput;
import com.alibaba.bizworks.ads.meta.lang.element.MdMethod;
import com.alibaba.bizworks.sync.infra.meta.converter.InputDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.MetadataExtInfoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.MethodDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.OutputDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.InputDTO;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.MethodDTO;
import java.util.ArrayList;
import java.util.List;

public class MethodDtoConverterImpl
implements MethodDtoConverter {
    private final InputDtoConverter inputDtoConverter = InputDtoConverter.INSTANCE;
    private final OutputDtoConverter outputDtoConverter = OutputDtoConverter.INSTANCE;
    private final MetadataExtInfoConverter metadataExtInfoConverter = MetadataExtInfoConverter.INSTANCE;

    @Override
    public MethodDTO toDto(MdMethod md) {
        if (md == null) {
            return null;
        }
        MethodDTO methodDTO = new MethodDTO();
        methodDTO.setOutputs(this.outputDtoConverter.toDtoList(md.getOutput()));
        methodDTO.setRealName(md.getCodeName());
        methodDTO.setName(md.getName());
        methodDTO.setDisplayName(md.getDisplayName());
        methodDTO.setExt(this.metadataExtInfoConverter.toStr(md.getExt()));
        methodDTO.setDescription(md.getDescription());
        methodDTO.setInherited(md.getInherited());
        methodDTO.setInputs(this.mdInputListToInputDTOList(md.getInputs()));
        methodDTO.setUuid(md.getUuid());
        methodDTO.setKind(md.getKind());
        return methodDTO;
    }

    @Override
    public MdMethod toMd(MethodDTO dto) {
        if (dto == null) {
            return null;
        }
        MdMethod mdMethod = new MdMethod();
        mdMethod.setOutput(this.outputDtoConverter.toMd(dto.getOutputs()));
        mdMethod.setCodeName(dto.getRealName());
        mdMethod.setName(dto.getName());
        mdMethod.setDisplayName(dto.getDisplayName());
        mdMethod.setDescription(dto.getDescription());
        mdMethod.setUuid(dto.getUuid());
        mdMethod.setExt(this.metadataExtInfoConverter.toMd(dto.getExt()));
        mdMethod.setInherited(dto.getInherited());
        mdMethod.setInputs(this.inputDTOListToMdInputList(dto.getInputs()));
        return mdMethod;
    }

    protected List<InputDTO> mdInputListToInputDTOList(List<MdInput> list) {
        if (list == null) {
            return null;
        }
        ArrayList<InputDTO> list1 = new ArrayList<InputDTO>(list.size());
        for (MdInput mdInput : list) {
            list1.add(this.inputDtoConverter.toDto(mdInput));
        }
        return list1;
    }

    protected List<MdInput> inputDTOListToMdInputList(List<InputDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MdInput> list1 = new ArrayList<MdInput>(list.size());
        for (InputDTO inputDTO : list) {
            list1.add(this.inputDtoConverter.toMd(inputDTO));
        }
        return list1;
    }
}

