/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.meta.converter;

import com.alibaba.bizworks.ads.meta.lang.MdReference;
import com.alibaba.bizworks.ads.meta.lang.element.MdMapping;
import com.alibaba.bizworks.ads.meta.lang.file.MdModelMapping;
import com.alibaba.bizworks.ads.meta.lang.file.OriginType;
import com.alibaba.bizworks.sync.infra.meta.converter.FieldMappingDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.MetadataExtInfoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.ModelMappingDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.ModuleDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.FieldMappingDTO;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.ModelMappingDTO;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.ReferenceDTO;
import java.util.ArrayList;
import java.util.List;

public class ModelMappingDtoConverterImpl
implements ModelMappingDtoConverter {
    private final FieldMappingDtoConverter fieldMappingDtoConverter = FieldMappingDtoConverter.INSTANCE;
    private final ModuleDtoConverter moduleDtoConverter = ModuleDtoConverter.INSTANCE;
    private final MetadataExtInfoConverter metadataExtInfoConverter = MetadataExtInfoConverter.INSTANCE;

    @Override
    public ModelMappingDTO toDto(MdModelMapping mdMapping) {
        if (mdMapping == null) {
            return null;
        }
        ModelMappingDTO modelMappingDTO = new ModelMappingDTO();
        modelMappingDTO.setName(mdMapping.getName());
        modelMappingDTO.setDisplayName(mdMapping.getDisplayName());
        modelMappingDTO.setExt(this.metadataExtInfoConverter.toStr(mdMapping.getExt()));
        if (mdMapping.getOrigin() != null) {
            modelMappingDTO.setOrigin(mdMapping.getOrigin().name());
        }
        if (mdMapping.getPlatformReadOnly() != null) {
            modelMappingDTO.setPlatformReadOnly(String.valueOf(mdMapping.getPlatformReadOnly()));
        }
        modelMappingDTO.setDescription(mdMapping.getDescription());
        modelMappingDTO.setNamespace(mdMapping.getNamespace());
        modelMappingDTO.setUuid(mdMapping.getUuid());
        modelMappingDTO.setCommitId(mdMapping.getCommitId());
        modelMappingDTO.setModule(this.moduleDtoConverter.toDto(mdMapping.getModule()));
        modelMappingDTO.setSource(this.mdReferenceToReferenceDTO(mdMapping.getSource()));
        modelMappingDTO.setTarget(this.mdReferenceToReferenceDTO(mdMapping.getTarget()));
        modelMappingDTO.setSourceType(mdMapping.getSourceType());
        modelMappingDTO.setTargetType(mdMapping.getTargetType());
        modelMappingDTO.setFieldMappings(this.mdMappingListToFieldMappingDTOList(mdMapping.getFieldMappings()));
        modelMappingDTO.setReverseMappings(this.mdMappingListToFieldMappingDTOList(mdMapping.getReverseMappings()));
        modelMappingDTO.setKind(mdMapping.getKind());
        return modelMappingDTO;
    }

    @Override
    public MdModelMapping toMd(ModelMappingDTO mappingDTO) {
        if (mappingDTO == null) {
            return null;
        }
        MdModelMapping mdModelMapping = new MdModelMapping();
        mdModelMapping.setName(mappingDTO.getName());
        mdModelMapping.setDisplayName(mappingDTO.getDisplayName());
        mdModelMapping.setDescription(mappingDTO.getDescription());
        mdModelMapping.setNamespace(mappingDTO.getNamespace());
        mdModelMapping.setUuid(mappingDTO.getUuid());
        mdModelMapping.setCommitId(mappingDTO.getCommitId());
        mdModelMapping.setModule(this.moduleDtoConverter.toMd(mappingDTO.getModule()));
        if (mappingDTO.getOrigin() != null) {
            mdModelMapping.setOrigin(Enum.valueOf(OriginType.class, mappingDTO.getOrigin()));
        }
        if (mappingDTO.getPlatformReadOnly() != null) {
            mdModelMapping.setPlatformReadOnly(Boolean.valueOf(Boolean.parseBoolean(mappingDTO.getPlatformReadOnly())));
        }
        mdModelMapping.setExt(this.metadataExtInfoConverter.toMd(mappingDTO.getExt()));
        mdModelMapping.setSource(this.referenceDTOToMdReference(mappingDTO.getSource()));
        mdModelMapping.setTarget(this.referenceDTOToMdReference(mappingDTO.getTarget()));
        mdModelMapping.setSourceType(mappingDTO.getSourceType());
        mdModelMapping.setTargetType(mappingDTO.getTargetType());
        mdModelMapping.setFieldMappings(this.fieldMappingDTOListToMdMappingList(mappingDTO.getFieldMappings()));
        mdModelMapping.setReverseMappings(this.fieldMappingDTOListToMdMappingList(mappingDTO.getReverseMappings()));
        return mdModelMapping;
    }

    protected ReferenceDTO mdReferenceToReferenceDTO(MdReference mdReference) {
        if (mdReference == null) {
            return null;
        }
        ReferenceDTO referenceDTO = new ReferenceDTO();
        referenceDTO.setName(mdReference.getName());
        referenceDTO.setDisplayName(mdReference.getDisplayName());
        referenceDTO.setNamespace(mdReference.getNamespace());
        return referenceDTO;
    }

    protected List<FieldMappingDTO> mdMappingListToFieldMappingDTOList(List<MdMapping> list) {
        if (list == null) {
            return null;
        }
        ArrayList<FieldMappingDTO> list1 = new ArrayList<FieldMappingDTO>(list.size());
        for (MdMapping mdMapping : list) {
            list1.add(this.fieldMappingDtoConverter.toDto(mdMapping));
        }
        return list1;
    }

    protected MdReference referenceDTOToMdReference(ReferenceDTO referenceDTO) {
        if (referenceDTO == null) {
            return null;
        }
        MdReference mdReference = new MdReference();
        mdReference.setName(referenceDTO.getName());
        mdReference.setDisplayName(referenceDTO.getDisplayName());
        mdReference.setNamespace(referenceDTO.getNamespace());
        return mdReference;
    }

    protected List<MdMapping> fieldMappingDTOListToMdMappingList(List<FieldMappingDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MdMapping> list1 = new ArrayList<MdMapping>(list.size());
        for (FieldMappingDTO fieldMappingDTO : list) {
            list1.add(this.fieldMappingDtoConverter.toMd(fieldMappingDTO));
        }
        return list1;
    }
}

