/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.meta.converter;

import com.alibaba.bizworks.ads.meta.lang.MdReference;
import com.alibaba.bizworks.ads.meta.lang.Metadata;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.InnerRefDTO;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.ReferenceDTO;
import javax.xml.namespace.QName;
import kotlin.Pair;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

@Mapper
public interface ReferenceDtoConverter {
    public static final ReferenceDtoConverter INSTANCE = (ReferenceDtoConverter)Mappers.getMapper(ReferenceDtoConverter.class);

    @Mapping(target="ref", source="md")
    public ReferenceDTO toDto(MdReference var1);

    default public MdReference toMd(ReferenceDTO dto) {
        Pair qname;
        if (dto == null) {
            return null;
        }
        MdReference mdReference = new MdReference();
        InnerRefDTO ref = dto.getRef();
        if (ref != null && StringUtils.isNotBlank((CharSequence)ref.getValue()) && (qname = Metadata.fromQname((String)ref.getValue())) != null) {
            mdReference.setNamespace((String)qname.getFirst());
            mdReference.setName((String)qname.getSecond());
        }
        String namespace = dto.getNamespace();
        String name = dto.getName();
        if (StringUtils.isNotBlank((CharSequence)namespace) || mdReference.getNamespace() == null) {
            mdReference.setNamespace(namespace);
        }
        if (StringUtils.isNotBlank((CharSequence)name) || mdReference.getName() == null) {
            mdReference.setName(name);
        }
        mdReference.setDisplayName(dto.getDisplayName());
        return mdReference;
    }

    default public InnerRefDTO toInnerRefDTO(MdReference md) {
        if (md == null) {
            return null;
        }
        InnerRefDTO innerRefDTO = new InnerRefDTO();
        innerRefDTO.setName(md.getName());
        innerRefDTO.setValue(Metadata.toQname((String)md.getNamespace(), (String)md.getName()));
        return innerRefDTO;
    }

    default public QName toQName(MdReference md) {
        if (md == null) {
            return null;
        }
        return new QName(md.getNamespace(), md.getName());
    }

    default public MdReference toMd(QName qName) {
        if (qName == null) {
            return null;
        }
        MdReference mdReference = new MdReference();
        mdReference.setName(qName.getLocalPart());
        mdReference.setNamespace(qName.getNamespaceURI());
        return mdReference;
    }
}

