/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.meta.converter;

import com.alibaba.bizworks.ads.meta.lang.element.MdField;
import com.alibaba.bizworks.ads.meta.lang.element.MdRelationship;
import com.alibaba.bizworks.ads.meta.lang.file.MdStructureObject;
import com.alibaba.bizworks.sync.infra.meta.converter.CodeInformationConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.FieldDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.MetadataExtInfoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.ModuleDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.OriginTypeConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.RelationshipDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.StructureObjectDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.FieldDTO;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.RelationshipDTO;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.StructureObjectDTO;
import java.util.ArrayList;
import java.util.List;

public class StructureObjectDtoConverterImpl
implements StructureObjectDtoConverter {
    private final FieldDtoConverter fieldDtoConverter = FieldDtoConverter.INSTANCE;
    private final RelationshipDtoConverter relationshipDtoConverter = RelationshipDtoConverter.INSTANCE;
    private final ModuleDtoConverter moduleDtoConverter = ModuleDtoConverter.INSTANCE;
    private final OriginTypeConverter originTypeConverter = OriginTypeConverter.INSTANCE;
    private final CodeInformationConverter codeInformationConverter = CodeInformationConverter.INSTANCE;
    private final MetadataExtInfoConverter metadataExtInfoConverter = MetadataExtInfoConverter.INSTANCE;

    @Override
    public StructureObjectDTO toDto(MdStructureObject md) {
        if (md == null) {
            return null;
        }
        StructureObjectDTO structureObjectDTO = new StructureObjectDTO();
        structureObjectDTO.setLabel(md.getPresentableText());
        structureObjectDTO.setRealName(md.getCodeName());
        structureObjectDTO.setSource(this.originTypeConverter.toStr(md.getOrigin()));
        structureObjectDTO.setName(md.getName());
        structureObjectDTO.setDisplayName(md.getDisplayName());
        structureObjectDTO.setExt(this.metadataExtInfoConverter.toStr(md.getExt()));
        structureObjectDTO.setOrigin(this.originTypeConverter.toStr(md.getOrigin()));
        if (md.getPlatformReadOnly() != null) {
            structureObjectDTO.setPlatformReadOnly(String.valueOf(md.getPlatformReadOnly()));
        }
        structureObjectDTO.setDescription(md.getDescription());
        structureObjectDTO.setNamespace(md.getNamespace());
        structureObjectDTO.setUuid(md.getUuid());
        structureObjectDTO.setFields(this.mdFieldListToFieldDTOList(md.getFields()));
        structureObjectDTO.setCommitId(md.getCommitId());
        structureObjectDTO.setModule(this.moduleDtoConverter.toDto(md.getModule()));
        structureObjectDTO.setRelationships(this.mdRelationshipListToRelationshipDTOList(md.getRelationships()));
        structureObjectDTO.setKind(md.getKind());
        structureObjectDTO.setSimpleName(md.getSimpleName());
        structureObjectDTO.setGenericsText(md.getGenericsText());
        structureObjectDTO.setAdditionalInformation(md.getAdditionalInformation());
        structureObjectDTO.setPkg(md.getPkg());
        structureObjectDTO.setCodeInformation(this.codeInformationConverter.toStr(md.getCodeInformation()));
        return structureObjectDTO;
    }

    @Override
    public MdStructureObject toMd(StructureObjectDTO dto) {
        if (dto == null) {
            return null;
        }
        MdStructureObject mdStructureObject = new MdStructureObject();
        mdStructureObject.setPresentableText(dto.getLabel());
        mdStructureObject.setCodeName(dto.getRealName());
        mdStructureObject.setName(dto.getName());
        mdStructureObject.setDisplayName(dto.getDisplayName());
        mdStructureObject.setDescription(dto.getDescription());
        mdStructureObject.setNamespace(dto.getNamespace());
        mdStructureObject.setUuid(dto.getUuid());
        mdStructureObject.setFields(this.fieldDTOListToMdFieldList(dto.getFields()));
        mdStructureObject.setCommitId(dto.getCommitId());
        mdStructureObject.setModule(this.moduleDtoConverter.toMd(dto.getModule()));
        mdStructureObject.setOrigin(this.originTypeConverter.toEnum(dto.getOrigin()));
        if (dto.getPlatformReadOnly() != null) {
            mdStructureObject.setPlatformReadOnly(Boolean.valueOf(Boolean.parseBoolean(dto.getPlatformReadOnly())));
        }
        mdStructureObject.setExt(this.metadataExtInfoConverter.toMd(dto.getExt()));
        mdStructureObject.setCodeInformation(this.codeInformationConverter.toMd(dto.getCodeInformation()));
        mdStructureObject.setSimpleName(dto.getSimpleName());
        mdStructureObject.setGenericsText(dto.getGenericsText());
        mdStructureObject.setAdditionalInformation(dto.getAdditionalInformation());
        mdStructureObject.setPkg(dto.getPkg());
        mdStructureObject.setRelationships(this.relationshipDTOListToMdRelationshipList(dto.getRelationships()));
        mdStructureObject.setSource(this.originTypeConverter.toEnum(dto.getSource()));
        return mdStructureObject;
    }

    protected List<FieldDTO> mdFieldListToFieldDTOList(List<MdField> list) {
        if (list == null) {
            return null;
        }
        ArrayList<FieldDTO> list1 = new ArrayList<FieldDTO>(list.size());
        for (MdField mdField : list) {
            list1.add(this.fieldDtoConverter.toDto(mdField));
        }
        return list1;
    }

    protected List<RelationshipDTO> mdRelationshipListToRelationshipDTOList(List<MdRelationship> list) {
        if (list == null) {
            return null;
        }
        ArrayList<RelationshipDTO> list1 = new ArrayList<RelationshipDTO>(list.size());
        for (MdRelationship mdRelationship : list) {
            list1.add(this.relationshipDtoConverter.toDto(mdRelationship));
        }
        return list1;
    }

    protected List<MdField> fieldDTOListToMdFieldList(List<FieldDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MdField> list1 = new ArrayList<MdField>(list.size());
        for (FieldDTO fieldDTO : list) {
            list1.add(this.fieldDtoConverter.toMd(fieldDTO));
        }
        return list1;
    }

    protected List<MdRelationship> relationshipDTOListToMdRelationshipList(List<RelationshipDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MdRelationship> list1 = new ArrayList<MdRelationship>(list.size());
        for (RelationshipDTO relationshipDTO : list) {
            list1.add(this.relationshipDtoConverter.toMd(relationshipDTO));
        }
        return list1;
    }
}

