/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.meta.converter;

import com.alibaba.bizworks.ads.meta.lang.MdTypeInfo;
import com.alibaba.bizworks.sync.infra.meta.converter.CodeInformationConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.MdTypeStringConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.ReferenceDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.TypeInfoDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.TypeInfoDTO;
import java.util.ArrayList;
import java.util.List;
import org.mapstruct.factory.Mappers;

public class TypeInfoDtoConverterImpl
implements TypeInfoDtoConverter {
    private final ReferenceDtoConverter referenceDtoConverter = ReferenceDtoConverter.INSTANCE;
    private final MdTypeStringConverter mdTypeStringConverter = (MdTypeStringConverter)Mappers.getMapper(MdTypeStringConverter.class);
    private final CodeInformationConverter codeInformationConverter = CodeInformationConverter.INSTANCE;

    @Override
    public TypeInfoDTO toDto(MdTypeInfo md) {
        if (md == null) {
            return null;
        }
        TypeInfoDTO typeInfoDTO = new TypeInfoDTO();
        typeInfoDTO.setCustomObjectName(md.getPresentableText());
        typeInfoDTO.setLabel(md.getPresentableText());
        typeInfoDTO.setType(this.mdTypeStringConverter.toStr(md.getType()));
        typeInfoDTO.setObjectName(this.referenceDtoConverter.toDto(md.getObjectName()));
        typeInfoDTO.setItemTypes(this.mdTypeInfoListToTypeInfoDTOList(md.getItemTypes()));
        typeInfoDTO.setCollectable(md.getCollectable());
        typeInfoDTO.setPrimitive(md.getPrimitive());
        typeInfoDTO.setCodeInformation(this.codeInformationConverter.toStr(md.getCodeInformation()));
        return typeInfoDTO;
    }

    @Override
    public MdTypeInfo toMd(TypeInfoDTO dto) {
        if (dto == null) {
            return null;
        }
        MdTypeInfo mdTypeInfo = new MdTypeInfo();
        mdTypeInfo.setType(this.mdTypeStringConverter.toMd(dto.getType()));
        mdTypeInfo.setObjectName(this.referenceDtoConverter.toMd(dto.getObjectName()));
        mdTypeInfo.setItemTypes(this.typeInfoDTOListToMdTypeInfoList(dto.getItemTypes()));
        mdTypeInfo.setCollectable(dto.getCollectable());
        mdTypeInfo.setPrimitive(dto.getPrimitive());
        mdTypeInfo.setCodeInformation(this.codeInformationConverter.toMd(dto.getCodeInformation()));
        mdTypeInfo.setPresentableText(dto.getLabel() != null ? dto.getLabel() : dto.getCustomObjectName());
        return mdTypeInfo;
    }

    protected List<TypeInfoDTO> mdTypeInfoListToTypeInfoDTOList(List<MdTypeInfo> list) {
        if (list == null) {
            return null;
        }
        ArrayList<TypeInfoDTO> list1 = new ArrayList<TypeInfoDTO>(list.size());
        for (MdTypeInfo mdTypeInfo : list) {
            list1.add(this.toDto(mdTypeInfo));
        }
        return list1;
    }

    protected List<MdTypeInfo> typeInfoDTOListToMdTypeInfoList(List<TypeInfoDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MdTypeInfo> list1 = new ArrayList<MdTypeInfo>(list.size());
        for (TypeInfoDTO typeInfoDTO : list) {
            list1.add(this.toMd(typeInfoDTO));
        }
        return list1;
    }
}

