/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.module.converter;

import com.alibaba.bizworks.ads.meta.lang.module.MdModule;
import com.alibaba.bizworks.ide.common.meta.MdKind;
import com.alibaba.bizworks.sync.infra.meta.dto.apimeta.ModuleVersionDTO;
import com.alibaba.bizworks.sync.infra.module.converter.ApiModuleVersionConverter;
import java.util.ArrayList;
import java.util.List;

public class ApiModuleVersionConverterImpl
implements ApiModuleVersionConverter {
    @Override
    public ModuleVersionDTO toDto(MdModule mdModule) {
        if (mdModule == null) {
            return null;
        }
        ModuleVersionDTO moduleVersionDTO = new ModuleVersionDTO();
        moduleVersionDTO.setModuleCode(mdModule.getName());
        moduleVersionDTO.setModuleVersion(mdModule.getVersion());
        moduleVersionDTO.setModuleType(mdModule.getKind().getCode());
        return moduleVersionDTO;
    }

    @Override
    public MdModule toMd(ModuleVersionDTO dto) {
        if (dto == null) {
            return null;
        }
        MdModule mdModule = new MdModule();
        mdModule.setName(dto.getModuleCode());
        mdModule.setVersion(dto.getModuleVersion());
        mdModule.setKind(MdKind.fromCode((String)dto.getModuleType()));
        return mdModule;
    }

    @Override
    public List<ModuleVersionDTO> toDtoList(List<MdModule> modules) {
        if (modules == null) {
            return null;
        }
        ArrayList<ModuleVersionDTO> list = new ArrayList<ModuleVersionDTO>(modules.size());
        for (MdModule mdModule : modules) {
            list.add(this.toDto(mdModule));
        }
        return list;
    }

    @Override
    public List<MdModule> toMdList(List<ModuleVersionDTO> modules) {
        if (modules == null) {
            return null;
        }
        ArrayList<MdModule> list = new ArrayList<MdModule>(modules.size());
        for (ModuleVersionDTO moduleVersionDTO : modules) {
            list.add(this.toMd(moduleVersionDTO));
        }
        return list;
    }
}

