/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.user.gateway;

import com.alibaba.bizworks.ide.domain.sync.framework.config.GlobalConfigManager;
import com.alibaba.bizworks.ide.domain.sync.framework.config.model.BizWorksApiConfig;
import com.alibaba.bizworks.ide.domain.sync.framework.config.model.BizWorksFullUserInfo;
import com.alibaba.bizworks.ide.domain.sync.framework.config.model.BizWorksUserInfo;
import com.alibaba.bizworks.ide.domain.user.gateway.UserGateway;
import com.alibaba.bizworks.infra.dto.SingleResponse;
import com.alibaba.bizworks.sync.infra.http.ClientManager;
import com.alibaba.bizworks.sync.infra.http.ClientUtilsKt;
import com.alibaba.bizworks.sync.infra.user.client.LoginRpcClient;
import com.alibaba.bizworks.sync.infra.user.dto.LoginDTO;
import org.apache.commons.lang3.StringUtils;

public class UserGatewayImpl
implements UserGateway {
    private final LoginRpcClient loginRpcClient;
    private final GlobalConfigManager configManager;

    public UserGatewayImpl(ClientManager clientManager, GlobalConfigManager configManager) {
        this.loginRpcClient = clientManager.getClient(LoginRpcClient.class);
        this.configManager = configManager;
    }

    public BizWorksUserInfo getCurrentUserInfo(String token) {
        BizWorksApiConfig bizWorksApiConfig = this.configManager.needValidApiConfig();
        if (StringUtils.isEmpty((CharSequence)token)) {
            token = bizWorksApiConfig.getToken();
        }
        SingleResponse<BizWorksUserInfo> response = ClientUtilsKt.get(this.loginRpcClient.getCurrentUserIdentity(token, new LoginDTO()));
        return (BizWorksUserInfo)response.getData();
    }

    public BizWorksUserInfo getCurrentUserInfo() {
        BizWorksApiConfig bizWorksApiConfig = this.configManager.needValidApiConfig();
        String token = bizWorksApiConfig.getToken();
        SingleResponse<BizWorksUserInfo> response = ClientUtilsKt.get(this.loginRpcClient.getCurrentUserIdentity(token, new LoginDTO()));
        return (BizWorksUserInfo)response.getData();
    }

    public BizWorksFullUserInfo getFullCurrentUserInfo() {
        BizWorksApiConfig bizWorksApiConfig = this.configManager.needValidApiConfig();
        String token = bizWorksApiConfig.getToken();
        return this.getFullCurrentUserInfo(token);
    }

    public BizWorksFullUserInfo getFullCurrentUserInfo(String token) {
        BizWorksApiConfig bizWorksApiConfig = this.configManager.needValidApiConfig();
        if (StringUtils.isEmpty((CharSequence)token)) {
            token = bizWorksApiConfig.getToken();
        }
        SingleResponse<BizWorksFullUserInfo> response = ClientUtilsKt.get(this.loginRpcClient.getCurrUserFullInfo(token, new LoginDTO()));
        return (BizWorksFullUserInfo)response.getData();
    }
}

