/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.ide.domain.diff.common;

import com.alibaba.bizworks.ide.domain.diff.domain.AttributeDiff;
import com.alibaba.bizworks.ide.domain.diff.domain.DiffValue;
import com.alibaba.bizworks.ide.domain.diff.domain.ElementDiff;
import com.alibaba.bizworks.ide.domain.diff.domain.ElementGroupDiff;
import com.alibaba.bizworks.ide.domain.diff.domain.IDiff;
import com.alibaba.bizworks.ide.domain.diff.schema.core.IDiffSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class GenerateDiffUtils {
    private static final Map<String, Integer> modelTypeOrderMap = new HashMap<String, Integer>(){
        {
            this.put("domain-object", 1);
            this.put("domain-service", 2);
            this.put("structure-object", 3);
            this.put("application-service", 4);
            this.put("business-capability-api", 5);
            this.put("data-object", 6);
            this.put("domain-event", 7);
            this.put("domain-event-consumer", 8);
        }
    };

    public static IDiff generateDiff(IDiffSchema source, IDiffSchema target, boolean ignoreOrder) {
        ArrayList<IDiffSchema> sources = new ArrayList<IDiffSchema>();
        ArrayList<IDiffSchema> targets = new ArrayList<IDiffSchema>();
        if (source != null) {
            sources.add(source);
        }
        if (target != null) {
            targets.add(target);
        }
        return GenerateDiffUtils.generateDiffList(sources, targets, ignoreOrder).get(0);
    }

    public static <T extends IDiffSchema> List<? extends IDiff> generateDiffList(List<T> sources, List<T> targets, boolean ignoreOrder) {
        List<IDiff> diffList;
        ElementDiff elementDiff;
        IDiffSchema source;
        int idx;
        LinkedHashMap<String, Integer> sourceMap = new LinkedHashMap<String, Integer>();
        int sourcesSize = sources != null ? sources.size() : 0;
        int targetsSize = targets != null ? targets.size() : 0;
        for (idx = 0; idx < sourcesSize; ++idx) {
            IDiffSchema value = (IDiffSchema)sources.get(idx);
            String id = value.fetchNodeId();
            if (!Objects.nonNull(id)) continue;
            sourceMap.put(id, idx);
        }
        idx = 0;
        ArrayList<ElementDiff> results = new ArrayList<ElementDiff>();
        for (int targetIdx = 0; targetIdx < targetsSize; ++targetIdx) {
            IDiffSchema target = (IDiffSchema)targets.get(targetIdx);
            String targetId = target.fetchNodeId();
            Integer sourceIdx = (Integer)sourceMap.get(targetId);
            if (!Objects.isNull(targetId) || Objects.isNull(sourceIdx)) {
                // empty if block
            }
            if (Objects.isNull(targetId) || Objects.isNull(sourceIdx)) {
                ElementDiff elementDiff2 = new ElementDiff();
                List<IDiff> diffList2 = GenerateDiffUtils.buildTarget(target, ignoreOrder);
                elementDiff2.setState("deleted");
                elementDiff2.setCode(target.fetchNodeName());
                elementDiff2.setType(target.fetchNodeType());
                elementDiff2.setComment(GenerateDiffUtils.buildComment(null, target.fetchCommentAttributes()));
                elementDiff2.setChildren(diffList2);
                results.add(elementDiff2);
                continue;
            }
            if (ignoreOrder || sourceIdx.equals(targetIdx)) {
                source = (IDiffSchema)sources.get(sourceIdx);
                elementDiff = new ElementDiff();
                diffList = GenerateDiffUtils.buildSourceTarget(source, target, ignoreOrder);
                elementDiff.setState(GenerateDiffUtils.generateState(diffList));
                elementDiff.setCode(target.fetchNodeName());
                elementDiff.setType(target.fetchNodeType());
                elementDiff.setComment(GenerateDiffUtils.buildComment(source.fetchCommentAttributes(), target.fetchCommentAttributes()));
                elementDiff.setChildren(diffList);
                results.add(elementDiff);
                sourceMap.remove(targetId);
                continue;
            }
            while (idx < sourceIdx) {
                source = (IDiffSchema)sources.get(sourceIdx);
                elementDiff = new ElementDiff();
                diffList = GenerateDiffUtils.buildSource(source, ignoreOrder);
                elementDiff.setState("created");
                elementDiff.setCode(source.fetchNodeName());
                elementDiff.setType(source.fetchNodeType());
                elementDiff.setComment(GenerateDiffUtils.buildComment(source.fetchCommentAttributes(), null));
                elementDiff.setChildren(diffList);
                results.add(elementDiff);
                sourceMap.remove(source.fetchNodeId());
                ++idx;
            }
            idx = sourceIdx + 1;
            source = (IDiffSchema)sources.get(sourceIdx);
            elementDiff = new ElementDiff();
            diffList = GenerateDiffUtils.buildSourceTarget(source, target, ignoreOrder);
            elementDiff.setState(GenerateDiffUtils.generateState(diffList));
            elementDiff.setCode(target.fetchNodeName());
            elementDiff.setType(target.fetchNodeType());
            elementDiff.setComment(GenerateDiffUtils.buildComment(source.fetchCommentAttributes(), target.fetchCommentAttributes()));
            elementDiff.setChildren(diffList);
            results.add(elementDiff);
            sourceMap.remove(targetId);
        }
        LinkedHashSet idSet = new LinkedHashSet(sourceMap.keySet());
        for (String id : idSet) {
            int sourceIdx = (Integer)sourceMap.get(id);
            source = (IDiffSchema)sources.get(sourceIdx);
            elementDiff = new ElementDiff();
            diffList = GenerateDiffUtils.buildSource(source, ignoreOrder);
            elementDiff.setState("created");
            elementDiff.setCode(source.fetchNodeName());
            elementDiff.setType(source.fetchNodeType());
            elementDiff.setComment(GenerateDiffUtils.buildComment(source.fetchCommentAttributes(), null));
            elementDiff.setChildren(diffList);
            results.add(elementDiff);
            sourceMap.remove(source.fetchNodeId());
        }
        return results;
    }

    private static <T extends IDiffSchema> List<? extends IDiff> buildSource(T source, boolean ignoreOrder) {
        Map<String, List<IDiffSchema>> compositeListAttributes;
        ArrayList<IDiff> result = new ArrayList<IDiff>();
        List<AttributeDiff> simpleDiffList = GenerateDiffUtils.buildSimpleSourceTarget(source, null);
        result.addAll(simpleDiffList);
        Map<String, IDiffSchema> compositeAttributes = source.fetchCompositeAttributes();
        if (MapUtils.isNotEmpty(compositeAttributes)) {
            for (String key : compositeAttributes.keySet()) {
                IDiff diff = GenerateDiffUtils.generateDiff(compositeAttributes.get(key), null, ignoreOrder);
                List<IDiff> diffList = Arrays.asList(diff);
                ElementGroupDiff elementGroupDiff = new ElementGroupDiff();
                elementGroupDiff.setState(GenerateDiffUtils.generateState(diffList));
                elementGroupDiff.setType(key);
                elementGroupDiff.setChildren(diffList);
                result.add(elementGroupDiff);
            }
        }
        if (MapUtils.isNotEmpty(compositeListAttributes = source.fetchCompositeListAttributes())) {
            ArrayList<String> keySet = new ArrayList<String>(compositeListAttributes.keySet());
            keySet.sort((left, right) -> {
                Integer lVal = modelTypeOrderMap.getOrDefault(left, Integer.MAX_VALUE);
                Integer rVal = modelTypeOrderMap.getOrDefault(right, Integer.MAX_VALUE);
                return lVal.compareTo(rVal);
            });
            for (String key : keySet) {
                List<IDiff> diffList = GenerateDiffUtils.generateDiffList(compositeListAttributes.get(key), null, ignoreOrder);
                ElementGroupDiff elementGroupDiff = new ElementGroupDiff();
                elementGroupDiff.setState(GenerateDiffUtils.generateState(diffList));
                elementGroupDiff.setType(key);
                elementGroupDiff.setChildren(diffList);
                result.add(elementGroupDiff);
            }
        }
        return result;
    }

    private static <T extends IDiffSchema> List<? extends IDiff> buildSourceTarget(T source, T target, boolean ignoreOrder) {
        ArrayList<IDiff> result = new ArrayList<IDiff>();
        List<AttributeDiff> simpleDiffList = GenerateDiffUtils.buildSimpleSourceTarget(source, target);
        result.addAll(simpleDiffList);
        LinkedHashSet<String> compositeAttributes = new LinkedHashSet<String>();
        Map<String, IDiffSchema> sCompositeAttributes = source.fetchCompositeAttributes();
        Map<String, IDiffSchema> tCompositeAttributes = target.fetchCompositeAttributes();
        if (MapUtils.isNotEmpty(sCompositeAttributes)) {
            compositeAttributes.addAll(sCompositeAttributes.keySet());
        }
        if (MapUtils.isNotEmpty(tCompositeAttributes)) {
            compositeAttributes.addAll(tCompositeAttributes.keySet());
        }
        for (String key : compositeAttributes) {
            IDiff diff = GenerateDiffUtils.generateDiff(sCompositeAttributes.get(key), tCompositeAttributes.get(key), ignoreOrder);
            List<IDiff> diffList = Arrays.asList(diff);
            ElementGroupDiff elementGroupDiff = new ElementGroupDiff();
            elementGroupDiff.setState(GenerateDiffUtils.generateState(diffList));
            elementGroupDiff.setType(key);
            elementGroupDiff.setChildren(diffList);
            result.add(elementGroupDiff);
        }
        LinkedHashSet<String> compositeListAttributes = new LinkedHashSet<String>();
        Map<String, List<IDiffSchema>> sCompositeListAttributes = source.fetchCompositeListAttributes();
        Map<String, List<IDiffSchema>> tCompositeListAttributes = target.fetchCompositeListAttributes();
        if (MapUtils.isNotEmpty(sCompositeListAttributes)) {
            compositeListAttributes.addAll(sCompositeListAttributes.keySet());
        }
        if (MapUtils.isNotEmpty(tCompositeListAttributes)) {
            compositeListAttributes.addAll(tCompositeListAttributes.keySet());
        }
        ArrayList keySet = new ArrayList(compositeListAttributes);
        keySet.sort((left, right) -> {
            Integer lVal = modelTypeOrderMap.getOrDefault(left, Integer.MAX_VALUE);
            Integer rVal = modelTypeOrderMap.getOrDefault(right, Integer.MAX_VALUE);
            return lVal.compareTo(rVal);
        });
        for (String key : keySet) {
            List<IDiffSchema> sourceList = sCompositeListAttributes != null ? sCompositeListAttributes.get(key) : null;
            List<IDiffSchema> targetList = tCompositeListAttributes != null ? tCompositeListAttributes.get(key) : null;
            List<IDiff> diffList = GenerateDiffUtils.generateDiffList(sourceList, targetList, ignoreOrder);
            ElementGroupDiff elementGroupDiff = new ElementGroupDiff();
            elementGroupDiff.setState(GenerateDiffUtils.generateState(diffList));
            elementGroupDiff.setType(key);
            elementGroupDiff.setChildren(diffList);
            result.add(elementGroupDiff);
        }
        return result;
    }

    private static <T extends IDiffSchema> List<? extends IDiff> buildTarget(IDiffSchema target, boolean ignoreOrder) {
        Map<String, List<IDiffSchema>> compositeListAttributes;
        ArrayList<IDiff> result = new ArrayList<IDiff>();
        List<AttributeDiff> simpleDiffList = GenerateDiffUtils.buildSimpleSourceTarget(null, target);
        result.addAll(simpleDiffList);
        Map<String, IDiffSchema> compositeAttributes = target.fetchCompositeAttributes();
        if (MapUtils.isNotEmpty(compositeAttributes)) {
            for (String key : compositeAttributes.keySet()) {
                IDiff diff = GenerateDiffUtils.generateDiff(null, compositeAttributes.get(key), ignoreOrder);
                List<IDiff> diffList = Arrays.asList(diff);
                ElementGroupDiff elementGroupDiff = new ElementGroupDiff();
                elementGroupDiff.setState(GenerateDiffUtils.generateState(diffList));
                elementGroupDiff.setType(key);
                elementGroupDiff.setChildren(diffList);
                result.add(elementGroupDiff);
            }
        }
        if (MapUtils.isNotEmpty(compositeListAttributes = target.fetchCompositeListAttributes())) {
            ArrayList<String> keySet = new ArrayList<String>(compositeListAttributes.keySet());
            keySet.sort((left, right) -> {
                Integer lVal = modelTypeOrderMap.getOrDefault(left, Integer.MAX_VALUE);
                Integer rVal = modelTypeOrderMap.getOrDefault(right, Integer.MAX_VALUE);
                return lVal.compareTo(rVal);
            });
            for (String key : keySet) {
                List<IDiff> diffList = GenerateDiffUtils.generateDiffList(null, compositeListAttributes.get(key), ignoreOrder);
                ElementGroupDiff elementGroupDiff = new ElementGroupDiff();
                elementGroupDiff.setState(GenerateDiffUtils.generateState(diffList));
                elementGroupDiff.setType(key);
                elementGroupDiff.setChildren(diffList);
                result.add(elementGroupDiff);
            }
        }
        return result;
    }

    public static String generateState(List<? extends IDiff> diffList) {
        HashSet<String> stateSet = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(diffList)) {
            for (IDiff iDiff : diffList) {
                stateSet.add(iDiff.getState());
            }
        }
        if (stateSet.size() > 1) {
            return "modified";
        }
        if (stateSet.size() == 1) {
            return (String)stateSet.iterator().next();
        }
        return "none";
    }

    private static List<AttributeDiff> buildSimpleSourceTarget(IDiffSchema source, IDiffSchema target) {
        Map<String, Object> sourceMap = source != null ? source.fetchSimpleAttributes() : null;
        Map<String, Object> targetMap = target != null ? target.fetchSimpleAttributes() : null;
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        Optional<Map<String, Object>> sourceMapOpt = Optional.ofNullable(sourceMap);
        Optional<Map<String, Object>> targetMapOpt = Optional.ofNullable(targetMap);
        if (sourceMapOpt.isPresent()) {
            keys.addAll(sourceMap.keySet());
        }
        if (targetMapOpt.isPresent()) {
            keys.addAll(targetMap.keySet());
        }
        ArrayList<AttributeDiff> result = new ArrayList<AttributeDiff>();
        for (String key : keys) {
            Object sourceVal = sourceMapOpt.isPresent() ? sourceMap.get(key) : null;
            Object targetVal = targetMapOpt.isPresent() ? targetMap.get(key) : null;
            AttributeDiff attributeDiff = new AttributeDiff();
            attributeDiff.setBefore(targetVal);
            attributeDiff.setAfter(sourceVal);
            attributeDiff.setType("item");
            if (targetMapOpt.isEmpty()) {
                attributeDiff.setState("created");
            } else if (sourceMapOpt.isEmpty()) {
                attributeDiff.setState("deleted");
            } else {
                boolean objEqual = Objects.equals(sourceVal, targetVal);
                boolean eqRs = objEqual || GenerateDiffUtils.allEmptySting(sourceVal, targetVal);
                attributeDiff.setState(eqRs ? "none" : "modified");
            }
            attributeDiff.setCode(key);
            result.add(attributeDiff);
        }
        return result;
    }

    private static boolean allEmptySting(Object object1, Object object2) {
        return GenerateDiffUtils.mayBeEmptyString(object1) && GenerateDiffUtils.mayBeEmptyString(object2);
    }

    private static boolean mayBeEmptyString(Object object) {
        return object == null || object instanceof String && StringUtils.isEmpty((CharSequence)((String)object));
    }

    private static Map<String, DiffValue> buildComment(Map<String, Object> source, Map<String, Object> target) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        Optional<Map<String, Object>> sourceOpt = Optional.ofNullable(source);
        Optional<Map<String, Object>> targetOpt = Optional.ofNullable(target);
        if (sourceOpt.isPresent()) {
            keys.addAll(source.keySet());
        }
        if (targetOpt.isPresent()) {
            keys.addAll(target.keySet());
        }
        if (CollectionUtils.isEmpty(keys)) {
            return null;
        }
        LinkedHashMap<String, DiffValue> result = new LinkedHashMap<String, DiffValue>();
        for (String key : keys) {
            Object sourceVal = sourceOpt.isPresent() ? source.get(key) : null;
            Object targetVal = targetOpt.isPresent() ? target.get(key) : null;
            DiffValue diffValue = new DiffValue();
            diffValue.setBefore(targetVal);
            diffValue.setAfter(sourceVal);
            result.put(key, diffValue);
        }
        return result;
    }
}

