/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.ide.domain.sync.framework.config;

import com.alibaba.bizworks.ide.domain.sync.framework.config.ConfigFileUtils;
import com.alibaba.bizworks.ide.domain.sync.framework.config.ConfigManager;
import com.alibaba.bizworks.ide.domain.sync.framework.config.exception.BizWorksYamlAndModuleYamlNotExistException;
import com.alibaba.bizworks.ide.domain.sync.framework.config.exception.ForMergeYamlException;
import com.alibaba.bizworks.ide.domain.sync.framework.config.exception.ModulesConfigInvalidException;
import com.alibaba.bizworks.ide.domain.sync.framework.config.model.BizWorksConfig;
import com.alibaba.bizworks.ide.domain.sync.framework.config.model.ModuleFileConfig;
import com.alibaba.bizworks.ide.domain.sync.framework.config.model.ModulesConfigOption;
import com.alibaba.bizworks.ide.domain.sync.framework.config.model.enterprise.EnterpriseGlobalYamlConfig;
import com.alibaba.bizworks.ide.domain.sync.framework.config.model.enterprise.EnterpriseYamlConfigFile;
import com.alibaba.bizworks.ide.domain.sync.framework.config.msg.MsgPublisher;
import java.io.File;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigManagerImpl
implements ConfigManager {
    private static final Logger log = LoggerFactory.getLogger(ConfigManagerImpl.class);
    private final MsgPublisher msgPublisher;
    private List<ModuleFileConfig> moduleFileConfigs;
    private volatile BizWorksConfig bizWorksConfig = new BizWorksConfig();

    public ConfigManagerImpl(MsgPublisher msgPublisher) {
        this.msgPublisher = msgPublisher;
    }

    private void setModuleFileConfigs(List<ModuleFileConfig> moduleFileConfigs) {
        boolean change;
        List<ModuleFileConfig> pre = this.moduleFileConfigs;
        this.moduleFileConfigs = moduleFileConfigs;
        if (!this.msgPublisher.isMsgWorks()) {
            return;
        }
        boolean bl = change = (pre == null || moduleFileConfigs == null) && pre != moduleFileConfigs;
        if (!change && pre != moduleFileConfigs) {
            boolean bl2 = change = !CollectionUtils.isEqualCollection(pre, moduleFileConfigs);
        }
        if (change) {
            this.msgPublisher.moduleFileConfigsChanged(moduleFileConfigs);
        }
    }

    @Override
    public void setBizWorksConfig(BizWorksConfig bizWorksConfig) {
        this.bizWorksConfig = bizWorksConfig == null ? new BizWorksConfig() : bizWorksConfig;
        this.doSetBizWorksConfig(bizWorksConfig);
    }

    protected abstract void doSetBizWorksConfig(BizWorksConfig var1);

    private void setModulesYamlConfig(ModulesConfigOption config) {
        BizWorksConfig bizWorksConfig = this.getBizWorksConfig();
        if (bizWorksConfig == null) {
            bizWorksConfig = new BizWorksConfig();
        }
        bizWorksConfig.setModulesConfigOption(config);
        this.setBizWorksConfig(bizWorksConfig);
    }

    public String getModulesConfigFilePath() {
        ModulesConfigOption configOption;
        BizWorksConfig bizWorksConfig = this.getBizWorksConfig();
        if (bizWorksConfig != null && (configOption = bizWorksConfig.getModulesConfigOption()) != null) {
            return configOption.getConfigFilePath();
        }
        return null;
    }

    @Override
    public String findBizWorksYamlPath() {
        String bizWorksYamlPath = this.getModulesConfigFilePath();
        log.info("configPathDebug - findBizWorksYamlPath path:{}", (Object)bizWorksYamlPath);
        if (StringUtils.isNotBlank((CharSequence)bizWorksYamlPath) && new File(bizWorksYamlPath).exists()) {
            log.debug("configPathDebug - findBizWorksYamlPath path exist");
            return bizWorksYamlPath;
        }
        log.info("configPathDebug - findBizWorksYamlPath path not exist");
        List<String> paths = this.possibleBizWorksYamlPaths();
        log.debug("configPathDebug - possibleBizWorksYamlPaths path:{}", paths);
        if (CollectionUtils.isEmpty(paths)) {
            return null;
        }
        return ConfigFileUtils.findFirstExistFileInProject(paths);
    }

    @Override
    public String findModulesYamlPath() {
        List<String> paths = this.possibleModuleYamlPaths();
        if (CollectionUtils.isEmpty(paths)) {
            return null;
        }
        return ConfigFileUtils.findFirstExistFileInProject(paths);
    }

    private String needModulesConfigPath() {
        String bizWorksYamlPath = this.findBizWorksYamlPath();
        if (!StringUtils.isBlank((CharSequence)bizWorksYamlPath)) {
            return bizWorksYamlPath;
        }
        String moduleYamlPath = this.findModulesYamlPath();
        if (StringUtils.isBlank((CharSequence)moduleYamlPath)) {
            throw new BizWorksYamlAndModuleYamlNotExistException("\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        throw new ForMergeYamlException("\u5efa\u8bae\u5408\u5e76modules.yaml\u5230bizworks.yml");
    }

    public abstract List<String> possibleBizWorksYamlPaths();

    public abstract List<String> possibleModuleYamlPaths();

    @Override
    public EnterpriseYamlConfigFile reloadConfig() {
        String path = this.needModulesConfigPath();
        return this.loadModulesConfig(path);
    }

    @Override
    public EnterpriseYamlConfigFile tryLoadConfig() {
        String modulesConfigPath = this.findBizWorksYamlPath();
        if (StringUtils.isEmpty((CharSequence)modulesConfigPath)) {
            return null;
        }
        return this.tryLoadConfigWithoutException(modulesConfigPath);
    }

    @Override
    public EnterpriseYamlConfigFile tryLoadConfigWithoutException(String path) {
        if (path == null) {
            return null;
        }
        try {
            return this.loadModulesConfig(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public EnterpriseYamlConfigFile loadModulesConfig(String path) {
        EnterpriseYamlConfigFile enterpriseYamlConfigFile = ConfigFileUtils.loadEnterpriseYamlConfig(path);
        if (enterpriseYamlConfigFile == null) {
            throw new ModulesConfigInvalidException("bizworks.yml\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        EnterpriseGlobalYamlConfig bizWorks = enterpriseYamlConfigFile.getBizworks();
        ModulesConfigOption modulesConfigOption = new ModulesConfigOption();
        modulesConfigOption.setConfigFilePath(path);
        this.setModulesYamlConfig(modulesConfigOption);
        this.setEnterpriseYamlConfigFile(enterpriseYamlConfigFile);
        return enterpriseYamlConfigFile;
    }

    public List<ModuleFileConfig> getModuleFileConfigs() {
        return this.moduleFileConfigs;
    }
}

