/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.ide.domain.sync.framework.config;

import com.alibaba.bizworks.ide.domain.sync.framework.config.GlobalConfigManager;
import com.alibaba.bizworks.ide.domain.sync.framework.config.exception.ApiConfigInvalidException;
import com.alibaba.bizworks.ide.domain.sync.framework.config.model.BizWorksApiConfig;
import com.alibaba.bizworks.ide.domain.sync.framework.config.model.BizWorksUserInfo;
import com.alibaba.bizworks.ide.domain.sync.framework.msg.GlobalMsgPublisher;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Objects;

public abstract class GlobalConfigManagerImpl
implements GlobalConfigManager {
    private final GlobalMsgPublisher globalMsgPublisher;
    private volatile BizWorksApiConfig apiConfig = new BizWorksApiConfig();
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public void registerPropertyChangeSupport(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    private void fireScanResultChange() {
        this.changeSupport.firePropertyChange("apiScanResult", null, null);
    }

    public GlobalConfigManagerImpl(GlobalMsgPublisher globalMsgPublisher) {
        this.globalMsgPublisher = globalMsgPublisher;
    }

    @Override
    public void setApiConfig(BizWorksApiConfig config) {
        this.setApiConfig(config, true);
    }

    public void setApiConfig(BizWorksApiConfig config, boolean pubMsg) {
        BizWorksApiConfig pre = this.getApiConfig();
        this.doSetApiConfig(config);
        if (pubMsg && !Objects.equals(this.getApiConfig(), pre)) {
            this.fireScanResultChange();
            this.globalMsgPublisher.apiConfigChanged(config);
        }
    }

    @Override
    public void setUserInfo(BizWorksUserInfo userInfo) {
        this.setUserInfo(userInfo, true);
    }

    public void setUserInfo(BizWorksUserInfo userInfo, boolean pubMsg) {
        BizWorksUserInfo theUserInfo = userInfo == null ? new BizWorksUserInfo() : userInfo;
        this.doSetUser(theUserInfo);
        if (pubMsg) {
            this.globalMsgPublisher.userInfoChange(userInfo);
        }
    }

    protected abstract void doSetUser(BizWorksUserInfo var1);

    protected abstract void doSetApiConfig(BizWorksApiConfig var1);

    @Override
    public void invalidUserInfo() {
        BizWorksUserInfo userInfo = this.getUserInfo();
        if (userInfo == null) {
            userInfo = new BizWorksUserInfo();
            userInfo.setValid(false);
            this.setUserInfo(userInfo);
        } else {
            userInfo.setValid(false);
        }
    }

    @Override
    public BizWorksApiConfig needValidApiConfig() {
        this.checkApiConfigValid();
        return this.getApiConfig();
    }

    @Override
    public void checkApiConfigValid() {
        if (this.getApiConfig() == null) {
            throw new ApiConfigInvalidException("BizWorks \u8ba4\u8bc1\u4fe1\u606f\u6682\u672a\u914d\u7f6e");
        }
        if ("".equals(this.getApiConfig().getServerUrl()) || this.getApiConfig().getServerUrl() == null) {
            throw new ApiConfigInvalidException("\u8ba4\u8bc1\u4fe1\u606f BizWorks \u5e73\u53f0\u5730\u5740 \u6682\u672a\u914d\u7f6e");
        }
        if ("".equals(this.getApiConfig().getToken()) || this.getApiConfig().getToken() == null) {
            throw new ApiConfigInvalidException("\u8ba4\u8bc1\u4fe1\u606f Token \u6682\u672a\u914d\u7f6e");
        }
    }

    @Override
    public boolean isApiConfigValid() {
        try {
            this.checkApiConfigValid();
        }
        catch (ApiConfigInvalidException e) {
            return false;
        }
        return true;
    }
}

