/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.ide.domain.sync.framework.config.converter;

import com.alibaba.bizworks.ads.meta.lang.module.MdModule;
import com.alibaba.bizworks.ide.domain.sync.framework.config.model.association.ModuleConfig;
import com.alibaba.bizworks.ide.domain.sync.framework.config.model.association.PackageConfig;
import com.alibaba.bizworks.ide.domain.sync.framework.config.model.enterprise.EnterpriseModulesYamlConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

@Mapper
public interface ModuleConfigConverter {
    public static final ModuleConfigConverter INSTANCE = (ModuleConfigConverter)Mappers.getMapper(ModuleConfigConverter.class);

    @Mappings(value={@Mapping(target="packages", ignore=true), @Mapping(target="valid", ignore=true), @Mapping(target="enable", ignore=true), @Mapping(target="mdModule", source="source")})
    public ModuleConfig toModuleConfig(MdModule var1);

    public List<ModuleConfig> toList(Collection<MdModule> var1);

    default public List<MdModule> toMdModuleList(Collection<ModuleConfig> source) {
        if (source == null) {
            return Collections.emptyList();
        }
        return source.stream().map(ModuleConfig::getMdModule).collect(Collectors.toList());
    }

    public List<ModuleConfig> toMdModuleList(List<EnterpriseModulesYamlConfig> var1);

    public List<EnterpriseModulesYamlConfig> toModulesYamlConfigs(List<ModuleConfig> var1);

    @Mappings(value={@Mapping(target="name", source="code"), @Mapping(target="kind", expression="java(MdKind.fromCode(yamlConfig.getType()))"), @Mapping(target="versionStatus", ignore=true), @Mapping(target="version", ignore=true), @Mapping(target="valid", ignore=true), @Mapping(target="projectCode", ignore=true), @Mapping(target="mdModule", ignore=true), @Mapping(target="lastVersionStatus", ignore=true), @Mapping(target="lastVersion", ignore=true), @Mapping(target="enable", ignore=true), @Mapping(target="displayName", ignore=true), @Mapping(target="description", ignore=true)})
    public ModuleConfig toModuleConfig(EnterpriseModulesYamlConfig var1);

    @Mappings(value={@Mapping(target="code", source="name"), @Mapping(target="type", source="kind.code")})
    public EnterpriseModulesYamlConfig toModuleYamlConfig(ModuleConfig var1);

    default public PackageConfig toPackageConfig(String pkg) {
        return StringUtils.isBlank((CharSequence)pkg) ? null : new PackageConfig(true, pkg);
    }

    default public String toPkgStr(PackageConfig packageConfig) {
        if (packageConfig == null) {
            return null;
        }
        return packageConfig.getPkg();
    }
}

