/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.ide.domain.sync.framework.meta;

import com.alibaba.bizworks.ads.meta.lang.Metadata;
import com.alibaba.bizworks.ads.meta.lang.file.MdApplicationService;
import com.alibaba.bizworks.ads.meta.lang.file.MdBusinessCapability;
import com.alibaba.bizworks.ads.meta.lang.file.MdDomainObject;
import com.alibaba.bizworks.ads.meta.lang.file.MdDomainService;
import com.alibaba.bizworks.ads.meta.lang.file.MdFile;
import com.alibaba.bizworks.ads.meta.lang.file.MdStructureObject;
import com.alibaba.bizworks.ads.meta.lang.module.MdModule;
import com.alibaba.bizworks.ide.common.meta.MdKind;
import com.alibaba.bizworks.ide.domain.sync.framework.meta.MetaUtils;
import com.google.common.collect.ImmutableMap;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;

public class MetadataCaches {
    PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private final Map<String, Metadata> metadataMap = new ConcurrentHashMap<String, Metadata>();
    private final Map<String, MdModule> modulesMap = new ConcurrentHashMap<String, MdModule>();
    private final Map<String, MdFile> mdFileMap = new ConcurrentHashMap<String, MdFile>();

    public void registerPropertyChangeSupport(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    protected MetadataCaches() {
    }

    public Metadata put(Metadata metadata) {
        return null;
    }

    public void replaceAll(Collection<MdModule> newModules) {
        this.metadataMap.clear();
        this.modulesMap.clear();
        this.mdFileMap.clear();
        for (MdModule module : newModules) {
            this.modulesMap.put(module.getQname(), module);
            this.handleModuleResources(module);
        }
        this.changeSupport.firePropertyChange("mdFileMap", null, null);
    }

    private void handleModuleResources(MdModule module) {
        List contains = module.getContains();
        if (CollectionUtils.isNotEmpty((Collection)contains)) {
            for (MdFile meta : contains) {
                this.handleMetaResource(meta);
            }
        }
    }

    private void handleMetaResource(MdFile meta) {
        if (meta == null) {
            return;
        }
        String qname = meta.getQname();
        MetaUtils.setOwner(meta);
        this.mdFileMap.put(qname, meta);
    }

    private void putAllMetadata(Collection<Metadata> metadataList) {
        if (CollectionUtils.isNotEmpty(metadataList)) {
            metadataList.forEach(meta -> {
                String ukId = meta.getGlobalId();
                if (ukId != null) {
                    this.metadataMap.put(ukId, (Metadata)meta);
                }
            });
        }
    }

    public boolean checkMdFileMapIsEmpty() {
        return this.mdFileMap.isEmpty();
    }

    public Collection<MdModule> getAllModulesAndMeta() {
        return this.modulesMap.values();
    }

    public Map<String, MdFile> getAllMdFiles() {
        return ImmutableMap.copyOf(this.mdFileMap);
    }

    public <T extends MdFile> T findByQname(String qname, Class<T> tClass) {
        MdFile meta = this.mdFileMap.get(qname);
        if (meta == null || !tClass.isAssignableFrom(meta.getClass())) {
            return null;
        }
        return (T)meta;
    }

    public void replace(MdFile newOne) {
        this.handleMetaResource(newOne);
    }

    public void remove(MdFile oldOne) {
        String qname = oldOne.getQname();
        this.mdFileMap.remove(qname);
    }

    public <T extends MdFile> Map<String, T> getMdMap(MdKind kind) {
        HashMap<String, MdFile> map = new HashMap<String, MdFile>();
        for (Map.Entry<String, MdFile> mdFileEntry : this.mdFileMap.entrySet()) {
            if (kind.equals((Object)MdKind.DOMAIN_OBJECT) && mdFileEntry.getValue() instanceof MdDomainObject) {
                map.put(mdFileEntry.getKey(), mdFileEntry.getValue());
            }
            if (kind.equals((Object)MdKind.DOMAIN_SERVICE) && mdFileEntry.getValue() instanceof MdDomainService) {
                map.put(mdFileEntry.getKey(), mdFileEntry.getValue());
            }
            if (kind.equals((Object)MdKind.APPLICATION_SERVICE) && mdFileEntry.getValue() instanceof MdApplicationService) {
                map.put(mdFileEntry.getKey(), mdFileEntry.getValue());
            }
            if (kind.equals((Object)MdKind.STRUCTURE_OBJECT) && mdFileEntry.getValue() instanceof MdStructureObject) {
                map.put(mdFileEntry.getKey(), mdFileEntry.getValue());
            }
            if (!kind.equals((Object)MdKind.BUSINESS_CAPABILITY_API) || !(mdFileEntry.getValue() instanceof MdBusinessCapability)) continue;
            map.put(mdFileEntry.getKey(), mdFileEntry.getValue());
        }
        return map;
    }
}

