package ${package.ServiceImpl};

import com.alibaba.bizworks.core.runtime.common.QueryCondition;
import ${queryConditionPkg}

import ${package.Mapper}.${table.mapperName};
import ${package.Service}.${table.serviceName};
import ${package.Service}.converter.${oriEntity}DTOToDOConverter;
import ${package.Parent}.dto.${oriEntity}DTO;
import ${package.Parent}.dto.${oriEntity}PageInfo;
import ${package.Parent}.dao.${entity};
import java.lang.Override;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import java.util.ArrayList;
import java.util.List;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.util.ObjectUtils;

/**
 * ${table.comment!} 服务实现类
 *
 * @author ${author}
 * @since ${date}
 */
@Component("${oriEntity}${table.serviceName}AS")
<#if kotlin>
open class ${table.serviceImplName} : ${superServiceImplClass}<${table.mapperName}, ${oriEntity}>(), ${table.serviceName} {

}
<#else>
public class ${table.serviceImplName} implements ${table.serviceName} {

    @Autowired
    private ${table.mapperName} ${table.mapperName?uncap_first};

    @Override
    public Boolean create(${oriEntity}DTO ${oriEntity?uncap_first}) {
    	${entity} ${entity?uncap_first} = ${oriEntity}DTOToDOConverter.INSTANCE.${oriEntity?uncap_first}DTOTo${entity}(${oriEntity?uncap_first});
		int count = ${table.mapperName?uncap_first}.insert(${entity?uncap_first});
		return count == 1;
	}

    @Override
    public Boolean update(${oriEntity}DTO ${oriEntity?uncap_first}) {
    	${entity} ${entity?uncap_first} = ${oriEntity}DTOToDOConverter.INSTANCE.${oriEntity?uncap_first}DTOTo${entity}(${oriEntity?uncap_first});
		UpdateWrapper<${entity}> updateWrapper = new UpdateWrapper<>();
		updateWrapper.eq("id", ${oriEntity?uncap_first}DO.getId());
		int count = ${table.mapperName?uncap_first}.update(${entity?uncap_first},  updateWrapper);
		return count == 1;
	}

    @Override
    public ${oriEntity}PageInfo findByCondition(QueryCondition condition) {
    	Integer current = 1;
		Integer size = 10;
    	if (!ObjectUtils.isEmpty(condition.getPageNum())) {
			current = condition.getPageNum();
		}
    	if (!ObjectUtils.isEmpty(condition.getPageSize())) {
    		size = condition.getPageSize();
		}
		IPage<${entity}> page = new Page<>(current, size);
		QueryWrapper queryWrapper = QueryConditionToQueryWrapperConverter.convert(condition, ${entity}.class);
		IPage<${entity}> iPage = ${table.mapperName?uncap_first}.selectPage(page, queryWrapper);
		List<${entity}> ${entity?uncap_first}List = iPage.getRecords();
		List<${oriEntity}DTO> ${oriEntity?uncap_first}DTOList = new ArrayList<>((${entity?uncap_first}List.size()));
		for (${entity} ${entity?uncap_first} : ${entity?uncap_first}List) {
			${oriEntity?uncap_first}DTOList.add(${oriEntity}DTOToDOConverter.INSTANCE.${entity?uncap_first}To${oriEntity}DTO(${entity?uncap_first}));
		}
		${oriEntity}PageInfo ${oriEntity?uncap_first}PageInfo = new ${oriEntity}PageInfo();
		${oriEntity?uncap_first}PageInfo.setTotalCount(iPage.getTotal());
		${oriEntity?uncap_first}PageInfo.setResult(${oriEntity?uncap_first}DTOList);
		return ${oriEntity?uncap_first}PageInfo;
	}

    @Override
    public ${oriEntity}DTO findById(Integer id) {
    	${entity} ${entity?uncap_first} = ${table.mapperName?uncap_first}.selectById(id);
		return ${oriEntity}DTOToDOConverter.INSTANCE.${entity?uncap_first}To${oriEntity}DTO(${entity?uncap_first});
	}

    @Override
    public Boolean deleteById(Integer id) {
    	int count = ${table.mapperName?uncap_first}.deleteById(id);
		return count == 1;
	}
}
</#if>
