/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.ide.domain.sync.framework.codegen;

import com.alibaba.bizworks.ads.meta.lang.Metadata;
import com.alibaba.bizworks.ads.meta.lang.file.MdFile;
import com.alibaba.bizworks.ads.meta.lang.module.MdModule;
import com.alibaba.bizworks.ide.domain.common.ActionSourceType;
import com.alibaba.bizworks.ide.domain.sync.framework.codegen.GenContext;
import com.alibaba.bizworks.ide.domain.sync.framework.codegen.GenConverterConfig;
import com.alibaba.bizworks.ide.domain.sync.framework.codegen.GenConverterContext;
import com.alibaba.bizworks.ide.domain.sync.framework.codegen.GenManager;
import com.alibaba.bizworks.ide.domain.sync.framework.codegen.GenMappingConfig;
import com.alibaba.bizworks.ide.domain.sync.framework.codegen.GenRule;
import com.alibaba.bizworks.ide.domain.sync.framework.codegen.GenRuleManager;
import com.alibaba.bizworks.ide.domain.sync.framework.codegen.converter.GenConverter;
import com.alibaba.bizworks.ide.domain.sync.framework.codemeta.CodeMetaManager;
import com.alibaba.bizworks.ide.domain.sync.framework.codemeta.model.CodeMeta;
import com.alibaba.bizworks.ide.domain.sync.framework.codemeta.model.CodeMetaSourceType;
import com.alibaba.bizworks.ide.domain.sync.framework.meta.MetadataManager;
import com.alibaba.bizworks.ide.domain.sync.framework.meta.model.MetaCsiSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class GenManagerImpl
implements GenManager {
    private final CodeMetaManager codeMetaManager;
    private final GenRuleManager genRuleManager;
    private final MetadataManager metadataManager;

    public GenManagerImpl(CodeMetaManager codeMetaManager, GenRuleManager genRuleManager, MetadataManager metadataManager) {
        this.codeMetaManager = codeMetaManager;
        this.genRuleManager = genRuleManager;
        this.metadataManager = metadataManager;
    }

    @Override
    public void genAllMeta() {
        GenContext genContext = new GenContext();
        genContext.withAncestors(Collections.emptyList());
        genContext.setActionSourceType(ActionSourceType.METADATA_CHANGED);
        Collection<MdModule> allModuleAndMetadata = this.metadataManager.getAllModuleAndMetadata();
        this.genMetaModules(allModuleAndMetadata, genContext);
    }

    private void genMetaModules(Collection<MdModule> allModuleAndMetadata, GenContext genContext) {
        for (MdModule module : allModuleAndMetadata) {
            List contains;
            Collection<GenRule> rules = this.genRuleManager.findMatch((Metadata)module);
            if (CollectionUtils.isNotEmpty(rules)) {
                // empty if block
            }
            if (!CollectionUtils.isNotEmpty((Collection)(contains = module.getContains()))) continue;
            this.genMeta(contains, genContext);
        }
    }

    private void genMeta(List<MdFile> metadataCollection, GenContext parentContext) {
        for (Metadata metadata : metadataCollection) {
            Collection<GenRule> rules = this.genRuleManager.findMatch(metadata);
            if (!CollectionUtils.isNotEmpty(rules)) continue;
            CodeMeta codeMeta = new CodeMeta();
            codeMeta.setMetadata(metadata);
            codeMeta.setFrom(CodeMetaSourceType.GEN);
            GenContext genContext = parentContext.newSubMetaContext(codeMeta);
            for (GenRule genRule : rules) {
                GenConverter converter = genRule.getConverter();
                GenConverterContext context = new GenConverterContext();
                context.setGenContext(genContext);
                GenMappingConfig mappingConfig = genRule.getMappingConfig();
                context.setMappingConfig(mappingConfig);
                context.setPreCsiSet(new MetaCsiSet());
                context.setConverterConfig(new GenConverterConfig());
                MetaCsiSet metaCsiSet = converter.gen(metadata, context);
                codeMeta.mergeCsiSet(metaCsiSet);
            }
        }
    }
}

