/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.ide.domain.sync.framework.config.converter;

import com.alibaba.bizworks.ads.meta.lang.module.MdModule;
import com.alibaba.bizworks.ide.common.meta.MdKind;
import com.alibaba.bizworks.ide.domain.sync.framework.config.converter.ModuleConfigConverter;
import com.alibaba.bizworks.ide.domain.sync.framework.config.model.association.ModuleConfig;
import com.alibaba.bizworks.ide.domain.sync.framework.config.model.association.PackageConfig;
import com.alibaba.bizworks.ide.domain.sync.framework.config.model.enterprise.EnterpriseModulesYamlConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ModuleConfigConverterImpl
implements ModuleConfigConverter {
    @Override
    public ModuleConfig toModuleConfig(MdModule source) {
        if (source == null) {
            return null;
        }
        ModuleConfig moduleConfig = new ModuleConfig();
        moduleConfig.setMdModule(source);
        moduleConfig.setKind(source.getKind());
        moduleConfig.setName(source.getName());
        moduleConfig.setDisplayName(source.getDisplayName());
        moduleConfig.setDescription(source.getDescription());
        moduleConfig.setProjectCode(source.getProjectCode());
        moduleConfig.setVersion(source.getVersion());
        moduleConfig.setVersionStatus(source.getVersionStatus());
        moduleConfig.setLastVersion(source.getLastVersion());
        moduleConfig.setLastVersionStatus(source.getLastVersionStatus());
        return moduleConfig;
    }

    @Override
    public List<ModuleConfig> toList(Collection<MdModule> source) {
        if (source == null) {
            return null;
        }
        ArrayList<ModuleConfig> list = new ArrayList<ModuleConfig>(source.size());
        for (MdModule mdModule : source) {
            list.add(this.toModuleConfig(mdModule));
        }
        return list;
    }

    @Override
    public List<ModuleConfig> toMdModuleList(List<EnterpriseModulesYamlConfig> yamlConfigs) {
        if (yamlConfigs == null) {
            return null;
        }
        ArrayList<ModuleConfig> list = new ArrayList<ModuleConfig>(yamlConfigs.size());
        for (EnterpriseModulesYamlConfig enterpriseModulesYamlConfig : yamlConfigs) {
            list.add(this.toModuleConfig(enterpriseModulesYamlConfig));
        }
        return list;
    }

    @Override
    public List<EnterpriseModulesYamlConfig> toModulesYamlConfigs(List<ModuleConfig> moduleConfigs) {
        if (moduleConfigs == null) {
            return null;
        }
        ArrayList<EnterpriseModulesYamlConfig> list = new ArrayList<EnterpriseModulesYamlConfig>(moduleConfigs.size());
        for (ModuleConfig moduleConfig : moduleConfigs) {
            list.add(this.toModuleYamlConfig(moduleConfig));
        }
        return list;
    }

    @Override
    public ModuleConfig toModuleConfig(EnterpriseModulesYamlConfig yamlConfig) {
        if (yamlConfig == null) {
            return null;
        }
        ModuleConfig moduleConfig = new ModuleConfig();
        moduleConfig.setName(yamlConfig.getCode());
        moduleConfig.setPackages(this.stringListToPackageConfigList(yamlConfig.getPackages()));
        moduleConfig.setKind(MdKind.fromCode((String)yamlConfig.getType()));
        return moduleConfig;
    }

    @Override
    public EnterpriseModulesYamlConfig toModuleYamlConfig(ModuleConfig moduleConfig) {
        if (moduleConfig == null) {
            return null;
        }
        EnterpriseModulesYamlConfig enterpriseModulesYamlConfig = new EnterpriseModulesYamlConfig();
        enterpriseModulesYamlConfig.setCode(moduleConfig.getName());
        enterpriseModulesYamlConfig.setType(this.moduleConfigKindCode(moduleConfig));
        enterpriseModulesYamlConfig.setPackages(this.packageConfigListToStringList(moduleConfig.getPackages()));
        return enterpriseModulesYamlConfig;
    }

    protected List<PackageConfig> stringListToPackageConfigList(List<String> list) {
        if (list == null) {
            return null;
        }
        ArrayList<PackageConfig> list1 = new ArrayList<PackageConfig>(list.size());
        for (String string : list) {
            list1.add(this.toPackageConfig(string));
        }
        return list1;
    }

    private String moduleConfigKindCode(ModuleConfig moduleConfig) {
        if (moduleConfig == null) {
            return null;
        }
        MdKind kind = moduleConfig.getKind();
        if (kind == null) {
            return null;
        }
        String code = kind.getCode();
        if (code == null) {
            return null;
        }
        return code;
    }

    protected List<String> packageConfigListToStringList(List<PackageConfig> list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> list1 = new ArrayList<String>(list.size());
        for (PackageConfig packageConfig : list) {
            list1.add(this.toPkgStr(packageConfig));
        }
        return list1;
    }
}

