/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.ide.domain.sync.framework.config.model;

import com.alibaba.bizworks.ide.common.utils.UrlUtilsKt;
import com.alibaba.bizworks.ide.domain.sync.framework.config.model.BizWorksAuthType;
import org.apache.commons.lang3.StringUtils;

public class BizWorksApiConfig {
    private String serverUrl = "";
    private BizWorksAuthType authType = BizWorksAuthType.ACCESS_TOKEN;
    private String token = "";

    public void setServerUrl(String serverUrl) {
        String tempUrl = (String)StringUtils.defaultIfBlank((CharSequence)serverUrl, (CharSequence)"");
        if (!tempUrl.isEmpty()) {
            tempUrl = UrlUtilsKt.normalizeUrl((String)tempUrl);
        }
        this.serverUrl = tempUrl;
    }

    public void setAuthType(BizWorksAuthType authType) {
        this.authType = null == authType ? BizWorksAuthType.ACCESS_TOKEN : authType;
    }

    public void setToken(String token) {
        this.token = (String)StringUtils.defaultIfBlank((CharSequence)token, (CharSequence)"");
    }

    public String getServerUrl() {
        return StringUtils.defaultString((String)this.serverUrl);
    }

    public BizWorksAuthType getAuthType() {
        return this.authType == null ? BizWorksAuthType.ACCESS_TOKEN : this.authType;
    }

    public String getToken() {
        return StringUtils.defaultString((String)this.token);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BizWorksApiConfig)) {
            return false;
        }
        BizWorksApiConfig apiConfig = (BizWorksApiConfig)o;
        if (!this.getServerUrl().equals(apiConfig.getServerUrl())) {
            return false;
        }
        if (this.getAuthType() != apiConfig.getAuthType()) {
            return false;
        }
        return this.getToken().equals(apiConfig.getToken());
    }

    public int hashCode() {
        int result = this.getServerUrl().hashCode();
        result = 31 * result + this.getAuthType().hashCode();
        result = 31 * result + this.getToken().hashCode();
        return result;
    }

    public String toString() {
        return "BizWorksApiConfig(serverUrl=" + this.getServerUrl() + ", authType=" + this.getAuthType() + ", token=" + this.getToken() + ")";
    }
}

